/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import sim.util.Double3D;
import sim.util.Int2D;
import sim.util.Int3D;
import sim.util.MutableDouble3D;
import sim.util.MutableInt2D;

public final class MutableInt3D
implements Serializable,
Cloneable {
    public int x;
    public int y;
    public int z;

    public MutableInt3D() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public MutableInt3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MutableInt3D(Int2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0;
    }

    public MutableInt3D(Int2D p, int z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public MutableInt3D(Int3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public MutableInt3D(MutableInt2D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0;
    }

    public MutableInt3D(MutableInt2D p, int z) {
        this.x = p.x;
        this.y = p.y;
        this.z = z;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setX(int val) {
        this.x = val;
    }

    public final void setY(int val) {
        this.y = val;
    }

    public final void setZ(int val) {
        this.z = val;
    }

    public void setTo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setTo(Int3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public void setTo(MutableInt3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setLocation(Int3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public void setLocation(MutableInt3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public String toString() {
        return "MutableInt3D[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public String toCoordinates() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        int z = this.z;
        z += ~(z << 15);
        z ^= z >>> 10;
        z += z << 3;
        z ^= z >>> 6;
        z += ~(z << 11);
        z ^= z >>> 16;
        z ^= this.y;
        z += 17;
        z += ~(z << 15);
        z ^= z >>> 10;
        z += z << 3;
        z ^= z >>> 6;
        z += ~(z << 11);
        z ^= z >>> 16;
        return this.x ^ z;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Int3D) {
            Int3D other = (Int3D)obj;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }
        if (obj instanceof MutableInt3D) {
            MutableInt3D other = (MutableInt3D)obj;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }
        if (obj instanceof Double3D) {
            Double3D other = (Double3D)obj;
            return other.x == (double)this.x && other.y == (double)this.y && other.z == (double)this.z;
        }
        if (obj instanceof MutableDouble3D) {
            MutableDouble3D other = (MutableDouble3D)obj;
            return other.x == (double)this.x && other.y == (double)this.y && other.z == (double)this.z;
        }
        return false;
    }

    public double distance(double x, double y, double z) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        double dz = (double)this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(Double3D p) {
        double dx = (double)this.x - p.x;
        double dy = (double)this.y - p.y;
        double dz = (double)this.z - p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(MutableInt3D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        double dz = (double)this.z - (double)p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(Int3D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        double dz = (double)this.z - (double)p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSq(double x, double y, double z) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        double dz = (double)this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(Double3D p) {
        double dx = (double)this.x - p.x;
        double dy = (double)this.y - p.y;
        double dz = (double)this.z - p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(MutableInt3D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        double dz = (double)this.z - (double)p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSq(Int3D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        double dz = (double)this.z - (double)p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public long manhattanDistance(int x, int y, int z) {
        return Math.abs((long)this.x - (long)x) + Math.abs((long)this.y - (long)y) + Math.abs((long)this.z - (long)z);
    }

    public long manhattanDistance(MutableInt3D p) {
        return Math.abs((long)this.x - (long)p.x) + Math.abs((long)this.y - (long)p.y) + Math.abs((long)this.z - (long)p.z);
    }

    public long manhattanDistance(Int3D p) {
        return Math.abs((long)this.x - (long)p.x) + Math.abs((long)this.y - (long)p.y) + Math.abs((long)this.z - (long)p.z);
    }
}

