/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NumberTextField
extends JComponent {
    JTextField valField = new JTextField();
    JButton downButton;
    JButton upButton;
    JButton bellyButton;
    JLabel fieldLabel;
    double initialValue;
    double multiply;
    double add;
    protected double currentValue;
    Color defaultColor;
    Color editedColor = new Color(225, 225, 255);
    public static final ImageIcon I_DOWN = NumberTextField.iconFor("LeftArrow.png");
    public static final ImageIcon I_DOWN_PRESSED = NumberTextField.iconFor("LeftArrowPressed.png");
    public static final ImageIcon I_BELLY = NumberTextField.iconFor("BellyButton.png");
    public static final ImageIcon I_BELLY_PRESSED = NumberTextField.iconFor("BellyButtonPressed.png");
    public static final ImageIcon I_UP = NumberTextField.iconFor("RightArrow.png");
    public static final ImageIcon I_UP_PRESSED = NumberTextField.iconFor("RightArrowPressed.png");
    boolean edited = false;
    KeyListener listener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                NumberTextField.this.submit();
            } else if (keyEvent.getKeyCode() == 27) {
                NumberTextField.this.update();
            } else {
                NumberTextField.this.setEdited(true);
            }
        }
    };
    FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            NumberTextField.this.submit();
        }
    };

    public void setEditedColor(Color c) {
        this.editedColor = c;
    }

    public Color getEditedColor() {
        return this.editedColor;
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(NumberTextField.class.getResource(name));
    }

    void setEdited(boolean edited) {
        if (this.edited != edited) {
            this.edited = edited;
            if (edited) {
                this.valField.setBackground(this.editedColor);
            } else {
                this.valField.setBackground(this.defaultColor);
            }
        }
    }

    public void submit() {
        if (this.edited) {
            double val;
            try {
                val = Double.parseDouble(this.valField.getText());
            }
            catch (NumberFormatException e) {
                val = this.initialValue;
            }
            this.setValue(this.newValue(val));
        }
    }

    public void update() {
        this.setValue(this.getValue());
    }

    public void setValue(double val) {
        if ((double)((int)val) == val) {
            this.valField.setText("" + (int)val);
        } else {
            this.valField.setText("" + val);
        }
        this.currentValue = val;
        this.setEdited(false);
    }

    public double getValue() {
        return this.currentValue;
    }

    public JTextField getField() {
        return this.valField;
    }

    public void setInitialValue(double initialValue) {
        this.initialValue = initialValue;
        this.setValue(initialValue);
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public NumberTextField(double initialValue) {
        this(null, initialValue, 0.0, 0.0);
    }

    public NumberTextField(String label, double initialValue) {
        this(label, initialValue, 0.0, 0.0);
    }

    public NumberTextField(double initialValue, boolean doubleEachTime) {
        this(null, initialValue, doubleEachTime);
    }

    public NumberTextField(double initialValue, double multiply, double add) {
        this(null, initialValue, multiply, add);
    }

    public NumberTextField(String label, double initialValue, boolean doubleEachTime) {
        if (doubleEachTime) {
            this.setValues(label, initialValue, 2.0, 0.0);
        } else {
            this.setValues(label, initialValue, 1.0, 1.0);
        }
    }

    public NumberTextField(String label, double initialValue, double multiply, double add) {
        this.setValues(label, initialValue, multiply, add);
    }

    void setValues(String label, double initialValue, double multiply, double add) {
        this.defaultColor = this.valField.getBackground();
        this.initialValue = initialValue;
        this.multiply = multiply;
        this.add = add;
        this.currentValue = initialValue;
        this.setLayout(new BorderLayout());
        if (label != null && label.length() != 0) {
            this.fieldLabel = new JLabel(label);
            this.add((Component)this.fieldLabel, "West");
        }
        this.valField.addKeyListener(this.listener);
        this.valField.addFocusListener(this.focusAdapter);
        this.setValue(initialValue);
        this.add((Component)this.valField, "Center");
        if (multiply != 0.0) {
            Box box = new Box(0);
            this.downButton = new JButton(I_DOWN);
            this.downButton.setPressedIcon(I_DOWN_PRESSED);
            this.downButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NumberTextField.this.setValue(NumberTextField.this.newValue((NumberTextField.this.getValue() - NumberTextField.this.add) / NumberTextField.this.multiply));
                }
            });
            this.downButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.downButton.setBorderPainted(false);
            this.downButton.setContentAreaFilled(false);
            box.add(this.downButton);
            this.bellyButton = new JButton(I_BELLY);
            this.bellyButton.setPressedIcon(I_BELLY_PRESSED);
            this.bellyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NumberTextField.this.setValue(NumberTextField.this.newValue(NumberTextField.this.initialValue));
                }
            });
            this.bellyButton.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.bellyButton.setBorderPainted(false);
            this.bellyButton.setContentAreaFilled(false);
            box.add(this.bellyButton);
            this.upButton = new JButton(I_UP);
            this.upButton.setPressedIcon(I_UP_PRESSED);
            this.upButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NumberTextField.this.setValue(NumberTextField.this.newValue(NumberTextField.this.getValue() * NumberTextField.this.multiply + NumberTextField.this.add));
                }
            });
            this.upButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.upButton.setBorderPainted(false);
            this.upButton.setContentAreaFilled(false);
            box.add(this.upButton);
            this.add((Component)box, "East");
        }
    }

    public double newValue(double newValue) {
        return newValue;
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.downButton != null) {
            this.downButton.setToolTipText(text);
        }
        if (this.upButton != null) {
            this.upButton.setToolTipText(text);
        }
        if (this.bellyButton != null) {
            this.bellyButton.setToolTipText(text);
        }
        if (this.valField != null) {
            this.valField.setToolTipText(text);
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setToolTipText(text);
        }
    }

    public void setEnabled(boolean b) {
        if (this.downButton != null) {
            this.downButton.setEnabled(b);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(b);
        }
        if (this.bellyButton != null) {
            this.bellyButton.setEnabled(b);
        }
        if (this.valField != null) {
            this.valField.setEnabled(b);
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setEnabled(b);
        }
    }
}

