/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import sim.util.gui.WordWrap;

public class Utilities {
    static final int DIALOG_WIDTH = 400;
    static final int TRACE_FRAME_WIDTH = 600;
    static final int TRACE_FRAME_HEIGHT = 400;

    private static int iFloor(double d) {
        int i = (int)d;
        if (d >= 0.0) {
            return i;
        }
        if (d < -2.147483647E9) {
            return Integer.MIN_VALUE;
        }
        if ((double)i == d) {
            return i;
        }
        return i - 1;
    }

    private static int iCeil(double d) {
        int i = (int)d;
        if (d <= 0.0) {
            return i;
        }
        if (d >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if ((double)i == d) {
            return i;
        }
        return i + 1;
    }

    private static int iRound(double d) {
        int i = (int)(d += 0.5);
        if (d >= 0.0) {
            return i;
        }
        if (d < -2.147483647E9) {
            return Integer.MIN_VALUE;
        }
        if ((double)i == d) {
            return i;
        }
        return i - 1;
    }

    public static String ensureFileEndsWith(String filename, String ending) {
        if (filename.regionMatches(false, filename.length() - ending.length(), ending, 0, ending.length())) {
            return filename;
        }
        return filename + ending;
    }

    public static void doEnsuredRepaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component != null) {
                    component.repaint();
                }
            }
        });
    }

    public static Thread doLater(final long milliseconds, final Runnable doThis) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(milliseconds);
                    SwingUtilities.invokeAndWait(doThis);
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        });
        thread.start();
        return thread;
    }

    public static void informOfError(Throwable error, String description, JFrame frame) {
        error.printStackTrace();
        Object[] options = new Object[]{"Show Trace", "Okay"};
        JLabel label = new JLabel();
        Font labelFont = label.getFont();
        Font boldFont = labelFont.deriveFont(1);
        FontMetrics boldFontMetrics = label.getFontMetrics(boldFont);
        Font smallFont = labelFont.deriveFont(labelFont.getSize2D() - 2.0f);
        FontMetrics smallFontMetrics = label.getFontMetrics(smallFont);
        label.setText("<html><p style=\"padding-top: 12pt; padding-right: 50pt; font: " + boldFont.getSize() + "pt " + boldFont.getFamily() + ";\"><b>" + WordWrap.toHTML(WordWrap.wrap("" + description, 400, boldFontMetrics)) + "</b></p>" + "<p style=\"padding-top: 12pt; padding-right: 50pt; padding-bottom: 12pt; font: " + smallFont.getSize() + "pt " + smallFont.getFamily() + ";\">" + error + "</p></html>");
        int n = JOptionPane.showOptionDialog(frame, label, "Error", 0, 0, null, options, options[1]);
        if (n == 0) {
            StringWriter writer = new StringWriter();
            PrintWriter pWriter = new PrintWriter(writer);
            error.printStackTrace(pWriter);
            pWriter.flush();
            JTextArea area = new JTextArea(writer.toString());
            area.setFont(new Font("Monospaced", 0, 12));
            JScrollPane pane = new JScrollPane(area){

                public Dimension getPreferredSize() {
                    return new Dimension(600, 400);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(600, 400);
                }
            };
            JOptionPane.showMessageDialog(null, pane);
        }
    }

    public static void inform(String description, String subDescription, JFrame frame) {
        Object[] options = new Object[]{"Okay"};
        JLabel label = new JLabel();
        Font labelFont = label.getFont();
        Font boldFont = labelFont.deriveFont(1);
        FontMetrics boldFontMetrics = label.getFontMetrics(boldFont);
        Font smallFont = labelFont.deriveFont(labelFont.getSize2D() - 2.0f);
        FontMetrics smallFontMetrics = label.getFontMetrics(smallFont);
        label.setText("<html><p style=\"padding-top: 12pt; padding-right: 50pt; font: " + boldFont.getSize() + "pt " + boldFont.getFamily() + ";\"><b>" + WordWrap.toHTML(WordWrap.wrap("" + description, 400, boldFontMetrics)) + "</b></p>" + "<p style=\"padding-top: 12pt; padding-right: 50pt; padding-bottom: 12pt; font: " + smallFont.getSize() + "pt " + smallFont.getFamily() + ";\">" + WordWrap.toHTML(WordWrap.wrap("" + subDescription, 400, smallFontMetrics)) + "</p></html>");
        JOptionPane.showMessageDialog(frame, label, "Error", 1);
    }
}

