/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.media.CannotRealizeException;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.util.ImageToBuffer;
import sim.util.media.MovieEncoderDataSource;

public class MovieEncoder
implements DataSinkListener,
ControllerListener,
Serializable {
    boolean started;
    boolean stopped;
    int width;
    int height;
    int type;
    float frameRate;
    Processor processor;
    MovieEncoderDataSource source;
    DataSink sink;
    File file;
    Format encodeFormat;
    final Object waitSync = new Object();
    boolean stateTransitionOK = true;
    final Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public static Format[] getEncodingFormats(float fps, BufferedImage typicalImage) {
        return new MovieEncoder().getEncodingFormatsHelper(fps, typicalImage);
    }

    private Format[] getEncodingFormatsHelper(float fps, BufferedImage typicalImage) {
        try {
            Format format = ImageToBuffer.createBuffer((Image)typicalImage, (float)fps).getFormat();
            MovieEncoderDataSource source = new MovieEncoderDataSource(format, fps);
            Processor processor = Manager.createProcessor((DataSource)source);
            processor.addControllerListener((ControllerListener)this);
            processor.configure();
            if (!this.waitForState(processor, 180)) {
                throw new RuntimeException("Failed to configure processor");
            }
            processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
            TrackControl[] tcs = processor.getTrackControls();
            Format[] f = tcs[0].getSupportedFormats();
            if (f == null || f.length <= 0) {
                throw new RuntimeException("The mux does not support the input format: " + tcs[0].getFormat());
            }
            processor.removeControllerListener((ControllerListener)this);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processor.removeControllerListener((ControllerListener)this);
            return null;
        }
    }

    MovieEncoder() {
    }

    public MovieEncoder(float frameRate, File file, BufferedImage typicalImage, Format encodeFormat) {
        this.frameRate = frameRate;
        this.file = file;
        this.encodeFormat = encodeFormat;
        try {
            this.setup(typicalImage);
            this.started = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        }
        if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        }
        if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            try {
                evt.getSourceController().close();
            }
            catch (Exception e) {
                System.err.println("Spurious Sun JMF Error?\n\n");
                e.printStackTrace();
                Object object = this.waitSync;
                synchronized (object) {
                    this.stateTransitionOK = false;
                    this.waitSync.notifyAll();
                }
                object = this.waitFileSync;
                synchronized (object) {
                    this.fileSuccess = false;
                    this.fileDone = true;
                    this.waitFileSync.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    void setup(BufferedImage i) throws IOException, NoDataSinkException, NoProcessorException, CannotRealizeException, RuntimeException {
        this.width = i.getWidth();
        this.height = i.getHeight();
        this.type = i.getType();
        Format format = ImageToBuffer.createBuffer((Image)i, (float)this.frameRate).getFormat();
        this.source = new MovieEncoderDataSource(format, this.frameRate);
        this.processor = Manager.createProcessor((DataSource)this.source);
        this.processor.addControllerListener((ControllerListener)this);
        this.processor.configure();
        if (!this.waitForState(this.processor, 180)) {
            throw new RuntimeException("Failed to configure processor");
        }
        this.processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = this.processor.getTrackControls();
        tcs[0].setFormat(this.encodeFormat);
        this.processor.realize();
        if (!this.waitForState(this.processor, 300)) {
            throw new RuntimeException("Failed to Realize processor");
        }
        this.sink = Manager.createDataSink((DataSource)this.processor.getDataOutput(), (MediaLocator)new MediaLocator(this.file.toURI().toURL()));
        this.sink.addDataSinkListener((DataSinkListener)this);
        this.sink.open();
        this.processor.start();
        this.sink.start();
        this.started = true;
    }

    BufferedImage preprocess(BufferedImage i) {
        if (i.getWidth() != this.width || i.getHeight() != this.height || i.getType() != this.type) {
            BufferedImage temp = new BufferedImage(this.width, this.height, this.type);
            Graphics2D g = temp.createGraphics();
            g.drawImage((Image)i, 0, 0, null);
            i = temp;
        }
        return i;
    }

    public synchronized boolean add(BufferedImage i) {
        if (!this.stopped) {
            i = this.preprocess(i);
            this.source.add(i);
        }
        return !this.stopped;
    }

    public synchronized boolean stop() {
        if (!this.started) {
            return false;
        }
        if (this.stopped) {
            return false;
        }
        this.stopped = true;
        this.source.finish();
        boolean success = this.waitForFileDone();
        try {
            this.sink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processor.removeControllerListener((ControllerListener)this);
        this.stopped = true;
        return success;
    }
}

