/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import sim.display.SimApplet;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.PropertyField;
import sim.util.gui.Utilities;
import sim.util.media.PDFEncoder;
import sim.util.media.chart.SeriesAttributes;

public abstract class ChartGenerator
extends JPanel {
    protected Box globalAttributes = Box.createVerticalBox();
    protected Box seriesAttributes = Box.createVerticalBox();
    protected JFreeChart chart;
    protected ChartPanel chartPanel;
    protected JScrollPane chartHolder = new JScrollPane();
    JFrame frame;
    PropertyField titleField;
    PropertyField xLabel;
    PropertyField yLabel;
    JCheckBox yLog;
    JCheckBox xLog;
    JButton movieButton = new JButton("Create Movie");
    BufferedImage buffer;
    MovieMaker movieMaker = null;
    static final long INITIAL_KEY = -1L;
    public static final long FORCE_KEY = -2L;
    long oldKey = -1L;
    Thread timer = null;

    public JFrame getFrame() {
        return this.frame;
    }

    public void setXAxisLogScaled(boolean isLogScaled) {
        this.xLog.setSelected(isLogScaled);
    }

    public boolean isXAxisLogScaled() {
        return this.xLog.isSelected();
    }

    public void setYAxisLogScaled(boolean isLogScaled) {
        this.yLog.setSelected(isLogScaled);
    }

    public boolean isYAxisLogScaled() {
        return this.yLog.isSelected();
    }

    public XYDataset getSeriesDataset() {
        return ((XYPlot)this.chart.getPlot()).getDataset();
    }

    public void setSeriesDataset(XYDataset obj) {
        ((XYPlot)this.chart.getPlot()).setDataset(obj);
    }

    BufferedImage getBufferedImage() {
        if (this.buffer == null || this.buffer.getWidth(null) != this.chartPanel.getWidth() || this.buffer.getHeight(null) != this.chartPanel.getHeight()) {
            this.buffer = this.getGraphicsConfiguration().createCompatibleImage(this.chartPanel.getWidth(), this.chartPanel.getHeight());
        }
        Graphics2D g = (Graphics2D)this.buffer.getGraphics();
        g.setColor(this.chartPanel.getBackground());
        g.fillRect(0, 0, this.buffer.getWidth(null), this.buffer.getHeight(null));
        this.chartPanel.paintComponent((Graphics)g);
        g.dispose();
        return this.buffer;
    }

    public void update(long key, boolean newData) {
        if (key == this.oldKey && key != -2L) {
            return;
        }
        this.oldKey = key;
        this.update();
        if (newData) {
            this.chart.getPlot().datasetChanged(new DatasetChangeEvent((Object)this.chart.getPlot(), null));
        }
        if (newData && this.movieMaker != null) {
            this.movieMaker.add(this.getBufferedImage());
        }
    }

    protected void update() {
    }

    void rebuildAttributeIndices() {
        SeriesAttributes[] c = this.getSeriesAttributes();
        for (int i = 0; i < c.length; ++i) {
            SeriesAttributes csa = c[i];
            csa.setSeriesIndex(i);
            csa.rebuildGraphicsDefinitions();
        }
        this.revalidate();
    }

    protected SeriesAttributes getSeriesAttribute(int i) {
        return (SeriesAttributes)this.seriesAttributes.getComponent(i);
    }

    public int getNumSeriesAttributes() {
        return this.seriesAttributes.getComponents().length;
    }

    protected SeriesAttributes[] getSeriesAttributes() {
        Component[] c = this.seriesAttributes.getComponents();
        SeriesAttributes[] sa = new SeriesAttributes[c.length];
        System.arraycopy(c, 0, sa, 0, c.length);
        return sa;
    }

    protected void setSeriesAttributes(SeriesAttributes[] c) {
        this.seriesAttributes.removeAll();
        for (int i = 0; i < c.length; ++i) {
            this.seriesAttributes.add(c[i]);
        }
    }

    public void removeSeries(int index) {
        SeriesAttributes[] c = this.getSeriesAttributes();
        SeriesChangeListener tmpObj = c[index].getStoppable();
        if (tmpObj != null) {
            tmpObj.seriesChanged(new SeriesChangeEvent((Object)this));
        }
        Component comp = this.seriesAttributes.getComponent(index);
        ((SeriesAttributes)comp).setSeriesIndex(-1);
        this.seriesAttributes.remove(index);
        this.rebuildAttributeIndices();
        this.revalidate();
    }

    public void moveSeries(int index, boolean up) {
        if (index > 0 && up || index < this.getSeriesDataset().getSeriesCount() - 1 && !up) {
            SeriesAttributes[] c = this.getSeriesAttributes();
            if (up) {
                SeriesAttributes s2;
                SeriesAttributes s1 = c[index];
                c[index] = s2 = c[index - 1];
                c[index - 1] = s1;
            } else {
                SeriesAttributes s2;
                SeriesAttributes s1 = c[index];
                c[index] = s2 = c[index + 1];
                c[index + 1] = s1;
            }
            this.setSeriesAttributes(c);
            this.rebuildAttributeIndices();
            this.revalidate();
        }
    }

    protected abstract void buildChart();

    public void startMovie() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        if (this.movieMaker != null) {
            return;
        }
        this.movieMaker = new MovieMaker(this.getFrame());
        if (!this.movieMaker.start(this.getBufferedImage())) {
            this.movieMaker = null;
        } else {
            this.movieButton.setText("Stop Movie");
            this.update(-2L, true);
        }
    }

    public void stopMovie() {
        if (this.movieMaker == null) {
            return;
        }
        if (!this.movieMaker.stop()) {
            Object[] options = new Object[]{"Drat"};
            JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
        }
        this.movieMaker = null;
        if (this.movieButton != null) {
            this.movieButton.setText("Create Movie");
        }
    }

    public void removeAllSeries() {
        for (int x = this.getSeriesDataset().getSeriesCount() - 1; x >= 0; --x) {
            this.removeSeries(x);
        }
    }

    public void quit() {
        if (this.movieMaker != null) {
            this.movieMaker.stop();
        }
        this.removeAllSeries();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void addGlobalAttribute(Component component) {
        this.globalAttributes.add(component);
    }

    public Component getGlobalAttribute(int index) {
        return this.globalAttributes.getComponent(index + 2);
    }

    public int getGlobalAttributeCount() {
        return this.getNumGlobalAttributes();
    }

    public int getNumGlobalAttributes() {
        return this.globalAttributes.getComponentCount() - 2;
    }

    public Component removeGlobalAttribute(int index) {
        Component component = this.getGlobalAttribute(index);
        this.globalAttributes.remove(index);
        return component;
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
        this.chart.titleChanged(new TitleChangeEvent((Title)new TextTitle(title)));
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
        this.titleField.setValue(title);
    }

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setRangeAxisLabel(String val) {
        this.setYAxisLabel(val);
    }

    public void setYAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getRangeAxis()));
        this.yLabel.setValue(val);
    }

    public String getRangeAxisLabel() {
        return this.getYAxisLabel();
    }

    public String getYAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getRangeAxis().getLabel();
    }

    public void setDomainAxisLabel(String val) {
        this.setXAxisLabel(val);
    }

    public void setXAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getDomainAxis()));
        this.xLabel.setValue(val);
    }

    public String getDomainAxisLabel() {
        return this.getXAxisLabel();
    }

    public String getXAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getDomainAxis().getLabel();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public ChartGenerator() {
        this.buildChart();
        this.chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        ((XYPlot)this.chart.getPlot()).setDomainGridlinesVisible(false);
        ((XYPlot)this.chart.getPlot()).setRangeGridlinesVisible(false);
        ((XYPlot)this.chart.getPlot()).setDomainGridlinePaint((Paint)new Color(200, 200, 200));
        ((XYPlot)this.chart.getPlot()).setRangeGridlinePaint((Paint)new Color(200, 200, 200));
        JSplitPane split = new JSplitPane(1, true);
        split.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane scroll = new JScrollPane();
        JPanel b = new JPanel();
        b.setLayout(new BorderLayout());
        b.add((Component)this.seriesAttributes, "North");
        b.add((Component)new JPanel(), "Center");
        scroll.getViewport().setView(b);
        scroll.setBackground(this.getBackground());
        scroll.getViewport().setBackground(this.getBackground());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        LabelledList list = new LabelledList("Chart Properties");
        DisclosurePanel pan1 = new DisclosurePanel("Chart Properties", (Component)list);
        this.globalAttributes.add(pan1);
        JLabel j = new JLabel("Right-Click or Control-Click");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        j = new JLabel("on Chart for More Options");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        this.titleField = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setTitle(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.titleField.setValue(this.chart.getTitle().getText());
        list.add((Component)new JLabel("Title"), (Component)this.titleField);
        this.xLabel = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setXAxisLabel(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.xLabel.setValue(this.getXAxisLabel());
        list.add((Component)new JLabel("X Label"), (Component)this.xLabel);
        this.yLabel = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setYAxisLabel(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.yLabel.setValue(this.getYAxisLabel());
        list.add((Component)new JLabel("Y Label"), (Component)this.yLabel);
        this.xLog = new JCheckBox();
        this.xLog.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ChartGenerator.this.xLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(ChartGenerator.this.xLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    ChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)logAxis);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)new NumberAxis(ChartGenerator.this.xLabel.getValue()));
                }
            }
        });
        list.add((Component)new JLabel("Log X axis"), (Component)this.xLog);
        this.yLog = new JCheckBox();
        this.yLog.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ChartGenerator.this.yLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(ChartGenerator.this.yLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    ChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)logAxis);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)new NumberAxis(ChartGenerator.this.yLabel.getValue()));
                }
            }
        });
        list.add((Component)new JLabel("Log Y axis"), (Component)this.yLog);
        JCheckBox xgridlines = new JCheckBox();
        xgridlines.setSelected(false);
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ChartGenerator.this.chart.getXYPlot().setDomainGridlinesVisible(true);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setDomainGridlinesVisible(false);
                }
            }
        };
        xgridlines.addItemListener(il);
        list.add((Component)new JLabel("X Grid Lines"), (Component)xgridlines);
        JCheckBox ygridlines = new JCheckBox();
        ygridlines.setSelected(false);
        il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ChartGenerator.this.chart.getXYPlot().setRangeGridlinesVisible(true);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setRangeGridlinesVisible(false);
                }
            }
        };
        ygridlines.addItemListener(il);
        list.add((Component)new JLabel("Y Grid Lines"), (Component)ygridlines);
        JCheckBox legendCheck = new JCheckBox();
        legendCheck.setSelected(false);
        il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LegendTitle title = new LegendTitle((LegendItemSource)ChartGenerator.this.chart.getXYPlot());
                    title.setLegendItemGraphicPadding(new RectangleInsets(0.0, 8.0, 0.0, 4.0));
                    ChartGenerator.this.chart.addLegend(title);
                } else {
                    ChartGenerator.this.chart.removeLegend();
                }
            }
        };
        legendCheck.addItemListener(il);
        list.add((Component)new JLabel("Legend"), (Component)legendCheck);
        JCheckBox aliasCheck = new JCheckBox();
        aliasCheck.setSelected(this.chart.getAntiAlias());
        il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ChartGenerator.this.chart.setAntiAlias(e.getStateChange() == 1);
            }
        };
        aliasCheck.addItemListener(il);
        list.add((Component)new JLabel("Antialias"), (Component)aliasCheck);
        JPanel pdfButtonPanel = new JPanel();
        pdfButtonPanel.setBorder(new TitledBorder("Chart Output"));
        DisclosurePanel pan2 = new DisclosurePanel("Chart Output", (Component)pdfButtonPanel);
        pdfButtonPanel.setLayout(new BorderLayout());
        Box pdfbox = new Box(1);
        pdfButtonPanel.add((Component)pdfbox, "West");
        JButton pdfButton = new JButton("Save as PDF");
        pdfbox.add(pdfButton);
        pdfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)ChartGenerator.this.frame, "Choose PDF file...", 1);
                fd.setFile(ChartGenerator.this.chart.getTitle().getText() + ".pdf");
                fd.setVisible(true);
                String fileName = fd.getFile();
                if (fileName != null) {
                    Dimension dim = ChartGenerator.this.chartPanel.getPreferredSize();
                    PDFEncoder.generatePDF(ChartGenerator.this.chart, dim.width, dim.height, new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".pdf")));
                }
            }
        });
        this.movieButton = new JButton("Create a Movie");
        pdfbox.add(this.movieButton);
        pdfbox.add(Box.createGlue());
        this.movieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ChartGenerator.this.movieMaker == null) {
                    ChartGenerator.this.startMovie();
                } else {
                    ChartGenerator.this.stopMovie();
                }
            }
        });
        this.globalAttributes.add(pan2);
        Box outerAttributes = Box.createVerticalBox();
        outerAttributes.add(this.globalAttributes);
        outerAttributes.add(Box.createGlue());
        p.add((Component)outerAttributes, "North");
        p.add((Component)scroll, "Center");
        p.setMinimumSize(new Dimension(0, 0));
        p.setPreferredSize(new Dimension(200, 0));
        split.setLeftComponent(p);
        this.chartHolder.setMinimumSize(new Dimension(0, 0));
        split.setRightComponent(this.chartHolder);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
    }

    public JFrame createFrame() {
        this.frame = new JFrame(){

            public void dispose() {
                ChartGenerator.this.quit();
                super.dispose();
            }
        };
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.setResizable(true);
        this.frame.pack();
        this.frame.setTitle(this.chart.getTitle().getText());
        return this.frame;
    }

    public JFrame createFrame(Object simulation) {
        return this.createFrame();
    }

    public void addLegend() {
        if (this.chart.getLegend() != null) {
            return;
        }
        LegendTitle title = new LegendTitle((LegendItemSource)this.chart.getXYPlot());
        title.setLegendItemGraphicPadding(new RectangleInsets(0.0, 8.0, 0.0, 4.0));
        this.chart.addLegend(title);
    }

    public void setRangeAxisRange(double lower, double upper) {
        this.setYAxisRange(lower, upper);
    }

    public void setYAxisRange(double lower, double upper) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setRange(lower, upper);
    }

    public void setDomainAxisRange(double lower, double upper) {
        this.setXAxisRange(lower, upper);
    }

    public void setXAxisRange(double lower, double upper) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setRange(lower, upper);
    }

    public void updateChartWithin(final long key, long milliseconds) {
        if (this.timer == null) {
            this.timer = Utilities.doLater(milliseconds, new Runnable(){

                public void run() {
                    ChartGenerator.this.update(key, true);
                    ChartGenerator.this.timer = null;
                }
            });
        }
    }

    public void updateChartLater(final long key) {
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChartGenerator.this.update(key, true);
            }
        });
    }

    static {
        try {
            String version = System.getProperty("java.version");
            if (!version.startsWith("1.3")) {
                UIManager.put("ColorChooserUI", Class.forName("ch.randelshofer.quaqua.Quaqua14ColorChooserUI").getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

