/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.HistogramSeriesAttributes;
import sim.util.media.chart.SeriesAttributes;

public class HistogramGenerator
extends ChartGenerator {
    HistogramType histogramType = HistogramType.FREQUENCY;

    public void removeSeries(int index) {
        super.removeSeries(index);
        this.update();
    }

    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        this.update();
    }

    protected void buildChart() {
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.FREQUENCY);
        this.chart = ChartFactory.createHistogram((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(true);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setPreferredSize(new Dimension(640, 480));
        this.chartPanel.setMinimumDrawHeight(10);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.chartPanel.setMinimumDrawWidth(20);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartHolder.getViewport().setView((Component)this.chartPanel);
        ((XYBarRenderer)this.chart.getXYPlot().getRenderer()).setShadowVisible(false);
        ((XYBarRenderer)this.chart.getXYPlot().getRenderer()).setBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.setSeriesDataset((XYDataset)dataset);
    }

    public void update() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(this.histogramType);
        for (int i = 0; i < sa.length; ++i) {
            HistogramSeriesAttributes attributes = (HistogramSeriesAttributes)sa[i];
            dataset.addSeries((Comparable)((Object)attributes.getName()), attributes.getValues(), attributes.getNumBins());
        }
        this.setSeriesDataset((XYDataset)dataset);
    }

    public HistogramGenerator() {
        LabelledList list = new LabelledList("Show Histograms...");
        DisclosurePanel pan1 = new DisclosurePanel("Show Histogram...", (Component)list);
        final HistogramType[] styles = new HistogramType[]{HistogramType.FREQUENCY, HistogramType.RELATIVE_FREQUENCY, HistogramType.SCALE_AREA_TO_1};
        final JComboBox<String> style = new JComboBox<String>(new String[]{"By Frequency", "By Relative Frequency", "With Area = 1.0"});
        style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HistogramGenerator.this.histogramType = styles[style.getSelectedIndex()];
                HistogramDataset dataset = (HistogramDataset)HistogramGenerator.this.getSeriesDataset();
                dataset.setType(HistogramGenerator.this.histogramType);
            }
        });
        list.add(style);
        this.addGlobalAttribute(pan1);
    }

    public HistogramSeriesAttributes addSeries(double[] vals, int bins, String name, SeriesChangeListener stopper) {
        if (vals == null || vals.length == 0) {
            vals = new double[]{0.0};
        }
        HistogramDataset dataset = (HistogramDataset)this.getSeriesDataset();
        int i = dataset.getSeriesCount();
        dataset.setType(this.histogramType);
        dataset.addSeries((Comparable)((Object)name), vals, bins);
        HistogramSeriesAttributes csa = new HistogramSeriesAttributes(this, name, i, vals, bins, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HistogramGenerator.this.update();
            }
        });
        return csa;
    }

    public void updateSeries(int index, double[] vals) {
        if (index < 0) {
            return;
        }
        if (vals == null || vals.length == 0) {
            vals = new double[]{0.0};
        }
        HistogramSeriesAttributes hsa = (HistogramSeriesAttributes)this.getSeriesAttribute(index);
        hsa.setValues(vals);
    }

    public void setHistogramType(HistogramType type) {
        this.histogramType = type;
    }

    public HistogramType getHistogramType() {
        return this.histogramType;
    }
}

