/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.ScatterPlotSeriesAttributes;
import sim.util.media.chart.SeriesAttributes;

public class ScatterPlotGenerator
extends ChartGenerator {
    public void removeSeries(int index) {
        super.removeSeries(index);
        this.update();
    }

    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        this.update();
    }

    protected void buildChart() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        this.chart = ChartFactory.createScatterPlot((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(true);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setPreferredSize(new Dimension(640, 480));
        this.chartPanel.setMinimumDrawHeight(10);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.chartPanel.setMinimumDrawWidth(20);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartHolder.getViewport().setView((Component)this.chartPanel);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)new XYLineAndShapeRenderer(false, true));
        this.setSeriesDataset((XYDataset)dataset);
    }

    public void update() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        DefaultXYDataset dataset = new DefaultXYDataset();
        for (int i = 0; i < sa.length; ++i) {
            ScatterPlotSeriesAttributes attributes = (ScatterPlotSeriesAttributes)sa[i];
            dataset.addSeries((Comparable)((Object)attributes.getName()), attributes.getValues());
        }
        this.setSeriesDataset((XYDataset)dataset);
    }

    public ScatterPlotSeriesAttributes addSeries(double[][] values, String name, SeriesChangeListener stopper) {
        DefaultXYDataset dataset = (DefaultXYDataset)this.getSeriesDataset();
        int i = dataset.getSeriesCount();
        dataset.addSeries((Comparable)((Object)name), values);
        ScatterPlotSeriesAttributes csa = new ScatterPlotSeriesAttributes(this, name, i, values, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScatterPlotGenerator.this.update();
            }
        });
        return csa;
    }

    public void updateSeries(int index, double[][] vals) {
        if (index < 0) {
            return;
        }
        ScatterPlotSeriesAttributes series = (ScatterPlotSeriesAttributes)this.getSeriesAttribute(index);
        series.setValues(vals);
    }
}

