/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesChangeListener;
import sim.util.gui.ColorWell;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.ScatterPlotGenerator;
import sim.util.media.chart.SeriesAttributes;

public class ScatterPlotSeriesAttributes
extends SeriesAttributes {
    static int shapeCounter = -1;
    static final Shape[] shapes = ScatterPlotSeriesAttributes.buildShapes();
    static final String[] shapeNames = new String[]{"Circle", "Square", "Diamond", "Cross", "X", "Up Triangle", "Down Triangle"};
    double[][] values;
    Color color;
    ColorWell colorWell;
    double opacity;
    NumberTextField opacityField;
    int shapeNum = 0;
    Shape shape = shapes[this.shapeNum];
    JComboBox shapeList;

    static Shape[] buildShapes() {
        Shape[] s = new Shape[7];
        GeneralPath g = null;
        s[0] = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        Rectangle2D.Double r = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
        s[1] = r;
        s[2] = AffineTransform.getRotateInstance(0.7853981633974483).createTransformedShape(r);
        g = new GeneralPath();
        g.moveTo(-0.5f, -3.0f);
        g.lineTo(-0.5f, -0.5f);
        g.lineTo(-3.0f, -0.5f);
        g.lineTo(-3.0f, 0.5f);
        g.lineTo(-0.5f, 0.5f);
        g.lineTo(-0.5f, 3.0f);
        g.lineTo(0.5f, 3.0f);
        g.lineTo(0.5f, 0.5f);
        g.lineTo(3.0f, 0.5f);
        g.lineTo(3.0f, -0.5f);
        g.lineTo(0.5f, -0.5f);
        g.lineTo(0.5f, -3.0f);
        g.closePath();
        s[3] = g;
        s[4] = g.createTransformedShape(AffineTransform.getRotateInstance(0.7853981633974483));
        g = new GeneralPath();
        g.moveTo(0.0f, -3.0f);
        g.lineTo(-3.0f, 3.0f);
        g.lineTo(3.0f, 3.0f);
        g.closePath();
        s[5] = g;
        s[6] = g.createTransformedShape(AffineTransform.getRotateInstance(Math.PI));
        return s;
    }

    double[][] getValues() {
        return this.values;
    }

    void setValues(double[][] vals) {
        this.values = vals;
    }

    public void setSymbolOpacity(double value) {
        this.opacityField.setValue(this.opacityField.newValue(value));
    }

    public double getSymbolOpacity() {
        return this.opacityField.getValue();
    }

    public void setSymbolColor(Color value) {
        this.color = value;
        this.colorWell.setColor(this.color);
    }

    public Color getSymbolColor() {
        return this.color;
    }

    public void setShapeNum(int value) {
        if (value >= 0 && value < shapes.length) {
            this.shapeList.setSelectedIndex(value);
            this.shapeNum = value;
            this.shape = shapes[this.shapeNum];
        }
    }

    public int getShapeNum() {
        return this.shapeNum;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ScatterPlotSeriesAttributes(ChartGenerator generator, String name, int index, double[][] values, SeriesChangeListener stoppable) {
        super(generator, name, index, stoppable);
        this.setValues(values);
        super.setName(name);
        if (++shapeCounter >= shapes.length) {
            shapeCounter = 0;
        }
        this.shapeNum = shapeCounter;
        this.shape = shapes[this.shapeNum];
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.getRenderer();
        renderer.setSeriesShape(this.getSeriesIndex(), this.shape);
        renderer.setAutoPopulateSeriesShape(false);
    }

    public void setName(String val) {
        this.setName(val);
        ((ScatterPlotGenerator)this.generator).update();
    }

    public void rebuildGraphicsDefinitions() {
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.getRenderer();
        renderer.setSeriesPaint(this.getSeriesIndex(), (Paint)this.reviseColor(this.color, this.opacity));
        renderer.setSeriesShape(this.getSeriesIndex(), this.shape);
        renderer.setAutoPopulateSeriesShape(false);
        this.repaint();
    }

    public void buildAttributes() {
        this.opacity = 1.0;
        this.color = (Color)this.getRenderer().getItemPaint(this.getSeriesIndex(), -1);
        this.color = (Color)this.getRenderer().getSeriesPaint(this.getSeriesIndex());
        this.colorWell = new ColorWell(this.color){

            public Color changeColor(Color c) {
                ScatterPlotSeriesAttributes.this.color = c;
                ScatterPlotSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Color", this.colorWell);
        this.opacityField = new NumberTextField("Opacity ", this.opacity, 1.0, 0.125){

            public double newValue(double newValue) {
                if (newValue < 0.0 || newValue > 1.0) {
                    newValue = this.currentValue;
                }
                ScatterPlotSeriesAttributes.this.opacity = (float)newValue;
                ScatterPlotSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("", this.opacityField);
        this.shapeList = new JComboBox();
        this.shapeList.setEditable(false);
        this.shapeList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList(shapeNames))));
        this.shapeList.setSelectedIndex(this.shapeNum);
        this.shapeList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScatterPlotSeriesAttributes.this.shapeNum = ScatterPlotSeriesAttributes.this.shapeList.getSelectedIndex();
                ScatterPlotSeriesAttributes.this.shape = shapes[ScatterPlotSeriesAttributes.this.shapeNum];
                ScatterPlotSeriesAttributes.this.rebuildGraphicsDefinitions();
            }
        });
        this.addLabelled("Shape", this.shapeList);
    }
}

