/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.DataCuller;
import sim.util.media.chart.MinGapDataCuller;
import sim.util.media.chart.TimeSeriesAttributes;

public class TimeSeriesChartGenerator
extends ChartGenerator {
    JCheckBox useCullingCheckBox;
    NumberTextField maxPointsPerSeriesTextField;
    DataCuller dataCuller;

    public void removeSeries(int index) {
        super.removeSeries(index);
        XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
        xysc.removeSeries(index);
    }

    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        if (index > 0 && up || index < this.getSeriesDataset().getSeriesCount() - 1 && !up) {
            XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
            ArrayList items = new ArrayList(xysc.getSeries());
            xysc.removeAllSeries();
            int delta = up ? -1 : 1;
            items.add(index + delta, items.remove(index));
            for (int i = 0; i < items.size(); ++i) {
                xysc.addSeries((XYSeries)items.get(i));
            }
        }
    }

    public TimeSeriesAttributes addSeries(XYSeries series, SeriesChangeListener stopper) {
        XYSeriesCollection xysc = (XYSeriesCollection)this.getSeriesDataset();
        int i = xysc.getSeriesCount();
        xysc.addSeries(series);
        TimeSeriesAttributes csa = new TimeSeriesAttributes((ChartGenerator)this, series, i, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        return csa;
    }

    protected void buildChart() {
        XYSeriesCollection collection = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (XYDataset)collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ((XYLineAndShapeRenderer)((XYPlot)this.chart.getPlot()).getRenderer()).setDrawSeriesLineAsPath(true);
        this.chart.setAntiAlias(true);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setPreferredSize(new Dimension(640, 480));
        this.chartPanel.setMinimumDrawHeight(10);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.chartPanel.setMinimumDrawWidth(20);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartHolder.getViewport().setView((Component)this.chartPanel);
        this.setSeriesDataset((XYDataset)collection);
    }

    public DataCuller getDataCuller() {
        return this.dataCuller;
    }

    public void setDataCuller(DataCuller dataCuller) {
        this.dataCuller = dataCuller;
    }

    public TimeSeriesChartGenerator() {
        LabelledList globalAttribList = (LabelledList)((DisclosurePanel)this.getGlobalAttribute(-2)).getDisclosedComponent();
        this.useCullingCheckBox = new JCheckBox();
        globalAttribList.add((Component)new JLabel("Cull Data"), (Component)this.useCullingCheckBox);
        this.maxPointsPerSeriesTextField = new NumberTextField(1000.0){

            public double newValue(double val) {
                int max = (int)val;
                if (val < 2.0) {
                    return (int)this.getValue();
                }
                TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(max);
                return max;
            }
        };
        this.useCullingCheckBox.setSelected(true);
        globalAttribList.add((Component)new JLabel("... Over"), (Component)this.maxPointsPerSeriesTextField);
        this.maxPointsPerSeriesTextField.setToolTipText("The maximum number of data points in a series before data culling gets triggered.");
        this.dataCuller = new MinGapDataCuller((int)this.maxPointsPerSeriesTextField.getValue());
        this.useCullingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (TimeSeriesChartGenerator.this.useCullingCheckBox.isSelected()) {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(true);
                    int maxPoints = (int)TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.getValue();
                    TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(maxPoints);
                } else {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(false);
                    TimeSeriesChartGenerator.this.dataCuller = null;
                }
            }
        });
    }
}

