/*
 * Decompiled with CFR 0.152.
 */
package sim.app.celegans;

import java.util.ArrayList;
import java.util.HashMap;
import sim.app.celegans.Celegans;
import sim.app.celegans.Synapse;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Double3D;

public class Cell
implements Steppable {
    private static final long serialVersionUID = 1L;
    public Cell parent;
    public int expressionPattern;
    public static final String[] expressionPatterns = new String[]{"", "Expr8", "Expr12", "Expr15", "Expr21", "Expr24", "Expr28", "Expr29", "Expr35", "Expr38", "Expr29", "Expr49", "Expr56", "Expr67", "Expr68"};
    public int cellGroup;
    public static final String[] cellGroups = new String[]{"", "GLR", "e1", "e2", "gon_herm_anch", "gon_herm_dish_A", "gon_herm_dish_P", "gon_herm_dut", "gon_herm_prsh_A", "gon_herm_prsh_P", "gon_herm_spth_A", "gon_herm_spth_P", "gon_herm_sujn_A", "gon_herm_sujn_P", "gon_herm_vut", "hyp10", "hyp3", "hyp4", "hyp5", "hyp6", "hyp7", "hyp8/9", "int_emb", "int_post", "m2", "m4", "m6", "m7", "mu_bod", "rectal epithelium", "se_herm", "seam", "um1", "um2", "vm1", "vm2", "vulvaA", "vulvaB", "vulvaC", "vulvaD", "vulvaE", "vulvaF"};
    public int fate;
    public static final String[] fates = new String[]{"", "Dies", "Muscle", "Hypodermis", "Intestine", "Neuron", "Pharynx"};
    public int type;
    public static final String[] types = new String[]{"Founding / Unknown", "Preembryonic", "Postembryonic", "Postembryonic Dual Origin", "Postembryonic Unknown"};
    public Cell[] daughters;
    public int num_children = 0;
    public int birthday;
    public int death_day;
    public String official_name = "";
    public String lineage_name = "";
    public String remark = "";
    public double[] location_x;
    public double[] location_y;
    public double[] location_z;
    public double[] location_t;
    public int location_size;
    public ArrayList synapses;
    public float radius = 1.0f;
    public double[] split_radius_distance;
    public Cell[] equivalence_origin;
    public Cell[] equivalence_fate;
    public int num_equivalence_fate;
    public int num_equivalence_origin;
    public double embryo_division_time = -1.0;
    public double time_born = -1.0;
    public int location_max = 0;
    public static int initial_location_size = 4;
    public static double initial_split_radius_distance = 2.0;
    public static int post_embryonic_birthday = 500;
    public static int maximum_death_day = 1000;
    public static char cell_type_preembryonic_unknown_position = '\u0000';
    public static char cell_type_preembryonic = '\u0001';
    public static char cell_type_postembryonic = (char)2;
    public static char cell_type_postembryonic_dual_origin = (char)3;
    public static char cell_type_postembryonic_unknown_position = (char)4;
    double[] loc_xyz = new double[3];
    public Stoppable stopper;

    public Cell getParent() {
        return this.parent;
    }

    public String getExpressionPattern() {
        return expressionPatterns[this.expressionPattern];
    }

    public String cellGroup() {
        return cellGroups[this.cellGroup];
    }

    public String getFate() {
        return fates[this.fate];
    }

    boolean isNeuron() {
        return this.fate == 5;
    }

    public String getType() {
        return types[this.type];
    }

    public Cell[] getDaughters() {
        return this.daughters;
    }

    public int getNumChildren() {
        return this.num_children;
    }

    public int getBirthday() {
        return this.birthday;
    }

    public int getDeathday() {
        return this.death_day;
    }

    public String getName() {
        return this.official_name;
    }

    public String getLineageName() {
        return this.lineage_name;
    }

    public String getRemark() {
        return this.remark;
    }

    public ArrayList getSynapses() {
        return this.synapses;
    }

    public float getRadius() {
        return this.radius;
    }

    public Cell() {
        this.synapses = new ArrayList(0);
        this.daughters = new Cell[2];
        this.equivalence_origin = new Cell[2];
        this.equivalence_fate = new Cell[2];
        this.split_radius_distance = new double[3];
        this.split_radius_distance[1] = this.split_radius_distance[2] = initial_split_radius_distance;
        this.split_radius_distance[0] = this.split_radius_distance[2];
    }

    public void addSynapse(Synapse s) {
        for (int x = 0; x < this.synapses.size(); ++x) {
            Synapse test = (Synapse)this.synapses.get(x);
            if (s.from == test.from && s.to == test.to && s.type == test.type && s.type == Synapse.type_chemical) {
                return;
            }
            if ((s.from != test.from || s.to != test.to || s.type != Synapse.type_gap) && (s.from != test.to || s.to != test.from || s.type != Synapse.type_gap)) continue;
            return;
        }
        this.synapses.add(s);
    }

    public void setVolume(float vol) {
        this.radius = (float)Math.pow(vol, 0.3333333432674408);
        if (this.official_name.equalsIgnoreCase("P0")) {
            for (int x = 0; x < this.num_children; ++x) {
                if (this.daughters[x].official_name.equalsIgnoreCase("AB")) {
                    this.daughters[x].setVolume(vol * 0.6f);
                    continue;
                }
                this.daughters[x].setVolume(vol * 0.4f);
            }
        } else {
            for (int x = 0; x < this.num_children; ++x) {
                this.daughters[x].setVolume(vol / (float)this.num_children);
            }
        }
    }

    public float getRadius(int timestamp) {
        if (timestamp >= this.birthday && timestamp < this.death_day && this.location_size > 1 && this.parent != null) {
            if (this.location_t[1] < this.location_t[0]) {
                System.out.println("Uh oh");
                return this.parent.radius;
            }
            if (this.location_t[1] == this.location_t[0]) {
                return this.parent.radius;
            }
            if ((double)timestamp < this.location_t[1]) {
                return (float)((double)this.radius + (double)(this.parent.radius - this.radius) * (1.0 - ((double)timestamp - this.location_t[0]) / (this.location_t[1] - this.location_t[0])));
            }
        }
        return this.radius;
    }

    public boolean getLocation(int timestamp, double[] xyz) {
        if (timestamp >= this.birthday && timestamp < this.death_day) {
            if (this.location_size == 0) {
                System.out.println("No location information for cell" + this.official_name);
                return false;
            }
            if (this.location_t[0] > (double)timestamp) {
                xyz[0] = this.location_x[0];
                xyz[1] = this.location_y[0];
                xyz[2] = this.location_z[0];
                return true;
            }
            for (int x = 0; x < this.location_size; ++x) {
                if (this.location_t[x] == (double)timestamp) {
                    xyz[0] = this.location_x[x];
                    xyz[1] = this.location_y[x];
                    xyz[2] = this.location_z[x];
                    return true;
                }
                if (x == this.location_size - 1) {
                    xyz[0] = this.location_x[x];
                    xyz[1] = this.location_y[x];
                    xyz[2] = this.location_z[x];
                    return true;
                }
                if (!(this.location_t[x] < (double)timestamp) || !(this.location_t[x + 1] > (double)timestamp)) continue;
                double p = ((double)timestamp - this.location_t[x]) / (this.location_t[x + 1] - this.location_t[x]);
                xyz[0] = this.location_x[x] * (1.0 - p) + this.location_x[x + 1] * p;
                xyz[1] = this.location_y[x] * (1.0 - p) + this.location_y[x + 1] * p;
                xyz[2] = this.location_z[x] * (1.0 - p) + this.location_z[x + 1] * p;
                return true;
            }
            return true;
        }
        return false;
    }

    public void sortLocation() {
        for (int x = 0; x < this.location_size; ++x) {
            for (int y = x + 1; y < this.location_size; ++y) {
                if (this.location_t[y] < this.location_t[x]) {
                    double swap = this.location_x[y];
                    this.location_x[y] = this.location_x[x];
                    this.location_x[x] = swap;
                    swap = this.location_y[y];
                    this.location_y[y] = this.location_y[x];
                    this.location_y[x] = swap;
                    swap = this.location_z[y];
                    this.location_z[y] = this.location_z[x];
                    this.location_z[x] = swap;
                    swap = this.location_t[y];
                    this.location_t[y] = this.location_t[x];
                    this.location_t[x] = swap;
                    continue;
                }
                if (this.location_t[y] != this.location_t[x]) continue;
                System.out.println("Identical Times: " + x + " " + y + " in " + this.official_name);
            }
        }
    }

    public void pushLocation(double x, double y, double z, double t) {
        if (this.location_max == 0) {
            this.location_x = new double[initial_location_size];
            this.location_y = new double[initial_location_size];
            this.location_z = new double[initial_location_size];
            this.location_t = new double[initial_location_size];
            this.location_max = initial_location_size;
            this.location_size = 0;
        }
        this.location_x[this.location_size] = x;
        this.location_y[this.location_size] = y;
        this.location_z[this.location_size] = z;
        this.location_t[this.location_size] = t;
        ++this.location_size;
        if (this.location_size == this.location_max) {
            double[] new_location_x = new double[this.location_max * 2];
            double[] new_location_y = new double[this.location_max * 2];
            double[] new_location_z = new double[this.location_max * 2];
            double[] new_location_t = new double[this.location_max * 2];
            System.arraycopy(this.location_x, 0, new_location_x, 0, this.location_max);
            System.arraycopy(this.location_y, 0, new_location_y, 0, this.location_max);
            System.arraycopy(this.location_z, 0, new_location_z, 0, this.location_max);
            System.arraycopy(this.location_t, 0, new_location_t, 0, this.location_max);
            this.location_x = new_location_x;
            this.location_y = new_location_y;
            this.location_z = new_location_z;
            this.location_t = new_location_t;
            this.location_max *= 2;
        }
    }

    public void postProcessBirthday(boolean root) {
        this.birthday = root && this.time_born == -1.0 ? -1 : (this.time_born != -1.0 ? (int)this.time_born : (this.parent.embryo_division_time != -1.0 ? (int)this.parent.embryo_division_time : (this.parent.birthday >= post_embryonic_birthday ? this.parent.birthday + 1 : post_embryonic_birthday)));
        for (int z = 0; z < this.num_children; ++z) {
            this.daughters[z].postProcessBirthday(false);
        }
        this.birthday += 2;
    }

    public void modifyLocations(double x, double y, double z) {
        int a = 0;
        while (a < this.location_size) {
            int n = a;
            this.location_x[n] = this.location_x[n] + x;
            int n2 = a;
            this.location_y[n2] = this.location_y[n2] + y;
            int n3 = a++;
            this.location_z[n3] = this.location_z[n3] + z;
        }
        for (int j = 0; j < this.num_children; ++j) {
            this.daughters[j].modifyLocations(x, y, z);
        }
    }

    public void postProcessDeathDay(boolean root) {
        this.death_day = this.num_children != 0 ? this.daughters[0].birthday : maximum_death_day;
        for (int z = 0; z < this.num_children; ++z) {
            this.daughters[z].postProcessDeathDay(false);
        }
    }

    public void postProcessLocation(boolean root) {
        this.sortLocation();
        double birth_location_x = 0.0;
        double birth_location_y = 0.0;
        double birth_location_z = 0.0;
        if (this.official_name.equals("P0") || this.official_name.equals("P1'") || this.official_name.equals("P2'") || this.official_name.equals("AB") || this.official_name.equals("P3'") || this.official_name.equals("P4'") || this.official_name.equals("Z3") || this.official_name.equals("Z2")) {
            if (this.official_name.equals("P0")) {
                birth_location_x = 30.0;
                birth_location_y = 17.95;
                birth_location_z = 13.6;
            } else if (this.official_name.equals("P1'")) {
                birth_location_x = 45.0;
                birth_location_y = 17.95;
                birth_location_z = 13.6;
            } else if (this.official_name.equals("P2'")) {
                birth_location_x = 54.0;
                birth_location_y = 31.3;
                birth_location_z = 14.4;
            } else if (this.official_name.equals("AB")) {
                birth_location_x = 22.05;
                birth_location_y = 17.95;
                birth_location_z = 13.6;
            } else if (this.official_name.equals("P3'")) {
                birth_location_x = 55.0;
                birth_location_y = 25.0;
                birth_location_z = 9.6;
            } else if (this.official_name.equals("P4'")) {
                birth_location_x = 53.5;
                birth_location_y = 26.0;
                birth_location_z = 6.5;
            } else if (this.official_name.equals("Z3")) {
                birth_location_x = 53.0;
                birth_location_y = 23.0;
                birth_location_z = 6.5;
            } else if (this.official_name.equals("Z2")) {
                birth_location_x = 53.0;
                birth_location_y = 29.0;
                birth_location_z = 6.5;
            } else {
                birth_location_x = 0.0;
                birth_location_y = 0.0;
                birth_location_z = 0.0;
            }
            this.pushLocation(birth_location_x, birth_location_y, birth_location_z, this.birthday + (this.death_day - this.birthday) / 3);
            this.sortLocation();
        } else if (root) {
            System.out.println("Whoa! " + this.official_name + "is root, but has no location!");
            birth_location_x = 0.0;
            birth_location_y = 0.0;
            birth_location_z = 0.0;
        }
        if (!root && this.parent != null) {
            if (this.location_size != 0 && this.parent.location_size != 0) {
                birth_location_x = this.parent.location_x[this.parent.location_size - 1];
                birth_location_y = this.parent.location_y[this.parent.location_size - 1];
                birth_location_z = this.parent.location_z[this.parent.location_size - 1];
            } else if (this.location_size != 0) {
                birth_location_x = this.location_x[0];
                birth_location_y = this.location_y[0];
                birth_location_z = this.location_z[0];
            } else {
                char sc;
                birth_location_x = this.parent.location_x[this.parent.location_size - 1];
                birth_location_y = this.parent.location_y[this.parent.location_size - 1];
                birth_location_z = this.parent.location_z[this.parent.location_size - 1];
                if (this.lineage_name.equals("")) {
                    System.out.println("Whoa! " + this.official_name + "has no lineage name!");
                    this.lineage_name = this.official_name;
                    sc = this.lineage_name.charAt(this.lineage_name.length() - 1);
                    if (sc == 'd') {
                        this.split_radius_distance[1] = this.parent.split_radius_distance[1] / 2.0;
                        birth_location_y -= this.split_radius_distance[1];
                    } else if (sc == 'v') {
                        this.split_radius_distance[1] = this.parent.split_radius_distance[1] / 2.0;
                        birth_location_y += this.split_radius_distance[1];
                    } else if (sc == 'a') {
                        this.split_radius_distance[0] = this.parent.split_radius_distance[0] / 2.0;
                        birth_location_x -= this.split_radius_distance[0];
                    } else if (sc == 'p') {
                        this.split_radius_distance[0] = this.parent.split_radius_distance[0] / 2.0;
                        birth_location_x += this.split_radius_distance[0];
                    } else if (sc == 'l') {
                        this.split_radius_distance[2] = this.parent.split_radius_distance[2] / 2.0;
                        birth_location_z -= this.split_radius_distance[2];
                    } else if (sc == 'r') {
                        this.split_radius_distance[2] = this.parent.split_radius_distance[2] / 2.0;
                        birth_location_z += this.split_radius_distance[2];
                    } else {
                        System.out.println("Whoa! Lineage name with no split characteristics: " + this.lineage_name + " (" + this.official_name + ")");
                    }
                } else if (this.parent == null) {
                    System.out.println("Whoa! " + this.official_name + "is root, but has no location -- I shouldn't be able to get here!");
                    birth_location_x = 0.0;
                    birth_location_y = 0.0;
                    birth_location_z = 0.0;
                } else {
                    sc = this.lineage_name.charAt(this.lineage_name.length() - 1);
                    if (sc == 'd') {
                        this.split_radius_distance[1] = this.parent.split_radius_distance[1] / 2.0;
                        birth_location_y -= this.split_radius_distance[1];
                    } else if (sc == 'v') {
                        this.split_radius_distance[1] = this.parent.split_radius_distance[1] / 2.0;
                        birth_location_y += this.split_radius_distance[1];
                    } else if (sc == 'a') {
                        this.split_radius_distance[0] = this.parent.split_radius_distance[0] / 2.0;
                        birth_location_x -= this.split_radius_distance[0];
                    } else if (sc == 'p') {
                        this.split_radius_distance[0] = this.parent.split_radius_distance[0] / 2.0;
                        birth_location_x += this.split_radius_distance[0];
                    } else if (sc == 'l') {
                        this.split_radius_distance[2] = this.parent.split_radius_distance[2] / 2.0;
                        birth_location_z -= this.split_radius_distance[2];
                    } else if (sc == 'r') {
                        this.split_radius_distance[2] = this.parent.split_radius_distance[2] / 2.0;
                        birth_location_z += this.split_radius_distance[2];
                    } else {
                        System.out.println("Whoa! Lineage name with no split characteristics: " + this.lineage_name + " (" + this.official_name + ")");
                    }
                }
            }
        }
        this.pushLocation(birth_location_x, birth_location_y, birth_location_z, this.birthday);
        this.sortLocation();
        for (int z = 0; z < this.num_children; ++z) {
            this.daughters[z].postProcessLocation(false);
        }
    }

    public void descendentsOf(Cell cell, HashMap add_here) {
        add_here.put(this.official_name, this);
        for (int z = 0; z < this.num_children; ++z) {
            this.daughters[z].descendentsOf(cell, add_here);
        }
    }

    @Override
    public void step(SimState state) {
        Celegans celegans = (Celegans)state;
        double time = state.schedule.getTime();
        if (time >= (double)this.death_day && time < Double.POSITIVE_INFINITY) {
            this.stopper.stop();
            celegans.cells.remove(this);
            if (this.daughters != null) {
                for (int i = 0; i < this.num_children; ++i) {
                    this.daughters[i].stopper = state.schedule.scheduleRepeating(this.daughters[i]);
                    this.daughters[i].step(state);
                    if (!this.daughters[i].isNeuron()) continue;
                    int size = this.daughters[i].synapses.size();
                    for (int j = 0; j < size; ++j) {
                        Synapse s = (Synapse)this.daughters[i].synapses.get(j);
                        if (!celegans.neurons.exists(s.to) || !celegans.neurons.exists(s.from)) continue;
                        celegans.synapses.addEdge(s.to, s.from, s);
                    }
                }
            }
        } else {
            this.getLocation((int)time, this.loc_xyz);
            celegans.cells.setObjectLocation((Object)this, new Double3D(this.loc_xyz[0], this.loc_xyz[1], this.loc_xyz[2]));
            if (this.isNeuron()) {
                celegans.neurons.setObjectLocation((Object)this, new Double3D(this.loc_xyz[0], this.loc_xyz[1], this.loc_xyz[2]));
            }
        }
    }

    public String toString() {
        return "Cell " + this.official_name;
    }
}

