/*
 * Decompiled with CFR 0.152.
 */
package sim.app.crowd3d;

import sim.app.crowd3d.CrowdSim;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Bag;
import sim.util.Double3D;
import sim.util.MutableDouble3D;

public class Agent
implements Steppable,
Stoppable {
    private static final long serialVersionUID = 1L;
    public static double SIGHT = 5.0;
    public static double SPEED = 0.05;
    public static double WALL_AVERSION = 4.0;
    public static double CROWD_AVERSION = 1.0;
    public static double MAX_FN_VAL;
    public static double FORCE_MIN_THRESHOLD;
    MutableDouble3D direction = new MutableDouble3D();
    static MutableDouble3D tmpSumOfCrowdForces;
    static MutableDouble3D tmpSumOfWallForces;
    static MutableDouble3D tmpSumOfForces;
    static MutableDouble3D tmpMyPosition;
    private Stoppable stopper = null;

    @Override
    public void step(SimState state) {
        CrowdSim hb = (CrowdSim)state;
        Double3D myPositionD3D = hb.boidSpace.getObjectLocation(this);
        Agent.tmpMyPosition.x = myPositionD3D.x;
        Agent.tmpMyPosition.y = myPositionD3D.y;
        Agent.tmpMyPosition.z = myPositionD3D.z;
        Bag neighbors = hb.boidSpace.getNeighborsWithinDistance(myPositionD3D, SIGHT);
        Agent.tmpSumOfCrowdForces.z = 0.0;
        Agent.tmpSumOfCrowdForces.y = 0.0;
        Agent.tmpSumOfCrowdForces.x = 0.0;
        Agent.tmpSumOfWallForces.z = 0.0;
        Agent.tmpSumOfWallForces.y = 0.0;
        Agent.tmpSumOfWallForces.x = 0.0;
        for (int i = 0; i < neighbors.numObjs; ++i) {
            if (neighbors.objs[i] == this) continue;
            Double3D nPosition = hb.boidSpace.getObjectLocation(neighbors.objs[i]);
            Agent.tmpSumOfCrowdForces.x += this.fn(myPositionD3D.x - nPosition.x);
            Agent.tmpSumOfCrowdForces.y += this.fn(myPositionD3D.y - nPosition.y);
            Agent.tmpSumOfCrowdForces.z += this.fn(myPositionD3D.z - nPosition.z);
        }
        tmpSumOfCrowdForces.multiplyIn(CROWD_AVERSION);
        if (myPositionD3D.x < SIGHT) {
            Agent.tmpSumOfWallForces.x += this.fn(myPositionD3D.x);
        }
        if (myPositionD3D.x > hb.spaceWidth - SIGHT) {
            Agent.tmpSumOfWallForces.x -= this.fn(hb.spaceWidth - myPositionD3D.x);
        }
        if (myPositionD3D.y < SIGHT) {
            Agent.tmpSumOfWallForces.y += this.fn(myPositionD3D.y);
        }
        if (myPositionD3D.y > hb.spaceHeight - SIGHT) {
            Agent.tmpSumOfWallForces.y -= this.fn(hb.spaceHeight - myPositionD3D.y);
        }
        if (myPositionD3D.z < SIGHT) {
            Agent.tmpSumOfWallForces.z += this.fn(myPositionD3D.z);
        }
        if (myPositionD3D.z > hb.spaceDepth - SIGHT) {
            Agent.tmpSumOfWallForces.z -= this.fn(hb.spaceDepth - myPositionD3D.z);
        }
        tmpSumOfWallForces.multiplyIn(WALL_AVERSION);
        tmpSumOfForces.add(tmpSumOfCrowdForces, tmpSumOfWallForces);
        if (tmpSumOfForces.length() > FORCE_MIN_THRESHOLD) {
            tmpSumOfForces.normalize();
            tmpSumOfForces.multiplyIn(SPEED);
            tmpMyPosition.addIn(tmpSumOfForces);
            this.clamp(tmpMyPosition, hb);
            Double3D newLocation = new Double3D(Agent.tmpMyPosition.x, Agent.tmpMyPosition.y, Agent.tmpMyPosition.z);
            hb.boidSpace.setObjectLocation((Object)this, newLocation);
        }
    }

    private void clamp(MutableDouble3D position, CrowdSim hb) {
        position.x = Math.min(Math.max(position.x, 0.0), hb.spaceWidth);
        position.y = Math.min(Math.max(position.y, 0.0), hb.spaceHeight);
        position.z = Math.min(Math.max(position.z, 0.0), hb.spaceDepth);
    }

    private double fn(double d) {
        return Math.min(MAX_FN_VAL, 1.0 / d);
    }

    public void setStopper(Stoppable stopper) {
        this.stopper = stopper;
    }

    @Override
    public void stop() {
        this.stopper.stop();
    }

    static {
        FORCE_MIN_THRESHOLD = 0.75;
        tmpSumOfCrowdForces = new MutableDouble3D();
        tmpSumOfWallForces = new MutableDouble3D();
        tmpSumOfForces = new MutableDouble3D();
        tmpMyPosition = new MutableDouble3D();
    }
}

