/*
 * Decompiled with CFR 0.152.
 */
package sim.app.crowd3d;

import sim.app.crowd3d.Agent;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous3D;
import sim.util.Double3D;

public class CrowdSim
extends SimState {
    private static final long serialVersionUID = 1L;
    public double spaceHeight = 20.0;
    public double spaceWidth = 20.0;
    public double spaceDepth = 20.0;
    public int boidCount = 0;
    public int STEPS_BETWEEN_INSERTS = 200;
    public Continuous3D boidSpace = new Continuous3D(Agent.SIGHT, this.spaceWidth, this.spaceHeight, this.spaceDepth);

    public static void main(String[] args) {
        CrowdSim.doLoop(CrowdSim.class, args);
        System.exit(0);
    }

    public CrowdSim(long seed) {
        super(seed);
        Agent.MAX_FN_VAL = Math.min(this.spaceHeight, Math.min(this.spaceWidth, this.spaceDepth)) / 2.0;
    }

    private void spawnBoid() {
        Agent boid = new Agent();
        this.boidSpace.setObjectLocation((Object)boid, new Double3D(this.random.nextDouble() * this.spaceWidth, this.random.nextDouble() * this.spaceHeight, this.random.nextDouble() * this.spaceDepth));
        boid.setStopper(this.schedule.scheduleRepeating(boid));
        ++this.boidCount;
    }

    protected void killBoid() {
        Agent victim = (Agent)this.boidSpace.allObjects.objs[(int)(this.random.nextDouble() * (double)this.boidCount)];
        victim.stop();
        this.boidSpace.remove(victim);
    }

    @Override
    public void start() {
        super.start();
        this.boidSpace = new Continuous3D(Agent.SIGHT, this.spaceWidth, this.spaceHeight, this.spaceDepth);
        Steppable spawner = new Steppable(){

            @Override
            public void step(SimState state) {
                CrowdSim.this.spawnBoid();
            }
        };
        this.schedule.scheduleRepeating(0.0, 1, spawner, this.STEPS_BETWEEN_INSERTS);
    }
}

