/*
 * Decompiled with CFR 0.152.
 */
package sim.app.flockers;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.flockers.Flockers;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.AdjustablePortrayal2D;
import sim.portrayal.simple.MovablePortrayal2D;
import sim.portrayal.simple.OrientedPortrayal2D;
import sim.portrayal.simple.TrailedPortrayal2D;

public class FlockersWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D flockersPortrayal = new ContinuousPortrayal2D();
    ContinuousPortrayal2D trailsPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new FlockersWithUI().createController();
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public FlockersWithUI() {
        super(new Flockers(System.currentTimeMillis()));
    }

    public FlockersWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Flockers";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        double h;
        Flockers flock = (Flockers)this.state;
        this.flockersPortrayal.setField(flock.flockers);
        this.trailsPortrayal.setField(flock.flockers);
        for (int x = 0; x < flock.flockers.allObjects.numObjs; ++x) {
            TrailedPortrayal2D basic = new TrailedPortrayal2D(this, new OrientedPortrayal2D(new SimplePortrayal2D(), 0, 4.0, new Color(128 + this.guirandom.nextInt(128), 128 + this.guirandom.nextInt(128), 128 + this.guirandom.nextInt(128)), 2), this.trailsPortrayal, 100.0);
            this.flockersPortrayal.setPortrayalForObject(flock.flockers.allObjects.objs[x], new AdjustablePortrayal2D(new MovablePortrayal2D(basic)));
            this.trailsPortrayal.setPortrayalForObject(flock.flockers.allObjects.objs[x], basic);
        }
        double w = flock.flockers.getWidth();
        if (w == (h = flock.flockers.getHeight())) {
            this.display.insideDisplay.height = 750.0;
            this.display.insideDisplay.width = 750.0;
        } else if (w > h) {
            this.display.insideDisplay.width = 750.0;
            this.display.insideDisplay.height = 750.0 * (h / w);
        } else if (w < h) {
            this.display.insideDisplay.height = 750.0;
            this.display.insideDisplay.width = 750.0 * (w / h);
        }
        this.display.reset();
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(750.0, 750.0, this);
        this.display.setBackdrop(Color.black);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Flockers");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.trailsPortrayal, "Trails");
        this.display.attach(this.flockersPortrayal, "Behold the Flock!");
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

