/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs;

import sim.app.heatbugs.HeatBugs;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;

public class Diffuser
implements Steppable {
    private static final long serialVersionUID = 1L;

    @Override
    public void step(SimState state) {
        HeatBugs heatbugs = (HeatBugs)state;
        DoubleGrid2D _valgrid = heatbugs.valgrid;
        double[][] _valgrid_field = heatbugs.valgrid.field;
        double[][] _valgrid2_field = heatbugs.valgrid2.field;
        int _gridWidth = _valgrid.getWidth();
        int _gridHeight = _valgrid.getHeight();
        double _evaporationRate = heatbugs.evaporationRate;
        double _diffusionRate = heatbugs.diffusionRate;
        double[] _past = _valgrid_field[_valgrid.stx(-1)];
        double[] _current = _valgrid_field[0];
        for (int x = 0; x < _gridWidth; ++x) {
            double[] _next = _valgrid_field[_valgrid.stx(x + 1)];
            double[] _put = _valgrid2_field[_valgrid.stx(x)];
            int yminus1 = _valgrid.sty(-1);
            int y = 0;
            while (y < _gridHeight) {
                int yplus1 = _valgrid.sty(y + 1);
                double average = (_past[yminus1] + _past[y] + _past[yplus1] + _current[yminus1] + _current[y] + _current[yplus1] + _next[yminus1] + _next[y] + _next[yplus1]) / 9.0;
                _put[y] = _evaporationRate * (_current[y] + _diffusionRate * (average - _current[y]));
                yminus1 = y++;
            }
            _past = _current;
            _current = _next;
        }
        _valgrid.setTo(heatbugs.valgrid2);
    }
}

