/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.heatbugs.HeatBugs;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.MovablePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class HeatBugsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    FastValueGridPortrayal2D heatPortrayal = new FastValueGridPortrayal2D("Heat");
    SparseGridPortrayal2D bugPortrayal = new SparseGridPortrayal2D();

    public static void main(String[] args) {
        new HeatBugsWithUI().createController();
    }

    public HeatBugsWithUI() {
        super(new HeatBugs(System.currentTimeMillis()));
    }

    public HeatBugsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "HeatBugs";
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.bugPortrayal.setField(((HeatBugs)this.state).buggrid);
        this.bugPortrayal.setPortrayalForAll(new MovablePortrayal2D(new OvalPortrayal2D(Color.white)));
        this.heatPortrayal.setField(((HeatBugs)this.state).valgrid);
        this.heatPortrayal.setMap(new SimpleColorMap(0.0, 32000.0, Color.black, Color.red));
        this.display.reset();
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle(this.displayFrame.getTitle() + (HeatBugs.availableProcessors() > 1 ? " (Multiprocessor)" : ""));
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.heatPortrayal, "Heat");
        this.display.attach(this.bugPortrayal, "Bugs");
        this.display.setBackdrop(Color.black);
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

