/*
 * Decompiled with CFR 0.152.
 */
package sim.app.hexabugs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JFrame;
import sim.app.hexabugs.HexaBugs;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.Inspector;
import sim.portrayal.SimpleInspector;
import sim.portrayal.grid.FastHexaValueGridPortrayal2D;
import sim.portrayal.grid.HexaSparseGridPortrayal2D;
import sim.portrayal.grid.HexaValueGridPortrayal2D;
import sim.portrayal.simple.MovablePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class HexaBugsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    HexaSparseGridPortrayal2D bugPortrayal = new HexaSparseGridPortrayal2D();
    FastHexaValueGridPortrayal2D heatPortrayal = new FastHexaValueGridPortrayal2D("Heat");
    HexaValueGridPortrayal2D heatPortrayal2 = new HexaValueGridPortrayal2D("Heat");
    HexaValueGridPortrayal2D currentHeatPortrayal = this.heatPortrayal;
    public static final double HEXAGONAL_RATIO = 2.0 / Math.sqrt(3.0);

    public static void main(String[] args) {
        new HexaBugsWithUI().createController();
    }

    public HexaBugsWithUI() {
        super(new HexaBugs(System.currentTimeMillis()));
    }

    public HexaBugsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "HexaBugs";
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    @Override
    public Inspector getInspector() {
        final Inspector originalInspector = super.getInspector();
        SimpleInspector hexInspector = new SimpleInspector(new HexagonChoice(), this);
        originalInspector.setVolatile(true);
        Inspector newInspector = new Inspector(){

            @Override
            public void updateInspector() {
                originalInspector.updateInspector();
            }
        };
        newInspector.setVolatile(false);
        Box b = new Box(0){

            @Override
            public Insets getInsets() {
                return new Insets(2, 2, 2, 2);
            }
        };
        b.add(newInspector.makeUpdateButton());
        b.add(Box.createGlue());
        Box b2 = new Box(1);
        b2.add(b);
        b2.add(hexInspector);
        b2.add(Box.createGlue());
        newInspector.setLayout(new BorderLayout());
        newInspector.add((Component)b2, "North");
        newInspector.add((Component)originalInspector, "Center");
        return newInspector;
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        SimpleColorMap map = new SimpleColorMap(0.0, 32000.0, Color.black, Color.red);
        this.heatPortrayal.setField(((HexaBugs)this.state).valgrid);
        this.heatPortrayal.setMap(map);
        this.heatPortrayal2.setField(((HexaBugs)this.state).valgrid);
        this.heatPortrayal2.setMap(map);
        this.bugPortrayal.setField(((HexaBugs)this.state).buggrid);
        this.bugPortrayal.setPortrayalForAll(new MovablePortrayal2D(new OvalPortrayal2D(Color.white)));
        this.display.reset();
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        double scale = 4.0;
        double m = 100.0;
        double n = 100.0;
        int height = 402;
        int width = (int)(75.25 * HEXAGONAL_RATIO * 4.0);
        this.display = new Display2D(width, 402.0, this);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.currentHeatPortrayal, "Heat");
        this.display.attach(this.bugPortrayal, "Bugs");
        this.display.setBackdrop(Color.black);
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    public class HexagonChoice {
        int cells = 0;

        public Object domDisplayGridCellsAs() {
            return new Object[]{"Rectangles", "Hexagons"};
        }

        public int getDisplayGridCellsAs() {
            return this.cells;
        }

        public void setDisplayGridCellsAs(int val) {
            if (val == 0) {
                this.cells = val;
                HexaBugsWithUI.this.currentHeatPortrayal = HexaBugsWithUI.this.heatPortrayal;
            } else if (val == 1) {
                this.cells = val;
                HexaBugsWithUI.this.currentHeatPortrayal = HexaBugsWithUI.this.heatPortrayal2;
            }
            HexaBugsWithUI.this.display.detatchAll();
            HexaBugsWithUI.this.display.attach(HexaBugsWithUI.this.currentHeatPortrayal, "Heat");
            HexaBugsWithUI.this.display.attach(HexaBugsWithUI.this.bugPortrayal, "Bugs");
            if (HexaBugsWithUI.this.display != null) {
                HexaBugsWithUI.this.display.repaint();
            }
        }
    }
}

