/*
 * Decompiled with CFR 0.152.
 */
package sim.app.hexabugs;

import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;

public class HexaDiffuser
implements Steppable {
    private static final long serialVersionUID = 1L;
    DoubleGrid2D updateGrid;
    DoubleGrid2D tempGrid;
    double evaporationRate;
    double diffusionRate;

    public HexaDiffuser(DoubleGrid2D updateGrid, DoubleGrid2D tempGrid, double evaporationRate, double diffusionRate) {
        this.updateGrid = updateGrid;
        this.tempGrid = tempGrid;
        this.evaporationRate = evaporationRate;
        this.diffusionRate = diffusionRate;
    }

    @Override
    public void step(SimState state) {
        DoubleGrid2D _valgrid = this.updateGrid;
        double[][] _valgrid_field = this.updateGrid.field;
        double[][] _valgrid2_field = this.tempGrid.field;
        int _gridWidth = _valgrid.getWidth();
        int _gridHeight = _valgrid.getHeight();
        double _evaporationRate = this.evaporationRate;
        double _diffusionRate = this.diffusionRate;
        double[] _past = _valgrid_field[_valgrid.stx(-1)];
        double[] _current = _valgrid_field[0];
        for (int x = 0; x < _gridWidth; ++x) {
            int xplus1 = x + 1;
            if (xplus1 == _gridWidth) {
                xplus1 = 0;
            }
            double[] _next = _valgrid_field[xplus1];
            double[] _put = _valgrid2_field[x];
            boolean xmodulo2equals0 = x % 2 == 0;
            int yminus1 = _gridHeight - 1;
            int y = 0;
            while (y < _gridHeight) {
                int yplus1 = y + 1;
                if (yplus1 == _gridHeight) {
                    yplus1 = 0;
                }
                double average = xmodulo2equals0 ? (_current[y] + _past[yminus1] + _next[yminus1] + _past[y] + _next[y] + _current[yminus1] + _current[yplus1]) / 7.0 : (_current[y] + _past[y] + _next[y] + _past[yplus1] + _next[yplus1] + _current[yminus1] + _current[yplus1]) / 7.0;
                _put[y] = _evaporationRate * (_current[y] + _diffusionRate * (average - _current[y]));
                yminus1 = y++;
            }
            _past = _current;
            _current = _next;
        }
        this.updateGrid.setTo(this.tempGrid);
    }
}

