/*
 * Decompiled with CFR 0.152.
 */
package sim.app.keepaway;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.app.keepaway.Ball;
import sim.app.keepaway.Entity;
import sim.app.keepaway.Keepaway;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.DrawInfo2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Bot
extends Entity
implements Steppable {
    private static final long serialVersionUID = 1L;
    public MutableDouble2D tempVector = new MutableDouble2D();

    public Bot(double x, double y, Color c) {
        super(x, y, 2.0, c);
    }

    @Override
    public void draw(Object object, Graphics2D g, DrawInfo2D info) {
        super.draw(object, g, info);
        double width = info.draw.width * this.radius * 2.0;
        double height = info.draw.height * this.radius * 2.0;
        g.setColor(Color.white);
        double d = this.velocity.angle();
        g.drawLine((int)info.draw.x, (int)info.draw.y, (int)info.draw.x + (int)(width / 2.0 * Math.cos(d)), (int)info.draw.y + (int)(height / 2.0 * Math.sin(d)));
    }

    public MutableDouble2D getForces(Keepaway keepaway) {
        this.sumVector.setTo(0.0, 0.0);
        Bag objs = keepaway.fieldEnvironment.getNeighborsWithinDistance(new Double2D(this.loc.x, this.loc.y), 100.0);
        double dist = 0.0;
        for (int x = 0; x < objs.numObjs; ++x) {
            if (objs.objs[x] == this) continue;
            dist = ((Entity)objs.objs[x]).loc.distance(this.loc);
            if ((((Entity)objs.objs[x]).radius + this.radius) * 1.25 > dist) {
                if (objs.objs[x] instanceof Ball && keepaway.random.nextDouble() < 0.1) {
                    this.tempVector.subtract(((Entity)objs.objs[x]).loc, this.loc);
                    this.tempVector.normalize().multiplyIn(2.0);
                    ((Entity)objs.objs[x]).velocity.addIn(this.tempVector);
                    continue;
                }
                this.tempVector.x = 0.0;
                this.tempVector.y = 0.0;
                double mass1 = this.mass - ((Entity)objs.objs[x]).mass;
                double mass2 = 2.0 * ((Entity)objs.objs[x]).mass;
                this.tempVector.x = this.velocity.x * (mass1 /= this.mass + ((Entity)objs.objs[x]).mass) + ((Entity)objs.objs[x]).velocity.x * (mass2 /= this.mass + ((Entity)objs.objs[x]).mass);
                this.tempVector.y = this.velocity.y * mass1 + ((Entity)objs.objs[x]).velocity.y * mass2;
                ((Entity)objs.objs[x]).bump.x = this.velocity.x * mass2 - ((Entity)objs.objs[x]).velocity.x * mass1;
                ((Entity)objs.objs[x]).bump.y = this.velocity.y * mass2 - ((Entity)objs.objs[x]).velocity.y * mass1;
                this.velocity.x = this.tempVector.x;
                this.velocity.y = this.tempVector.y;
                continue;
            }
            if (!(objs.objs[x] instanceof Ball)) continue;
            this.tempVector.subtract(((Entity)objs.objs[x]).loc, this.loc);
            this.tempVector.resize(0.5);
            this.sumVector.addIn(this.tempVector);
        }
        this.sumVector.addIn(this.bump);
        this.bump.x = 0.0;
        this.bump.y = 0.0;
        return this.sumVector;
    }

    @Override
    public void step(SimState state) {
        Keepaway keepaway = (Keepaway)state;
        MutableDouble2D force = this.getForces(keepaway);
        this.accel.multiply(force, 1.0 / this.mass);
        this.velocity.addIn(this.accel);
        this.capVelocity();
        this.newLoc.add(this.loc, this.velocity);
        if (this.isValidMove(keepaway, this.newLoc)) {
            this.loc = this.newLoc;
        }
        keepaway.fieldEnvironment.setObjectLocation((Object)this, new Double2D(this.loc));
    }
}

