/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lightcycles;

import sim.app.lightcycles.LightCycles;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.util.Int2D;

public class Cycle
implements Steppable {
    private static final long serialVersionUID = 1L;
    public int dir;
    public int my_id;
    boolean alive;
    boolean cpu;
    Stoppable stopper;

    public int getdir() {
        return this.dir;
    }

    public void setdir(int ndir) {
        this.dir = ndir;
    }

    public int getmy_id() {
        return this.my_id;
    }

    public void setmy_id(int nid) {
        this.my_id = nid;
    }

    public boolean getalive() {
        return this.alive;
    }

    public void setalive(boolean nalive) {
        this.alive = nalive;
    }

    public boolean getcpu() {
        return this.cpu;
    }

    public void setcpu(boolean ncpu) {
        this.cpu = ncpu;
    }

    public Cycle(int id, int ndir) {
        this.my_id = id;
        this.dir = ndir;
        this.alive = true;
        this.cpu = true;
    }

    @Override
    public void step(SimState state) {
        if (!this.alive) {
            if (this.stopper != null) {
                this.stopper.stop();
            }
            return;
        }
        LightCycles lc = (LightCycles)state;
        int[] dirs = new int[5];
        int i = 0;
        int n = 0;
        Int2D location = lc.cycleGrid.getObjectLocation(this);
        int x = location.x;
        int y = location.y;
        if (this.cpu) {
            for (i = 1; i < 5; ++i) {
                if (i == 1 && y == 0 || i == 2 && y == lc.gridHeight - 1 || i == 3 && x == 0 || i == 4 && x == lc.gridWidth - 1) continue;
                n = 1;
                switch (i) {
                    case 1: {
                        while (lc.grid.field[x][y - n] == 0 && y - (n + 1) > 0) {
                            ++n;
                        }
                        break;
                    }
                    case 2: {
                        while (lc.grid.field[x][y + n] == 0 && y + (n + 1) < lc.gridHeight) {
                            ++n;
                        }
                        break;
                    }
                    case 3: {
                        while (lc.grid.field[x - n][y] == 0 && x - (n + 1) > 0) {
                            ++n;
                        }
                        break;
                    }
                    case 4: {
                        while (lc.grid.field[x + n][y] == 0 && x + (n + 1) < lc.gridWidth) {
                            ++n;
                        }
                        break;
                    }
                }
                dirs[i] = n;
            }
            int bestDir = 0;
            int maxN = 0;
            for (i = 1; i < 5; ++i) {
                if (dirs[i] <= maxN && (dirs[i] != maxN || !state.random.nextBoolean())) continue;
                maxN = dirs[i];
                bestDir = i;
            }
            if (maxN == 1) {
                this.alive = false;
            }
            this.dir = bestDir;
        }
        if (this.dir == 1) {
            --y;
        }
        if (this.dir == 2) {
            ++y;
        }
        if (this.dir == 3) {
            --x;
        }
        if (this.dir == 4) {
            ++x;
        }
        if (x < 0 || x >= lc.gridWidth || y < 0 || y >= lc.gridHeight) {
            this.alive = false;
        } else if (lc.grid.field[x][y] != 0) {
            this.alive = false;
        } else {
            lc.cycleGrid.setObjectLocation(this, x, y);
            lc.grid.field[x][y] = this.my_id;
        }
    }
}

