/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lightcycles;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.lightcycles.ControlUI;
import sim.app.lightcycles.Cycle;
import sim.app.lightcycles.LightCycles;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.grid.FastValueGridPortrayal2D;
import sim.portrayal.grid.SparseGridPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.gui.SimpleColorMap;

public class LightCyclesWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    public ControlUI controls;
    FastValueGridPortrayal2D gridPortrayal = new FastValueGridPortrayal2D();
    SparseGridPortrayal2D cycleGridPortrayal = new SparseGridPortrayal2D();

    public static void main(String[] args) {
        new LightCyclesWithUI().createController();
    }

    public LightCyclesWithUI() {
        super(new LightCycles(System.currentTimeMillis()));
    }

    public LightCyclesWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Light Cycles";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
        if (this.controls != null) {
            this.controls.c = null;
        }
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.gridPortrayal.setField(((LightCycles)this.state).grid);
        Color[] colors = new Color[((LightCycles)this.state).cycleCount + 1];
        colors[0] = new Color(0, 0, 0, 0);
        for (int i = 1; i < colors.length; ++i) {
            colors[i] = new Color(this.guirandom.nextInt(255), this.guirandom.nextInt(255), this.guirandom.nextInt(255));
        }
        this.gridPortrayal.setMap(new SimpleColorMap(colors));
        this.cycleGridPortrayal.setField(((LightCycles)this.state).cycleGrid);
        this.cycleGridPortrayal.setPortrayalForClass(Cycle.class, new OvalPortrayal2D(Color.white));
        this.display.reset();
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(400.0, 400.0, this);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.gridPortrayal, "Paths");
        this.display.attach(this.cycleGridPortrayal, "Cycles");
        this.controls = new ControlUI(this, this.cycleGridPortrayal);
        this.display.setBackdrop(new Color(0, 0, 128));
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

