/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lsystem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import sim.app.lsystem.ByteList;
import sim.app.lsystem.DrawUI;
import sim.app.lsystem.LSystem;
import sim.app.lsystem.LSystemData;
import sim.app.lsystem.LSystemWithUI;
import sim.app.lsystem.Rule;
import sim.util.gui.LabelledList;

public class RuleUI
extends JPanel {
    private static final long serialVersionUID = -8650952120231540392L;
    JButton buttonGo = new JButton("Calculate");
    JButton buttonCancel = new JButton("Cancel");
    JButton buttonSave = new JButton("Save");
    JButton buttonLoad = new JButton("Load");
    JButton buttonHelp = new JButton("Help");
    JTable ruleTable = new JTable(20, 2);
    JScrollPane scrollPane = new JScrollPane(this.ruleTable);
    JProgressBar calcProgress = new JProgressBar(0, 100);
    JTextField seedField = new JTextField("F-F-F-F", 10);
    JTextField stepField = new JTextField("3", 3);
    JPanel helpPanel = new JPanel();
    LSystemWithUI lsui;
    LSystem ls;
    DrawUI dui;
    int steps = 0;
    Runnable calcRunnable;
    Thread calcThread;
    Object lock = new Object();
    boolean stop = false;

    public Frame getFrame() {
        Container c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    void getRulesFromUI() {
        this.ls.l.seed = this.seedField.getText();
        LSystemData.setVector(this.ls.l.code, this.ls.l.seed);
        this.ls.l.expansions = Integer.valueOf(this.stepField.getText());
        this.ls.l.rules.clear();
        for (int r = 0; r < this.ruleTable.getRowCount(); ++r) {
            if (this.ruleTable.getValueAt(r, 0) == null || this.ruleTable.getValueAt(r, 1) == null || ((String)this.ruleTable.getValueAt(r, 0)).length() <= 0 || ((String)this.ruleTable.getValueAt(r, 0)).length() <= 0) continue;
            this.ls.l.rules.add(new Rule((byte)((String)this.ruleTable.getValueAt(r, 0)).substring(0, 1).charAt(0), (String)this.ruleTable.getValueAt(r, 1)));
        }
        this.steps = Integer.valueOf(this.stepField.getText());
    }

    public RuleUI(LSystemWithUI nLsui, DrawUI nDui) {
        this.lsui = nLsui;
        this.ls = (LSystem)this.lsui.state;
        this.dui = nDui;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        this.calcRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int h = 0;
                int p = 0;
                int r = 0;
                boolean ruleApplied = false;
                ByteList newCode = new ByteList(RuleUI.this.ls.l.code.b.length);
                while (true) {
                    Object object = RuleUI.this.lock;
                    synchronized (object) {
                        if (RuleUI.this.stop) {
                            break;
                        }
                    }
                    if (h >= RuleUI.this.steps) break;
                    ruleApplied = false;
                    for (r = 0; r < RuleUI.this.ls.l.rules.size(); ++r) {
                        if (RuleUI.this.ls.l.code.b[p] != ((Rule)RuleUI.this.ls.l.rules.get((int)r)).pattern) continue;
                        newCode.addAll(((Rule)RuleUI.this.ls.l.rules.get((int)r)).replace);
                        ruleApplied = true;
                        break;
                    }
                    if (!ruleApplied) {
                        newCode.add(RuleUI.this.ls.l.code.b[p]);
                    }
                    if (++p % 100 == 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int i = RuleUI.this.calcProgress.getValue();
                                i = i < 100 ? ++i : 0;
                                RuleUI.this.calcProgress.setValue(i);
                            }
                        });
                    }
                    if (p < RuleUI.this.ls.l.code.length) continue;
                    p = 0;
                    ++h;
                    RuleUI.this.ls.l.code = newCode;
                    newCode = new ByteList(RuleUI.this.ls.l.code.length);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RuleUI.this.buttonGo.setEnabled(true);
                        RuleUI.this.buttonCancel.setEnabled(false);
                        RuleUI.this.calcProgress.setValue(0);
                        RuleUI.this.calcProgress.setString("Done!");
                    }
                });
            }
        };
        this.buttonGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleUI.this.getRulesFromUI();
                RuleUI.this.calcProgress.setString("Calculating...");
                RuleUI.this.stop = false;
                RuleUI.this.calcThread = new Thread(RuleUI.this.calcRunnable);
                RuleUI.this.calcThread.start();
                RuleUI.this.buttonCancel.setEnabled(true);
                RuleUI.this.buttonGo.setEnabled(false);
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = RuleUI.this.lock;
                synchronized (object) {
                    RuleUI.this.stop = true;
                }
                try {
                    RuleUI.this.calcThread.join();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                RuleUI.this.calcProgress.setValue(0);
                RuleUI.this.calcProgress.setString("Cancelled");
                RuleUI.this.buttonCancel.setEnabled(false);
                RuleUI.this.buttonGo.setEnabled(true);
            }
        });
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JOptionPane.showMessageDialog(RuleUI.this.getFrame(), "<html>IF you have changed the settings since the last time you calculated the L-system,<br>the L-system you save will be the one last calculated--not the current data!</html>");
                    FileDialog fd = new FileDialog(RuleUI.this.getFrame(), "Save Current L-System Settings As", 1);
                    fd.setFile("Untitled.lss");
                    fd.setVisible(true);
                    if (fd.getFile() == null) {
                        return;
                    }
                    File outputFile = new File(fd.getDirectory(), fd.getFile());
                    FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                    GZIPOutputStream g = new GZIPOutputStream(new BufferedOutputStream(outputFileStream));
                    ObjectOutputStream out = new ObjectOutputStream(g);
                    out.writeObject(RuleUI.this.ls.l);
                    out.flush();
                    g.finish();
                    g.flush();
                    out.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int t;
                    FileDialog fd = new FileDialog(RuleUI.this.getFrame(), "Open L-System Settings File (.lss)", 0);
                    fd.setFile("*.lss");
                    fd.setVisible(true);
                    if (fd.getFile() == null) {
                        return;
                    }
                    File inputFile = new File(fd.getDirectory(), fd.getFile());
                    FileInputStream inputFileStream = new FileInputStream(inputFile);
                    ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(inputFileStream)));
                    RuleUI.this.ls.l = (LSystemData)in.readObject();
                    in.close();
                    RuleUI.this.seedField.setText(RuleUI.this.ls.l.seed);
                    RuleUI.this.stepField.setText(String.valueOf(RuleUI.this.ls.l.expansions));
                    RuleUI.this.dui.distField.setText(String.valueOf(RuleUI.this.ls.l.segsize));
                    RuleUI.this.dui.angleField.setText(String.valueOf(RuleUI.this.ls.l.angle * 180.0 / Math.PI));
                    for (t = 0; t < RuleUI.this.ruleTable.getRowCount(); ++t) {
                        RuleUI.this.ruleTable.setValueAt(null, t, 0);
                        RuleUI.this.ruleTable.setValueAt(null, t, 1);
                    }
                    for (t = 0; t < RuleUI.this.ls.l.rules.size(); ++t) {
                        RuleUI.this.ruleTable.setValueAt(String.valueOf((char)((Rule)RuleUI.this.ls.l.rules.get((int)t)).pattern), t, 0);
                        RuleUI.this.ruleTable.setValueAt(LSystemData.fromVector(((Rule)RuleUI.this.ls.l.rules.get((int)t)).replace), t, 1);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame help = new JFrame();
                help.getContentPane().setLayout(new BorderLayout());
                help.getContentPane().add((Component)RuleUI.this.helpPanel, "Center");
                help.setSize(400, 300);
                help.setVisible(true);
            }
        });
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        JPanel mid = new JPanel();
        top.setLayout(new BorderLayout());
        mid.setLayout(new BorderLayout());
        LabelledList list = new LabelledList(){
            private static final long serialVersionUID = -2153709747861890863L;
            Insets insets = new Insets(5, 5, 5, 5);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.seedField.setText(this.ls.l.seed);
        list.addLabelled("Seed", this.seedField);
        list.addLabelled("Expansions", this.stepField);
        top.add((Component)list, "North");
        Box b = new Box(0){
            private static final long serialVersionUID = -869949739122977643L;
            Insets insets;
            {
                this.insets = new Insets(5, 5, 5, 5);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.buttonGo);
        b.add(this.buttonCancel);
        this.buttonCancel.setEnabled(false);
        b.add(Box.createGlue());
        top.add((Component)b, "Center");
        top.add((Component)this.calcProgress, "South");
        this.calcProgress.setStringPainted(true);
        this.calcProgress.setString("Press Calculate");
        b = new Box(0){
            private static final long serialVersionUID = -2124038237393174259L;
            Insets insets;
            {
                this.insets = new Insets(5, 5, 5, 5);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.buttonSave);
        b.add(this.buttonLoad);
        b.add(this.buttonHelp);
        b.add(Box.createGlue());
        mid.add((Component)top, "North");
        mid.add((Component)b, "Center");
        this.add((Component)mid, "North");
        class NamedTableModel
        extends DefaultTableModel {
            private static final long serialVersionUID = -6638838065039609876L;

            NamedTableModel(int rows, int cols) {
                super(rows, cols);
            }

            @Override
            public String getColumnName(int i) {
                if (i == 0) {
                    return "Symbol";
                }
                if (i == 1) {
                    return "Replacement";
                }
                return "Error.";
            }
        }
        this.ruleTable.setModel(new NamedTableModel(20, 2));
        this.seedField.setText("F");
        this.ruleTable.setValueAt("F", 0, 0);
        this.ruleTable.setValueAt("F[+F]F[-F]F", 0, 1);
        this.add((Component)this.scrollPane, "Center");
        LabelledList list2 = new LabelledList();
        this.helpPanel.setLayout(new BorderLayout());
        list2.addLabelled("Symbols", new JLabel(""));
        list2.addLabelled("Uppercase (A-Z)", new JLabel("Draw forward Distance units"));
        list2.addLabelled("Lowercase (a-z)", new JLabel("Move forward Distance units (no draw)"));
        list2.addLabelled("-", new JLabel("Turn right by angle degrees"));
        list2.addLabelled("+", new JLabel("Turn left by angle degrees"));
        list2.addLabelled("[", new JLabel("Push position, angle"));
        list2.addLabelled("]", new JLabel("Pop position, angle"));
        list2.addLabelled("", new JLabel(""));
        list2.addLabelled("Save: ", new JLabel("Saves the rules, seed, draw settings, and "));
        list2.addLabelled("", new JLabel("calculated expansions of the "));
        list2.addLabelled("", new JLabel("Last calculated L-system."));
        list2.addLabelled("Load: ", new JLabel("Loads saved L-system settings."));
        this.helpPanel.add((Component)list2, "Center");
    }
}

