/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mav;

import sim.app.mav.Mav;
import sim.app.mav.Region;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Double2D;

public class MavDemo
extends SimState {
    private static final long serialVersionUID = 1L;
    public Continuous2D ground;
    public Continuous2D mavs;
    public double width = 500.0;
    public double height = 500.0;
    public double crashDistance = 8.0;
    public double sensorRangeDistance = 50.0;
    public int numMavs = 30;
    public Region[] region = new Region[]{new Region(0, 1, 50.0, 50.0), new Region(1, 2, 200.0, 200.0), new Region(2, 3, 200.0, 450.0)};

    public MavDemo(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        int i;
        super.start();
        this.ground = new Continuous2D(this.width > this.height ? this.width : this.height, this.width, this.height);
        for (i = 0; i < this.region.length; ++i) {
            this.ground.setObjectLocation((Object)this.region[i], new Double2D(this.region[i].originx, this.region[i].originy));
        }
        this.mavs = new Continuous2D(this.sensorRangeDistance * 2.0, this.width, this.height);
        for (i = 0; i < this.numMavs; ++i) {
            Mav mav = new Mav(4, this.random.nextDouble() * this.width, this.random.nextDouble() * this.height);
            this.mavs.setObjectLocation((Object)mav, new Double2D(mav.x, mav.y));
            this.schedule.scheduleRepeating(mav);
        }
    }

    public static void main(String[] args) {
        MavDemo.doLoop(MavDemo.class, args);
        System.exit(0);
    }
}

