/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pacman;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import sim.app.pacman.PacMan;
import sim.app.pacman.PacManWithUI;
import sim.display.SimpleController;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;

public class Overlay
extends FieldPortrayal2D {
    private static final long serialVersionUID = 1L;
    PacManWithUI ui;
    public static final int GUTTER = 32;
    public static final int BORDER = 8;
    Font font = new Font("SansSerif", 1, 18);
    Color color = new Color(33, 33, 222);
    int firstTimeScoreY = 0;

    public Overlay(PacManWithUI ui) {
        this.ui = ui;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        PacMan pacman = (PacMan)this.ui.state;
        graphics.setFont(this.font);
        graphics.setColor(Color.white);
        Rectangle2D bounds = new TextLayout("" + pacman.score, this.font, graphics.getFontRenderContext()).getBounds();
        if (this.firstTimeScoreY == 0) {
            this.firstTimeScoreY = (int)((32.0 + bounds.getHeight()) / 2.0);
        }
        if (((SimpleController)this.ui.controller).getPlayState() == 2) {
            bounds = new TextLayout("Paused", this.font, graphics.getFontRenderContext()).getBounds();
            graphics.drawString("Paused", (int)((info.clip.width - bounds.getWidth()) / 2.0), this.firstTimeScoreY);
        } else {
            graphics.drawString("Deaths: " + pacman.deaths, 8, this.firstTimeScoreY);
            graphics.drawString("Level: " + pacman.level, (int)((info.clip.width - 16.0) * 1.0 / 3.0 + 8.0), this.firstTimeScoreY);
            graphics.drawString("Score: " + pacman.score, (int)((info.clip.width - 16.0) * 2.0 / 3.0 + 8.0), this.firstTimeScoreY);
        }
        String text = "M: MASON   P: Pause   R: Reset   adws / \u2190\u2192\u2191\u2193";
        bounds = new TextLayout(text, this.font, graphics.getFontRenderContext()).getBounds();
        graphics.drawString(text, (int)((info.clip.width - bounds.getWidth()) / 2.0), (int)(info.clip.height - 32.0 + (double)this.firstTimeScoreY));
    }
}

