/*
 * Decompiled with CFR 0.152.
 */
package sim.app.particles3d;

import sim.app.particles3d.Particles3D;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.Bag;
import sim.util.Int3D;
import sim.util.IntBag;

public class Particle
implements Steppable {
    private static final long serialVersionUID = 1L;
    public boolean randomize = false;
    public int xdir;
    public int ydir;
    public int zdir;
    IntBag xPos = new IntBag();
    IntBag yPos = new IntBag();
    IntBag zPos = new IntBag();

    public Particle(int xdir, int ydir, int zdir) {
        this.xdir = xdir;
        this.ydir = ydir;
        this.zdir = zdir;
    }

    @Override
    public void step(SimState state) {
        Particles3D tut = (Particles3D)state;
        Int3D location = tut.particles.getObjectLocation(this);
        tut.trails.field[location.x][location.y][location.z] = 1.0;
        if (this.randomize) {
            this.xdir = tut.random.nextInt(3) - 1;
            this.ydir = tut.random.nextInt(3) - 1;
            this.zdir = tut.random.nextInt(3) - 1;
            this.randomize = false;
        }
        int newx = location.x + this.xdir;
        int newy = location.y + this.ydir;
        int newz = location.z + this.zdir;
        if (newx < 0) {
            ++newx;
            this.xdir = -this.xdir;
        } else if (newx >= tut.particles.getWidth()) {
            --newx;
            this.xdir = -this.xdir;
        }
        if (newy < 0) {
            ++newy;
            this.ydir = -this.ydir;
        } else if (newy >= tut.particles.getHeight()) {
            --newy;
            this.ydir = -this.ydir;
        }
        if (newz < 0) {
            ++newz;
            this.zdir = -this.zdir;
        } else if (newz >= tut.particles.getLength()) {
            --newz;
            this.zdir = -this.zdir;
        }
        Int3D newLoc = new Int3D(newx, newy, newz);
        tut.particles.setObjectLocation((Object)this, newLoc);
        Bag p = tut.particles.getObjectsAtLocation(newLoc);
        if (p.numObjs > 1) {
            for (int x = 0; x < p.numObjs; ++x) {
                ((Particle)p.objs[x]).randomize = true;
            }
        }
    }
}

