/*
 * Decompiled with CFR 0.152.
 */
package sim.app.schelling;

import sim.app.schelling.Agent;
import sim.engine.SimState;
import sim.field.grid.IntGrid2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.Interval;

public class Schelling
extends SimState {
    private static final long serialVersionUID = 1L;
    public int gridHeight;
    public int gridWidth;
    public int neighborhood = 1;
    public int threshold = 3;
    public double redProbability = 0.3;
    public double blueProbability = 0.3;
    public double emptyProbability = 0.3;
    public double unavailableProbability = 0.1;
    public IntGrid2D neighbors;
    public Bag emptySpaces = new Bag();
    public static final int EMPTY = 0;
    public static final int UNAVAILABLE = 1;
    public static final int RED = 2;
    public static final int BLUE = 3;

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int val) {
        if (val > 0) {
            this.gridHeight = val;
        }
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int val) {
        if (val > 0) {
            this.gridWidth = val;
        }
    }

    public int getNeighborhood() {
        return this.neighborhood;
    }

    public void setNeighborhood(int val) {
        if (val > 0) {
            this.neighborhood = val;
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int val) {
        if (val >= 0) {
            this.threshold = val;
        }
    }

    public Object domRedProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getRedProbability() {
        return this.redProbability;
    }

    public void setRedProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.redProbability = val;
        }
    }

    public Object domBlueProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getBlueProbability() {
        return this.blueProbability;
    }

    public void setBlueProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.blueProbability = val;
        }
    }

    public Object domEmptyProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getEmptyProbability() {
        return this.emptyProbability;
    }

    public void setEmptyProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.emptyProbability = val;
        }
    }

    public Object domUnavailableProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getUnavailableProbability() {
        return this.unavailableProbability;
    }

    public void setUnavailableProbability(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.unavailableProbability = val;
            double total = this.redProbability + this.blueProbability + this.emptyProbability;
            if (total == 0.0) {
                total = 1.0;
            }
            this.redProbability *= (1.0 - this.unavailableProbability) / total;
            this.blueProbability *= (1.0 - this.unavailableProbability) / total;
            this.emptyProbability *= (1.0 - this.unavailableProbability) / total;
        }
    }

    public Schelling(long seed) {
        this(seed, 100, 100);
    }

    public Schelling(long seed, int width, int height) {
        super(seed);
        this.gridWidth = width;
        this.gridHeight = height;
        this.createGrids();
    }

    protected void createGrids() {
        this.emptySpaces.clear();
        this.neighbors = new IntGrid2D(this.gridWidth, this.gridHeight, 0);
        int[][] g = this.neighbors.field;
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                double d = this.random.nextDouble();
                if (d < this.redProbability) {
                    g[x][y] = 2;
                    continue;
                }
                if (d < this.redProbability + this.blueProbability) {
                    g[x][y] = 3;
                    continue;
                }
                if (d < this.redProbability + this.blueProbability + this.emptyProbability) {
                    g[x][y] = 0;
                    this.emptySpaces.add(new Int2D(x, y));
                    continue;
                }
                g[x][y] = 1;
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.createGrids();
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                this.schedule.scheduleRepeating(new Agent(x, y));
            }
        }
    }

    public static void main(String[] args) {
        Schelling.doLoop(Schelling.class, args);
        System.exit(0);
    }
}

