/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial1and2;

import java.io.File;
import sim.app.tutorial1and2.CA;
import sim.engine.SimState;
import sim.field.grid.IntGrid2D;

public class Tutorial1
extends SimState {
    private static final long serialVersionUID = 1L;
    public IntGrid2D grid;
    public int gridWidth = 100;
    public int gridHeight = 100;
    public static final int[][] b_heptomino = new int[][]{{0, 1, 1}, {1, 1, 0}, {0, 1, 1}, {0, 0, 1}};

    public Tutorial1(long seed) {
        super(seed);
    }

    void seedGrid() {
        for (int x = 0; x < b_heptomino.length; ++x) {
            for (int y = 0; y < b_heptomino[x].length; ++y) {
                this.grid.field[x + this.grid.field.length / 2 - Tutorial1.b_heptomino.length / 2][y + this.grid.field[x].length / 2 - Tutorial1.b_heptomino[x].length / 2] = b_heptomino[x][y];
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.grid = new IntGrid2D(this.gridWidth, this.gridHeight);
        this.seedGrid();
        this.schedule.scheduleRepeating(new CA());
    }

    public static void main(String[] args) {
        Tutorial1 tutorial1 = new Tutorial1(System.currentTimeMillis());
        tutorial1.start();
        long steps = 0L;
        while (steps < 5000L && tutorial1.schedule.step(tutorial1)) {
            steps = tutorial1.schedule.getSteps();
            if (steps % 500L != 0L) continue;
            System.out.println("Steps: " + steps + " Time: " + tutorial1.schedule.getTime());
        }
        tutorial1.finish();
        System.exit(0);
    }

    public static void main2(String[] args) {
        Tutorial1 tutorial1 = null;
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals("-checkpoint")) continue;
            SimState state = SimState.readFromCheckpoint(new File(args[x + 1]));
            if (state == null) {
                System.exit(1);
                continue;
            }
            if (!(state instanceof Tutorial1)) {
                System.out.println("Checkpoint contains some other simulation: " + state);
                System.exit(1);
                continue;
            }
            tutorial1 = (Tutorial1)state;
        }
        if (tutorial1 == null) {
            tutorial1 = new Tutorial1(System.currentTimeMillis());
            tutorial1.start();
        }
        long steps = 0L;
        while (steps < 5000L && tutorial1.schedule.step(tutorial1)) {
            steps = tutorial1.schedule.getSteps();
            if (steps % 500L != 0L) continue;
            System.out.println("Steps: " + steps + " Time: " + tutorial1.schedule.getTime());
            String s = steps + ".Tutorial1.checkpoint";
            System.out.println("Checkpointing to file: " + s);
            tutorial1.writeToCheckpoint(new File(s));
        }
        tutorial1.finish();
        System.exit(0);
    }

    public static void main3(String[] args) {
        Tutorial1.doLoop(Tutorial1.class, args);
        System.exit(0);
    }
}

