/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial4;

import sim.app.tutorial4.BigParticle;
import sim.app.tutorial4.Particle;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.Int2D;

public class Tutorial4
extends SimState {
    public DoubleGrid2D trails;
    public SparseGrid2D particles;
    public int collisions;
    public double collisionRate;
    public int gridWidth = 100;
    public int gridHeight = 100;
    public int numParticles = 500;
    private static final long serialVersionUID = 1L;

    public double getCollisionRate() {
        return this.collisionRate;
    }

    public int getWidth() {
        return this.gridWidth;
    }

    public void setWidth(int val) {
        if (val > 0) {
            this.gridWidth = val;
        }
    }

    public int getHeight() {
        return this.gridHeight;
    }

    public void setHeight(int val) {
        if (val > 0) {
            this.gridHeight = val;
        }
    }

    public int getNumParticles() {
        return this.numParticles;
    }

    public void setNumParticles(int val) {
        if (val >= 0) {
            this.numParticles = val;
        }
    }

    public Tutorial4(long seed) {
        super(seed);
    }

    @Override
    public void start() {
        super.start();
        this.trails = new DoubleGrid2D(this.gridWidth, this.gridHeight);
        this.particles = new SparseGrid2D(this.gridWidth, this.gridHeight);
        for (int i = 0; i < this.numParticles; ++i) {
            Particle p = new Particle(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            this.schedule.scheduleRepeating(p);
            this.particles.setObjectLocation((Object)p, new Int2D(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight)));
        }
        BigParticle b = new BigParticle(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
        this.particles.setObjectLocation((Object)b, new Int2D(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight)));
        this.schedule.scheduleRepeating(0.0, 1, b, 5.0);
        Steppable decreaser = new Steppable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void step(SimState state) {
                Tutorial4.this.trails.multiply(0.9);
                Tutorial4.this.collisionRate = (double)Tutorial4.this.collisions / (double)Tutorial4.this.numParticles;
                Tutorial4.this.collisions = 0;
            }
        };
        this.schedule.scheduleRepeating(0.0, 2, decreaser, 1.0);
    }

    public static void main(String[] args) {
        Tutorial4.doLoop(Tutorial4.class, args);
        System.exit(0);
    }
}

