/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial5;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import sim.app.tutorial5.Band;
import sim.app.tutorial5.Tutorial5;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.continuous.Continuous2D;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Ball
extends SimplePortrayal2D
implements Steppable {
    private static final long serialVersionUID = 1L;
    public double forcex;
    public double forcey;
    public double mass;
    public double velocityx;
    public double velocityy;
    public boolean collision;
    public double diameter;

    public double getVelocityX() {
        return this.velocityx;
    }

    public void setVelocityX(double val) {
        this.velocityx = val;
    }

    public double getVelocityY() {
        return this.velocityy;
    }

    public void setVelocityY(double val) {
        this.velocityy = val;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double val) {
        if (val > 0.0) {
            this.mass = val;
            this.diameter = Math.sqrt(val);
        }
    }

    public Ball(double vx, double vy, double m) {
        this.velocityx = vx;
        this.velocityy = vy;
        this.mass = m;
        this.diameter = Math.sqrt(m);
    }

    public void computeCollision(Tutorial5 tut) {
        Double2D me = tut.balls.getObjectLocation(this);
        Bag b = tut.balls.getNeighborsExactlyWithinDistance(me, 5.0);
        this.collision = b.numObjs > 1;
    }

    public void addForce(Double2D otherBallLoc, Double2D myLoc, Band band) {
        double dx = otherBallLoc.x - myLoc.x;
        double dy = otherBallLoc.y - myLoc.y;
        double len = Math.sqrt(dx * dx + dy * dy);
        double l = band.laxDistance;
        double k = band.strength / 512.0;
        double forcemagnitude = (len - l) * k;
        if (len - l > 0.0) {
            this.forcex += dx * forcemagnitude / len;
            this.forcey += dy * forcemagnitude / len;
        }
    }

    public void computeForce(SimState state) {
        Double2D him;
        Ball other;
        Band b;
        Edge e;
        int x;
        Tutorial5 tut = (Tutorial5)state;
        Network bands = tut.bands;
        Continuous2D balls = tut.balls;
        Double2D me = balls.getObjectLocation(this);
        this.forcex = 0.0;
        this.forcey = 0.0;
        Bag in = bands.getEdgesIn(this);
        Bag out = bands.getEdgesOut(this);
        if (in != null) {
            for (x = 0; x < in.numObjs; ++x) {
                e = (Edge)in.objs[x];
                b = (Band)e.info;
                other = (Ball)e.from();
                him = balls.getObjectLocation(other);
                this.addForce(him, me, b);
            }
        }
        if (out != null) {
            for (x = 0; x < out.numObjs; ++x) {
                e = (Edge)out.objs[x];
                b = (Band)e.info;
                other = (Ball)e.to();
                him = balls.getObjectLocation(other);
                this.addForce(him, me, b);
            }
        }
    }

    @Override
    public void step(SimState state) {
        Tutorial5 tut = (Tutorial5)state;
        double ax = this.forcex / this.mass;
        double ay = this.forcey / this.mass;
        this.velocityx += ax;
        this.velocityy += ay;
        Double2D pos = tut.balls.getObjectLocation(this);
        Double2D newpos = new Double2D(pos.x + this.velocityx, pos.y + this.velocityy);
        tut.balls.setObjectLocation((Object)this, newpos);
        this.computeCollision(tut);
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double width = info.draw.width * this.diameter;
        double height = info.draw.height * this.diameter;
        if (this.collision) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.blue);
        }
        int x = (int)(info.draw.x - width / 2.0);
        int y = (int)(info.draw.y - height / 2.0);
        int w = (int)width;
        int h = (int)height;
        graphics.fillOval(x, y, w, h);
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        double SLOP = 1.0;
        double width = range.draw.width * this.diameter;
        double height = range.draw.height * this.diameter;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(range.draw.x - width / 2.0 - 1.0, range.draw.y - height / 2.0 - 1.0, width + 2.0, height + 2.0);
        return ellipse.intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
    }
}

