/*
 * Decompiled with CFR 0.152.
 */
package sim.app.tutorial7;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.tutorial6.Tutorial6WithUI;
import sim.app.tutorial7.Tutorial7;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.grid.SparseGridPortrayal3D;
import sim.portrayal3d.grid.ValueGrid2DPortrayal3D;
import sim.portrayal3d.grid.quad.MeshPortrayal;
import sim.portrayal3d.grid.quad.TilePortrayal;
import sim.portrayal3d.simple.SpherePortrayal3D;
import sim.util.gui.SimpleColorMap;

public class Tutorial7WithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    Tutorial7 tutorial7;
    SparseGridPortrayal3D fliesPortrayal = new SparseGridPortrayal3D();
    ValueGrid2DPortrayal3D xProjectionPortrayal = new ValueGrid2DPortrayal3D("X Projection");
    ValueGrid2DPortrayal3D yProjectionPortrayal = new ValueGrid2DPortrayal3D("Y Projection");
    ValueGrid2DPortrayal3D zProjectionPortrayal = new ValueGrid2DPortrayal3D("Z Projection");

    public static void main(String[] args) {
        new Tutorial7WithUI().createController();
    }

    public Tutorial7WithUI() {
        super(new Tutorial7(System.currentTimeMillis()));
    }

    public Tutorial7WithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Tutorial 7: Projections";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Tutorial7 tut = (Tutorial7)this.state;
        this.fliesPortrayal.setField(tut.flies);
        this.xProjectionPortrayal.setField(tut.xProjection);
        this.yProjectionPortrayal.setField(tut.yProjection);
        this.zProjectionPortrayal.setField(tut.zProjection);
        this.display.reset();
        this.display.createSceneGraph();
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        Tutorial7 tut = (Tutorial7)this.state;
        this.fliesPortrayal.setPortrayalForAll(new SpherePortrayal3D(0.5));
        SimpleColorMap map = new SimpleColorMap(0.0, 4.0, Color.green, Color.yellow);
        this.xProjectionPortrayal.setPortrayalForAll(new TilePortrayal(map));
        this.xProjectionPortrayal.setTransparency(0.8f);
        this.xProjectionPortrayal.translate(0.0, 0.0, -1.0);
        this.xProjectionPortrayal.rotateX(90.0);
        this.xProjectionPortrayal.rotateZ(90.0);
        map = new SimpleColorMap(0.0, 4.0, Color.blue, Color.yellow);
        this.yProjectionPortrayal.setPortrayalForAll(new TilePortrayal(map, 1.0));
        this.yProjectionPortrayal.translate(0.0, 0.0, 1.0);
        this.yProjectionPortrayal.rotateX(90.0);
        map = new SimpleColorMap(0.0, 4.0, Color.red, Color.blue);
        this.zProjectionPortrayal.setPortrayalForAll(new MeshPortrayal(map, -0.5));
        this.zProjectionPortrayal.translate(0.0, 0.0, -1.0);
        this.zProjectionPortrayal.setUsingTriangles(true);
        this.zProjectionPortrayal.setImage(Tutorial6WithUI.loadImage("earthmap.jpg"));
        this.display = new Display3D(600.0, 600.0, this);
        this.display.attach(this.fliesPortrayal, "Flies");
        this.display.attach(this.xProjectionPortrayal, "X Projection");
        this.display.attach(this.yProjectionPortrayal, "Y Projection");
        this.display.attach(this.zProjectionPortrayal, "Z Projection");
        float scale = Math.max(Math.max(tut.width, tut.height), tut.length);
        this.display.scale(1.0f / scale);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }
}

