/*
 * Decompiled with CFR 0.152.
 */
package sim.app.virus;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.app.virus.Agent;
import sim.app.virus.Human;
import sim.app.virus.VirusInfectionDemo;
import sim.engine.SimState;
import sim.portrayal.DrawInfo2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Good
extends Agent {
    private static final long serialVersionUID = 1L;
    protected boolean greedy = false;
    Double2D desiredLocation = null;
    Double2D suggestedLocation = null;
    int steps = 0;
    protected Color goodColor = new Color(0, 0, 0);
    protected Color goodMarkColor = new Color(255, 0, 0);

    public final boolean getIsGreedy() {
        return this.greedy;
    }

    public final void setIsGreedy(boolean b) {
        this.greedy = b;
    }

    public Good(String id, Double2D location) {
        super(id, location);
        try {
            this.intID = Integer.parseInt(id.substring(4));
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Exception generated: " + e);
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Exception generated: " + e);
            System.exit(1);
        }
    }

    @Override
    public void step(SimState state) {
        double dy;
        double dx;
        double temp;
        VirusInfectionDemo hb = (VirusInfectionDemo)state;
        this.desiredLocation = null;
        double distance2DesiredLocation = 1.0E30;
        Bag mysteriousObjects = hb.environment.getNeighborsWithinDistance(this.agentLocation, 1000.0);
        if (mysteriousObjects != null) {
            for (int i = 0; i < mysteriousObjects.numObjs; ++i) {
                double tmpDist;
                Human ta;
                if (mysteriousObjects.objs[i] == null || mysteriousObjects.objs[i] == this || !((Agent)mysteriousObjects.objs[i] instanceof Human) || !(ta = (Human)mysteriousObjects.objs[i]).isInfected()) continue;
                if (hb.withinHealingDistance(this, this.agentLocation, ta, ta.agentLocation)) {
                    ta.setInfected(false);
                    continue;
                }
                if (!this.getIsGreedy() || !((tmpDist = this.distanceSquared(this.agentLocation, ta.agentLocation)) < distance2DesiredLocation)) continue;
                this.desiredLocation = ta.agentLocation;
                distance2DesiredLocation = tmpDist;
            }
        }
        --this.steps;
        if (this.desiredLocation == null || !this.getIsGreedy()) {
            if (this.steps <= 0) {
                this.suggestedLocation = new Double2D((state.random.nextDouble() - 0.5) * 152.0 + this.agentLocation.x, (state.random.nextDouble() - 0.5) * 112.0 + this.agentLocation.y);
                this.steps = 100;
            }
            this.desiredLocation = this.suggestedLocation;
        }
        if ((temp = 0.5 * Math.sqrt((dx = this.desiredLocation.x - this.agentLocation.x) * dx + (dy = this.desiredLocation.y - this.agentLocation.y) * dy)) < 1.0) {
            this.steps = 0;
        } else {
            dx /= temp;
            dy /= temp;
        }
        if (!hb.acceptablePosition(this, new Double2D(this.agentLocation.x + dx, this.agentLocation.y + dy))) {
            this.steps = 0;
        } else {
            this.agentLocation = new Double2D(this.agentLocation.x + dx, this.agentLocation.y + dy);
            hb.environment.setObjectLocation((Object)this, this.agentLocation);
        }
    }

    @Override
    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double diamx = info.draw.width * 8.0;
        double diamy = info.draw.height * 8.0;
        graphics.setColor(this.goodColor);
        graphics.fillOval((int)(info.draw.x - diamx / 2.0), (int)(info.draw.y - diamy / 2.0), (int)diamx, (int)diamy);
        graphics.setColor(this.goodMarkColor);
        graphics.fillRect((int)(info.draw.x - diamx / 3.0), (int)(info.draw.y - diamy / 16.0), (int)(diamx / 1.5), (int)(diamy / 8.0));
        graphics.fillRect((int)(info.draw.x - diamx / 16.0), (int)(info.draw.y - diamy / 3.0), (int)(diamx / 8.0), (int)(diamy / 1.5));
    }

    @Override
    public String getType() {
        return "Good";
    }
}

