/*
 * Decompiled with CFR 0.152.
 */
package sim.app.wcss.tutorial07;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.wcss.tutorial07.Students;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;

public class StudentsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D yardPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        StudentsWithUI vid = new StudentsWithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public StudentsWithUI() {
        super(new Students(System.currentTimeMillis()));
    }

    public StudentsWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "WCSS 2008 Tutorial";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Students students = (Students)this.state;
        this.yardPortrayal.setField(students.yard);
        this.yardPortrayal.setPortrayalForAll(new OvalPortrayal2D());
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, this);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Schoolyard Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.yardPortrayal, "Yard");
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

