/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims;

import sim.app.woims.Obstacle;
import sim.app.woims.Woim;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Double2D;

public class WoimsDemo
extends SimState {
    private static final long serialVersionUID = 1L;
    public static final double XMIN = 0.0;
    public static final double XMAX = 200.0;
    public static final double YMIN = 0.0;
    public static final double YMAX = 200.0;
    public static final double DIAMETER = 1.0;
    public static final double[][] obstInfo = new double[][]{{20.0, 40.0, 40.0}, {30.0, 135.0, 135.0}};
    public static final int NUM_WOIMS = 40;
    public static final double TIMESTEP = 2.0;
    public static final double EXTRA_SPACE = 25.0;
    public static final int MAX_LINKS = 1000;
    public Continuous2D woimsEnvironment = null;
    public Continuous2D obstaclesEnvironment = null;

    public WoimsDemo(long seed) {
        super(seed);
    }

    public void setObjectLocation(Woim woim, Double2D location) {
        double x = (location.x + 25.0 - 0.0 + 250.0) % 250.0 + 0.0 - 25.0;
        double y = (location.y + 25.0 - 0.0 + 250.0) % 250.0 + 0.0 - 25.0;
        location = new Double2D(x, y);
        this.woimsEnvironment.setObjectLocation((Object)woim, location);
        woim.x = location.x;
        woim.y = location.y;
    }

    @Override
    public void start() {
        super.start();
        this.woimsEnvironment = new Continuous2D(Woim.MAX_DISTANCE, 200.0, 200.0);
        this.obstaclesEnvironment = new Continuous2D(30.0, 200.0, 200.0);
        for (int x = 0; x < 40; ++x) {
            Double2D loc = null;
            Woim woim = null;
            int caz = this.random.nextInt(4);
            switch (caz) {
                case 0: {
                    loc = new Double2D(-25.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 1: {
                    loc = new Double2D(225.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 2: {
                    loc = new Double2D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, -25.0);
                    break;
                }
                case 3: {
                    loc = new Double2D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, 225.0);
                }
            }
            woim = new Woim();
            this.woimsEnvironment.setObjectLocation((Object)woim, loc);
            woim.x = loc.x;
            woim.y = loc.y;
            this.schedule.scheduleRepeating(woim);
        }
        for (int i = 0; i < obstInfo.length; ++i) {
            Obstacle obst = new Obstacle(obstInfo[i][0]);
            this.obstaclesEnvironment.setObjectLocation((Object)obst, new Double2D(obstInfo[i][1], obstInfo[i][2]));
        }
    }

    public static void main(String[] args) {
        WoimsDemo.doLoop(WoimsDemo.class, args);
        System.exit(0);
    }
}

