/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import sim.engine.SimState;
import sim.engine.Steppable;

public class RateAdjuster
implements Steppable {
    private static final long serialVersionUID = 1L;
    long initialTime;
    long totalTics;
    boolean started = false;
    double rate;
    static final int MAX_POLL_ITERATIONS = 3;

    public RateAdjuster(double targetRate) {
        this.rate = targetRate;
    }

    @Override
    public void step(SimState state) {
        if (!this.started) {
            this.initialTime = System.currentTimeMillis();
            this.started = true;
        } else {
            long currentTime = System.currentTimeMillis();
            long time = currentTime - this.initialTime;
            ++this.totalTics;
            long expectedTime = (long)((double)this.totalTics / this.rate * 1000.0);
            int count = 0;
            while (time < expectedTime && count++ < 3) {
                try {
                    Thread.currentThread();
                    Thread.sleep(expectedTime - time);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                currentTime = System.currentTimeMillis();
                time = currentTime - this.initialTime;
            }
            this.initialTime = currentTime;
            this.totalTics = 0L;
        }
    }
}

