/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sim.display.Console;
import sim.display.Controller;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.util.Bag;

public class SimpleController
implements Controller {
    GUIState simulation;
    long randomSeed = 0L;
    boolean displayInspectors;
    Thread playThread;
    final Object playThreadLock = new Object();
    boolean threadShouldStop = false;
    public static final int PS_STOPPED = 0;
    public static final int PS_PLAYING = 1;
    public static final int PS_PAUSED = 2;
    int playState = 0;
    boolean isClosing = false;
    final Object isClosingLock = new Object();
    boolean incrementSeedOnStop = true;
    Runnable blocker = new Runnable(){

        @Override
        public void run() {
        }
    };
    Vector frameList = new Vector();
    Vector inspectorStoppables = new Vector();
    WeakHashMap allInspectors = new WeakHashMap();

    public GUIState getSimulation() {
        return this.simulation;
    }

    public SimpleController(GUIState simulation) {
        this(simulation, true);
        this.randomSeed = simulation.state.seed();
    }

    public SimpleController(final GUIState simulation, boolean displayInspectors) {
        this.displayInspectors = displayInspectors;
        this.simulation = simulation;
        this.invokeInSwing(new Runnable(){

            @Override
            public void run() {
                simulation.init(SimpleController.this);
            }
        });
        Console.allControllers.put(this, this);
    }

    void invokeInSwing(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThreadShouldStop() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.threadShouldStop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadShouldStop(boolean stop) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.threadShouldStop = stop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlayState(int state) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.playState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.playState;
        }
    }

    void startSimulation() {
        this.removeAllInspectors(true);
        this.simulation.state.setSeed(this.randomSeed);
        this.simulation.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        Object object = this.isClosingLock;
        synchronized (object) {
            if (this.isClosing) {
                return;
            }
            this.isClosing = true;
        }
        this.pressStop();
        this.simulation.quit();
        Console.allControllers.remove(this);
        if (Console.allControllers.size() == 0) {
            Console.doQuit();
        }
    }

    public void setIncrementSeedOnPlay(boolean val) {
        this.setIncrementSeedOnStop(val);
    }

    public boolean getIncrementSeedOnPlay() {
        return this.getIncrementSeedOnStop();
    }

    public void setIncrementSeedOnStop(boolean val) {
        this.incrementSeedOnStop = val;
    }

    public boolean getIncrementSeedOnStop() {
        return this.incrementSeedOnStop;
    }

    public synchronized void pressStop() {
        if (this.getPlayState() != 0) {
            this.killPlayThread();
            this.simulation.finish();
            this.stopAllInspectors(true);
            this.setPlayState(0);
            if (this.getIncrementSeedOnStop()) {
                this.randomSeed = (int)(this.randomSeed + 1L);
            }
        }
    }

    public synchronized void pressPause() {
        this.pressPause(true);
    }

    synchronized void pressPause(boolean shouldStartSimulationIfStopped) {
        if (this.getPlayState() == 1) {
            this.killPlayThread();
            this.setPlayState(2);
            this.refresh();
        } else if (this.getPlayState() == 2) {
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 0) {
            if (shouldStartSimulationIfStopped) {
                this.startSimulation();
            }
            this.setPlayState(2);
            this.refresh();
        }
    }

    public synchronized void pressPlay() {
        if (this.getPlayState() == 0) {
            this.startSimulation();
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 2) {
            if (!this.simulation.step()) {
                this.pressStop();
            }
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void killPlayThread() {
        block8: {
            this.setThreadShouldStop(true);
            try {
                if (this.playThread == null) break block8;
                do {
                    try {
                        Schedule schedule = this.simulation.state.schedule;
                        synchronized (schedule) {
                            this.playThread.interrupt();
                        }
                    }
                    catch (SecurityException ex) {
                        // empty catch block
                    }
                    this.playThread.join(50L);
                } while (this.playThread.isAlive());
                this.playThread = null;
            }
            catch (InterruptedException e) {
                System.err.println("WARNING: This should never happen: " + e);
            }
        }
    }

    synchronized void spawnPlayThread() {
        this.setThreadShouldStop(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Thread.currentThread().isInterrupted() && !SimpleController.this.getThreadShouldStop()) {
                        try {
                            SwingUtilities.invokeAndWait(SimpleController.this.blocker);
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.currentThread().interrupt();
                            }
                            catch (SecurityException ex) {}
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("This should never happen: " + e);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    SimpleController.this.simulation.state.nameThread();
                    boolean result = true;
                    while (!SimpleController.this.getThreadShouldStop()) {
                        result = SimpleController.this.simulation.step();
                        if (!Thread.currentThread().isInterrupted() && !SimpleController.this.getThreadShouldStop()) {
                            try {
                                SwingUtilities.invokeAndWait(SimpleController.this.blocker);
                            }
                            catch (InterruptedException e) {
                                try {
                                    Thread.currentThread().interrupt();
                                }
                                catch (SecurityException securityException) {}
                            }
                            catch (InvocationTargetException e) {
                                System.err.println("This should never happen" + e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (result && !SimpleController.this.getThreadShouldStop()) {
                            if (result) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        SimpleController.this.pressStop();
                                    }
                                    catch (Exception e) {
                                        System.err.println("This should never happen: " + e);
                                    }
                                }
                            });
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.playThread = new Thread(run);
        this.playThread.start();
    }

    @Override
    public synchronized boolean registerFrame(JFrame frame) {
        this.frameList.add(frame);
        return true;
    }

    @Override
    public synchronized boolean unregisterFrame(JFrame frame) {
        this.frameList.removeElement(frame);
        return true;
    }

    @Override
    public synchronized boolean unregisterAllFrames() {
        this.frameList.removeAllElements();
        return true;
    }

    @Override
    public synchronized void doChangeCode(Runnable r) {
        if (this.playThread != null) {
            this.killPlayThread();
            r.run();
            this.spawnPlayThread();
        } else {
            r.run();
        }
    }

    @Override
    public void refresh() {
        Enumeration e = this.frameList.elements();
        while (e.hasMoreElements()) {
            ((JFrame)e.nextElement()).getContentPane().repaint();
        }
        for (Inspector c : this.allInspectors.keySet()) {
            if (c == null || !c.isVolatile()) continue;
            c.updateInspector();
            c.repaint();
        }
    }

    @Override
    public void setInspectors(final Bag inspectors, Bag names) {
        if (!this.displayInspectors) {
            return;
        }
        this.removeAllInspectors(false);
        if (inspectors.numObjs != names.numObjs) {
            throw new RuntimeException("Number of inspectors and names do not match");
        }
        for (int x = 0; x < inspectors.numObjs; ++x) {
            if (inspectors.objs[x] == null) continue;
            final int xx = x;
            Steppable stepper = new Steppable(){

                @Override
                public void step(final SimState state) {
                    SwingUtilities.invokeLater(new Runnable(){
                        Inspector inspector;
                        {
                            this.inspector = (Inspector)inspectors.objs[xx];
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Schedule schedule = state.schedule;
                            synchronized (schedule) {
                                if (this.inspector.isVolatile()) {
                                    this.inspector.updateInspector();
                                    this.inspector.repaint();
                                }
                            }
                        }
                    });
                }
            };
            Stoppable stopper = null;
            try {
                stopper = ((Inspector)inspectors.objs[x]).reviseStopper(this.simulation.scheduleRepeatingImmediatelyAfter(stepper));
                this.inspectorStoppables.addElement(stopper);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            this.registerInspector((Inspector)inspectors.objs[x], stopper);
            JFrame frame = ((Inspector)inspectors.objs[x]).createFrame(stopper);
            frame.setVisible(true);
        }
    }

    @Override
    public void registerInspector(Inspector inspector, Stoppable stopper) {
        if (!this.displayInspectors) {
            return;
        }
        this.allInspectors.put(inspector, new WeakReference<Stoppable>(stopper));
    }

    public void stopAllInspectors(boolean killDraggedOutWindowsToo) {
        Stoppable stopper;
        for (Inspector insp : this.allInspectors.keySet()) {
            insp.updateInspector();
            insp.repaint();
        }
        for (int x = 0; x < this.inspectorStoppables.size(); ++x) {
            stopper = (Stoppable)this.inspectorStoppables.elementAt(x);
            if (stopper == null) continue;
            stopper.stop();
        }
        if (killDraggedOutWindowsToo) {
            for (Inspector insp : this.allInspectors.keySet()) {
                stopper = (Stoppable)this.allInspectors.get(insp);
                if (stopper == null) continue;
                stopper.stop();
            }
        }
    }

    public void removeAllInspectors(boolean killDraggedOutWindowsToo) {
        this.stopAllInspectors(killDraggedOutWindowsToo);
        if (killDraggedOutWindowsToo) {
            Iterator i = this.allInspectors.keySet().iterator();
            while (i.hasNext()) {
                Component inspector;
                for (inspector = (Component)i.next(); inspector != null && !(inspector instanceof JFrame); inspector = inspector.getParent()) {
                }
                if (inspector == null) continue;
                ((JFrame)inspector).dispose();
            }
            this.allInspectors = new WeakHashMap();
        }
    }

    public boolean doNew() {
        return Console.doNew(null, false);
    }

    @Override
    public ArrayList getAllInspectors() {
        ArrayList<Inspector> list = new ArrayList<Inspector>();
        Iterator i = this.allInspectors.keySet().iterator();
        while (i.hasNext()) {
            list.add((Inspector)i.next());
        }
        return list;
    }

    @Override
    public synchronized ArrayList getAllFrames() {
        return new ArrayList(this.frameList);
    }

    static {
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, (Object[])null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.setProperty("apple.awt.showGrowBox", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

