/*
 * Decompiled with CFR 0.152.
 */
package sim.display3d;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import sim.display.Console;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.Prefs;
import sim.display.SimApplet;
import sim.display3d.CapturingCanvas3D;
import sim.display3d.SelectionBehavior;
import sim.display3d.ToolTipBehavior;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.simple.AxesPortrayal3D;
import sim.util.Bag;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.NumberTextField;
import sim.util.gui.Utilities;
import sim.util.media.PNGEncoder;

public class Display3D
extends JPanel
implements Steppable {
    public String DEFAULT_PREFERENCES_KEY;
    String preferencesKey;
    ArrayList portrayals;
    Stoppable stopper;
    GUIState simulation;
    public Box header;
    public JButton movieButton;
    public JButton snapshotButton;
    public JButton optionButton;
    public JPopupMenu refreshPopup;
    public JToggleButton refreshbutton;
    public NumberTextField scaleField;
    public NumberTextField skipField;
    public JComboBox skipBox;
    public JFrame skipFrame;
    public CapturingCanvas3D canvas;
    public SimpleUniverse universe;
    public BranchGroup root;
    public BranchGroup viewRoot;
    Switch portrayalSwitch;
    BitSet portrayalSwitchMask;
    Switch auxillarySwitch;
    BitSet auxillarySwitchMask;
    static final int NUM_AUXILLARY_ELEMENTS = 2;
    static final int AXES_AUX_INDEX = 0;
    static final int BACKGROUND_AUX_INDEX = 1;
    Switch lightSwitch;
    BitSet lightSwitchMask;
    static final int NUM_LIGHT_ELEMENTS = 2;
    static final int SPOTLIGHT_INDEX = 0;
    static final int AMBIENT_LIGHT_INDEX = 1;
    MovieMaker movieMaker;
    public JPopupMenu popup;
    public JToggleButton layersbutton;
    int subgraphCount;
    boolean dirty;
    Appearance backdropAppearance;
    Image backdropImage;
    Color backdropColor;
    static final float[] bogusPosition;
    PointArray bogusMover;
    public TransformGroup globalModelTransformGroup;
    ToolTipBehavior toolTipBehavior;
    boolean usingToolTips;
    static final double DEFAULT_FIELD_OF_VIEW = 0.7853981633974483;
    double scale;
    Object scaleLock;
    RotationInterpolator autoSpin;
    RotationInterpolator autoSpinBackground;
    public TransformGroup autoSpinTransformGroup;
    TransformGroup autoSpinBackgroundTransformGroup;
    OrbitBehavior mOrbitBehavior;
    SelectionBehavior mSelectBehavior;
    boolean selectionAll;
    boolean inspectionAll;
    protected int updateRule;
    protected long stepInterval;
    protected double timeInterval;
    protected long wallInterval;
    long lastStep;
    double lastTime;
    long lastWall;
    JCheckBox orbitRotateXCheckBox;
    JCheckBox orbitRotateYCheckBox;
    JCheckBox orbitTranslateXCheckBox;
    JCheckBox orbitTranslateYCheckBox;
    JCheckBox orbitZoomCheckBox;
    JCheckBox selectBehCheckBox;
    JRadioButton polyPoint;
    JRadioButton polyLine;
    JRadioButton polyFill;
    JRadioButton polyCullNone;
    JRadioButton polyCullFront;
    JRadioButton polyCullBack;
    JCheckBox showAxesCheckBox;
    JCheckBox showBackgroundCheckBox;
    JCheckBox tooltips;
    JCheckBox showSpotlightCheckBox;
    JCheckBox showAmbientLightCheckBox;
    NumberTextField rotAxis_X;
    NumberTextField rotAxis_Y;
    NumberTextField rotAxis_Z;
    NumberTextField spinDuration;
    int rasterizationMode;
    int cullingMode;
    ArrayList selectedWrappers;
    JButton systemPreferences;
    JButton appPreferences;
    public OptionPane3D optionPane;

    public void setPreferencesKey(String s) {
        if (s.trim().endsWith("/")) {
            throw new RuntimeException("Key ends with '/', which is not allowed");
        }
        this.preferencesKey = s;
    }

    public String getPreferencesKey() {
        return this.preferencesKey;
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame(){
            boolean previouslyShown = false;

            @Override
            public void dispose() {
                Display3D.this.quit();
                super.dispose();
            }

            @Override
            public void addWindowListener(WindowListener l) {
                if (new String("class javax.media.j3d.EventCatcher").compareTo(l.getClass().toString()) == 0) {
                    l = new LocalWindowListener();
                }
                super.addWindowListener(l);
            }

            @Override
            public void setVisible(boolean val) {
                super.setVisible(val);
                if (Display3D.this.canvas != null && val && this.previouslyShown && Display2D.isMacOSX) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Display3D.this.remove((Component)((Object)Display3D.this.canvas));
                            Display3D.this.add((Component)((Object)Display3D.this.canvas), "Center");
                        }
                    });
                }
                if (val) {
                    this.previouslyShown = true;
                }
            }
        };
        frame.setResizable(true);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint(Display3D.this.header);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this, "Center");
        frame.getContentPane().setBackground(Color.yellow);
        frame.setTitle(GUIState.getName(this.simulation.getClass()) + " Display");
        frame.pack();
        return frame;
    }

    public Frame getFrame() {
        Container c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (this.stopper != null) {
                this.stopper.stop();
            }
            this.stopper = this.simulation.scheduleRepeatingImmediatelyAfter(this);
        }
        for (int x = 0; x < this.selectedWrappers.size(); ++x) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
    }

    public void attach(Portrayal3D portrayal, String name) {
        this.attach(portrayal, name, true);
    }

    public void attach(Portrayal3D portrayal, String name, boolean visible) {
        this.destroySceneGraph();
        Portrayal3DHolder p = new Portrayal3DHolder(portrayal, name, visible);
        this.portrayals.add(p);
        this.popup.add(p.menuItem);
        this.dirty = true;
        portrayal.setCurrentDisplay(this);
        this.createSceneGraph();
    }

    public void attach(final Inspector inspector, final String name) {
        JMenuItem consoleMenu = new JMenuItem("Show " + name);
        this.popup.add(consoleMenu);
        consoleMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bag inspectors = new Bag();
                inspectors.add(inspector);
                Bag names = new Bag();
                names.add(name);
                Display3D.this.simulation.controller.setInspectors(inspectors, names);
            }
        });
    }

    void createConsoleMenu() {
        if (this.simulation != null && this.simulation.controller != null && this.simulation.controller instanceof Console) {
            final Console c = (Console)this.simulation.controller;
            JMenuItem consoleMenu = new JMenuItem("Show Console");
            this.popup.add(consoleMenu);
            consoleMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    c.setVisible(true);
                }
            });
        }
        this.popup.addSeparator();
    }

    public ArrayList detatchAll() {
        ArrayList old = this.portrayals;
        this.popup.removeAll();
        this.createConsoleMenu();
        this.portrayals = new ArrayList();
        this.portrayalSwitchMask = null;
        this.subgraphCount = 0;
        this.dirty = true;
        return old;
    }

    public GUIState getSimulation() {
        return this.simulation;
    }

    public Display3D(double width, double height, GUIState simulation, long interval) {
        this(width, height, simulation);
    }

    public Display3D(double width, double height, GUIState simulation) {
        this.preferencesKey = this.DEFAULT_PREFERENCES_KEY = "Display3D";
        this.portrayals = new ArrayList();
        this.canvas = null;
        this.universe = null;
        this.root = null;
        this.viewRoot = null;
        this.portrayalSwitch = null;
        this.portrayalSwitchMask = null;
        this.auxillarySwitch = null;
        this.auxillarySwitchMask = new BitSet(2);
        this.lightSwitch = null;
        this.lightSwitchMask = new BitSet(2);
        this.movieMaker = null;
        this.subgraphCount = 0;
        this.dirty = false;
        this.backdropAppearance = null;
        this.backdropImage = null;
        this.backdropColor = null;
        this.scaleLock = new Object();
        this.autoSpin = null;
        this.autoSpinBackground = null;
        this.autoSpinTransformGroup = new TransformGroup();
        this.autoSpinBackgroundTransformGroup = new TransformGroup();
        this.mOrbitBehavior = null;
        this.mSelectBehavior = null;
        this.selectionAll = true;
        this.inspectionAll = true;
        this.updateRule = 3;
        this.stepInterval = 1L;
        this.timeInterval = 0.0;
        this.wallInterval = 0L;
        this.lastStep = -1L;
        this.lastTime = -1.0;
        this.lastWall = -1L;
        this.orbitRotateXCheckBox = new JCheckBox("Rotate Left/Right");
        this.orbitRotateYCheckBox = new JCheckBox("Up/Down");
        this.orbitTranslateXCheckBox = new JCheckBox("Translate Left/Right");
        this.orbitTranslateYCheckBox = new JCheckBox("Up/Down");
        this.orbitZoomCheckBox = new JCheckBox("Move Towards/Away");
        this.selectBehCheckBox = new JCheckBox("Select");
        this.polyPoint = new JRadioButton("Vertices", false);
        this.polyLine = new JRadioButton("Edges", false);
        this.polyFill = new JRadioButton("Fill", true);
        this.polyCullNone = new JRadioButton("Both Sides", true);
        this.polyCullFront = new JRadioButton("Back Side Only", false);
        this.polyCullBack = new JRadioButton("Front Side Only", false);
        this.showAxesCheckBox = new JCheckBox("Axes");
        this.showBackgroundCheckBox = new JCheckBox("Backdrop");
        this.tooltips = new JCheckBox("ToolTips");
        this.showSpotlightCheckBox = new JCheckBox("Spotlight");
        this.showAmbientLightCheckBox = new JCheckBox("Ambient Light");
        this.rotAxis_X = new NumberTextField(null, 0.0, false){

            @Override
            public double newValue(double newValue) {
                Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(newValue, Display3D.this.rotAxis_Y.getValue(), Display3D.this.rotAxis_Z.getValue()));
                Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(newValue, Display3D.this.rotAxis_Y.getValue(), Display3D.this.rotAxis_Z.getValue()));
                if (Display3D.this.spinDuration.getValue() == 0.0 || newValue == 0.0 && Display3D.this.rotAxis_Y.getValue() == 0.0 && Display3D.this.rotAxis_Z.getValue() == 0.0) {
                    Display3D.this.setSpinningEnabled(false);
                } else {
                    Display3D.this.setSpinningEnabled(true);
                }
                return newValue;
            }
        };
        this.rotAxis_Y = new NumberTextField(null, 0.0, false){

            @Override
            public double newValue(double newValue) {
                Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), newValue, Display3D.this.rotAxis_Z.getValue()));
                Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), newValue, Display3D.this.rotAxis_Z.getValue()));
                if (Display3D.this.spinDuration.getValue() == 0.0 || Display3D.this.rotAxis_X.getValue() == 0.0 && newValue == 0.0 && Display3D.this.rotAxis_Z.getValue() == 0.0) {
                    Display3D.this.setSpinningEnabled(false);
                } else {
                    Display3D.this.setSpinningEnabled(true);
                }
                return newValue;
            }
        };
        this.rotAxis_Z = new NumberTextField(null, 0.0, false){

            @Override
            public double newValue(double newValue) {
                Display3D.this.autoSpin.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), Display3D.this.rotAxis_Y.getValue(), newValue));
                Display3D.this.autoSpinBackground.setTransformAxis(Display3D.this.getTransformForAxis(Display3D.this.rotAxis_X.getValue(), Display3D.this.rotAxis_Y.getValue(), newValue));
                if (Display3D.this.spinDuration.getValue() == 0.0 || Display3D.this.rotAxis_X.getValue() == 0.0 && Display3D.this.rotAxis_Y.getValue() == 0.0 && newValue == 0.0) {
                    Display3D.this.setSpinningEnabled(false);
                } else {
                    Display3D.this.setSpinningEnabled(true);
                }
                return newValue;
            }
        };
        this.spinDuration = new NumberTextField(null, 0.0, 1.0, 0.02){

            @Override
            public double newValue(double newValue) {
                long mSecsPerRot = newValue == 0.0 ? 1L : (long)(1000.0 / newValue);
                Display3D.this.autoSpin.getAlpha().setIncreasingAlphaDuration(mSecsPerRot);
                Display3D.this.autoSpinBackground.getAlpha().setIncreasingAlphaDuration(mSecsPerRot);
                if (newValue == 0.0 || Display3D.this.rotAxis_X.getValue() == 0.0 && Display3D.this.rotAxis_Y.getValue() == 0.0 && Display3D.this.rotAxis_Z.getValue() == 0.0) {
                    Display3D.this.setSpinningEnabled(false);
                } else {
                    Display3D.this.setSpinningEnabled(true);
                }
                return newValue;
            }
        };
        this.rasterizationMode = 2;
        this.cullingMode = 0;
        this.selectedWrappers = new ArrayList();
        this.systemPreferences = new JButton("MASON");
        this.appPreferences = new JButton("Simulation");
        this.optionPane = new OptionPane3D("3D Options");
        this.simulation = simulation;
        this.reset();
        final Color headerBackground = this.getBackground();
        this.header = new Box(0){

            @Override
            public synchronized void paintComponent(Graphics g) {
                g.setColor(headerBackground);
                g.fillRect(0, 0, Display3D.this.header.getWidth(), Display3D.this.header.getHeight());
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 0;
                return d;
            }
        };
        this.setBackground(Color.black);
        this.layersbutton = new JToggleButton(Display2D.LAYERS_ICON);
        this.layersbutton.setPressedIcon(Display2D.LAYERS_ICON_P);
        this.layersbutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layersbutton.setBorderPainted(false);
        this.layersbutton.setContentAreaFilled(false);
        this.layersbutton.setToolTipText("Show and hide different layers");
        this.header.add(this.layersbutton);
        this.popup = new JPopupMenu();
        this.popup.setLightWeightPopupEnabled(false);
        this.layersbutton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Display3D.this.popup.show(e.getComponent(), Display3D.this.layersbutton.getLocation().x, Display3D.this.layersbutton.getSize().height);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Display3D.this.layersbutton.setSelected(false);
            }
        });
        this.refreshbutton = new JToggleButton(Display2D.REFRESH_ICON);
        this.refreshbutton.setPressedIcon(Display2D.REFRESH_ICON_P);
        this.refreshbutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.refreshbutton.setBorderPainted(false);
        this.refreshbutton.setContentAreaFilled(false);
        this.refreshbutton.setToolTipText("Change How and When the Display Redraws Itself");
        this.header.add(this.refreshbutton);
        this.refreshPopup = new JPopupMenu();
        this.refreshPopup.setLightWeightPopupEnabled(false);
        this.refreshbutton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Display3D.this.rebuildRefreshPopup();
                Display3D.this.refreshPopup.show(e.getComponent(), 0, Display3D.this.refreshbutton.getSize().height);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Display3D.this.refreshbutton.setSelected(false);
                Display3D.this.rebuildRefreshPopup();
            }
        });
        this.movieButton = new JButton(Display2D.MOVIE_OFF_ICON);
        this.movieButton.setPressedIcon(Display2D.MOVIE_OFF_ICON_P);
        this.movieButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.movieButton.setBorderPainted(false);
        this.movieButton.setContentAreaFilled(false);
        this.movieButton.setToolTipText("Create a Quicktime movie");
        this.movieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Display3D.this.movieMaker == null) {
                    Display3D.this.startMovie();
                } else {
                    Display3D.this.stopMovie();
                }
            }
        });
        this.header.add(this.movieButton);
        this.snapshotButton = new JButton(Display2D.CAMERA_ICON);
        this.snapshotButton.setPressedIcon(Display2D.CAMERA_ICON_P);
        this.snapshotButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.snapshotButton.setBorderPainted(false);
        this.snapshotButton.setContentAreaFilled(false);
        this.snapshotButton.setToolTipText("Create a snapshot (as a PNG file)");
        this.snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Display3D.this.takeSnapshot();
                    }
                });
            }
        });
        this.header.add(this.snapshotButton);
        this.optionButton = new JButton(Display2D.OPTIONS_ICON);
        this.optionButton.setPressedIcon(Display2D.OPTIONS_ICON_P);
        this.optionButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.optionButton.setBorderPainted(false);
        this.optionButton.setContentAreaFilled(false);
        this.optionButton.setToolTipText("Options");
        this.optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.optionPane.setVisible(true);
            }
        });
        this.header.add(this.optionButton);
        this.scaleField = new NumberTextField("  Scale: ", 1.0, true){

            @Override
            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                Display3D.this.setScale(newValue);
                return newValue;
            }
        };
        this.scaleField.setToolTipText("Magnifies the scene.  Not the same as zooming (see the options panel)");
        this.scaleField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.header.add(this.scaleField);
        this.setPreferredSize(new Dimension((int)width, (int)height));
        this.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.auxillarySwitchMask.clear(0);
        this.auxillarySwitchMask.clear(1);
        this.showBackgroundCheckBox.setSelected(true);
        this.createSceneGraph();
        this.skipFrame = new JFrame();
        this.rebuildSkipFrame();
        this.skipFrame.pack();
        this.createConsoleMenu();
    }

    public void clearBackdrop() {
        this.backdropAppearance = null;
        this.backdropImage = null;
        this.backdropColor = null;
        this.setShowsBackdrop(false);
    }

    public void setBackdrop(Appearance appearance) {
        this.clearBackdrop();
        this.backdropAppearance = appearance;
        this.setShowsBackdrop(true);
    }

    public void setBackdrop(Color color) {
        this.clearBackdrop();
        this.backdropColor = color;
        this.setShowsBackdrop(true);
    }

    public void setBackdrop(Image image, boolean spherical) {
        this.clearBackdrop();
        if (spherical && image != null) {
            Appearance appearance = new Appearance();
            appearance.setTexture(new TextureLoader(image, null).getTexture());
            this.setBackdrop(appearance);
        } else {
            this.backdropImage = image;
        }
        this.setShowsBackdrop(true);
    }

    void rebuildAuxillarySwitch() {
        this.auxillarySwitch = new Switch(-3);
        this.auxillarySwitch.setCapability(18);
        this.auxillarySwitch.setCapability(12);
        this.auxillarySwitch.setCapability(14);
        this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
        AxesPortrayal3D x = new AxesPortrayal3D(0.01f, true);
        x.setCurrentDisplay(this);
        this.auxillarySwitch.insertChild((Node)x.getModel(null, null), 0);
        if (this.backdropAppearance != null || this.backdropColor != null || this.backdropImage != null) {
            Background background = new Background();
            background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE));
            if (this.backdropAppearance != null) {
                BranchGroup backgroundBG = new BranchGroup();
                Sphere sphere = new Sphere(1.0f, 7, 45, this.backdropAppearance);
                Transform3D strans = new Transform3D();
                strans.rotX(-1.5707963267948966);
                TransformGroup tg = new TransformGroup(strans);
                tg.addChild((Node)sphere);
                this.autoSpinBackgroundTransformGroup.addChild((Node)tg);
                backgroundBG.addChild((Node)this.autoSpinBackgroundTransformGroup);
                background.setGeometry(backgroundBG);
            } else if (this.backdropColor != null) {
                background.setColor(new Color3f(this.backdropColor));
            } else {
                BufferedImage img = this.getGraphicsConfiguration().createCompatibleImage(this.backdropImage.getWidth(null), this.backdropImage.getHeight(null));
                Graphics g = img.getGraphics();
                g.drawImage(this.backdropImage, 0, 0, null);
                background.setImage(new ImageComponent2D(1, img));
                background.setImageScaleMode(2);
                img.flush();
            }
            this.auxillarySwitch.addChild((Node)background);
        } else {
            this.auxillarySwitch.addChild((Node)new Group());
        }
        this.bogusMover = new PointArray(1, 1);
        this.bogusMover.setCapability(1);
        this.moveBogusMover();
        this.auxillarySwitch.addChild((Node)new Shape3D((Geometry)this.bogusMover));
    }

    void moveBogusMover() {
        this.bogusMover.setCoordinate(0, bogusPosition);
    }

    void toggleAxes() {
        if (this.auxillarySwitch != null) {
            this.auxillarySwitchMask.set(0, this.showAxesCheckBox.isSelected());
            this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
        }
    }

    public void setShowsAxes(boolean value) {
        this.showAxesCheckBox.setSelected(value);
        this.toggleAxes();
    }

    void toggleBackdrop() {
        if (this.auxillarySwitch != null) {
            this.auxillarySwitchMask.set(1, this.showBackgroundCheckBox.isSelected());
            this.auxillarySwitch.setChildMask(this.auxillarySwitchMask);
        }
    }

    public void setShowsBackdrop(boolean value) {
        this.showBackgroundCheckBox.setSelected(value);
        this.toggleBackdrop();
    }

    void toggleSpotlight() {
        if (this.lightSwitch != null) {
            this.lightSwitchMask.set(0, this.showSpotlightCheckBox.isSelected());
            this.lightSwitch.setChildMask(this.lightSwitchMask);
        }
    }

    public void setShowsSpotlight(boolean value) {
        this.showSpotlightCheckBox.setSelected(value);
        this.toggleSpotlight();
    }

    void toggleAmbientLight() {
        if (this.lightSwitch != null) {
            this.lightSwitchMask.set(1, this.showAmbientLightCheckBox.isSelected());
            this.lightSwitch.setChildMask(this.lightSwitchMask);
        }
    }

    public void setShowsAmbientLight(boolean value) {
        this.showAmbientLightCheckBox.setSelected(value);
        this.toggleAmbientLight();
    }

    void rebuildGlobalModelTransformGroup() {
        TransformGroup newGroup = new TransformGroup();
        newGroup.setCapability(17);
        newGroup.setCapability(18);
        if (this.globalModelTransformGroup != null) {
            Transform3D trans = new Transform3D();
            this.globalModelTransformGroup.getTransform(trans);
            newGroup.setTransform(trans);
        }
        this.globalModelTransformGroup = newGroup;
    }

    public Transform3D getTransform() {
        Transform3D trans = new Transform3D();
        this.globalModelTransformGroup.getTransform(trans);
        return trans;
    }

    public void setTransform(Transform3D transform) {
        if (transform != null) {
            this.globalModelTransformGroup.setTransform(new Transform3D(transform));
        } else {
            this.globalModelTransformGroup.setTransform(new Transform3D());
        }
    }

    public void transform(Transform3D transform) {
        Transform3D current = this.getTransform();
        current.mul(transform, current);
        this.setTransform(current);
    }

    public void resetTransform() {
        this.globalModelTransformGroup.setTransform(new Transform3D());
    }

    public void rotateX(double degrees) {
        Transform3D other = new Transform3D();
        other.rotX(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateY(double degrees) {
        Transform3D other = new Transform3D();
        other.rotY(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateZ(double degrees) {
        Transform3D other = new Transform3D();
        other.rotZ(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void translate(double dx, double dy, double dz) {
        Transform3D other = new Transform3D();
        other.setTranslation(new Vector3d(dx, dy, dz));
        this.transform(other);
    }

    public void scale(double value) {
        Transform3D other = new Transform3D();
        other.setScale(value);
        this.transform(other);
    }

    public void scale(double sx, double sy, double sz) {
        Transform3D other = new Transform3D();
        other.setScale(new Vector3d(sx, sy, sz));
        this.transform(other);
    }

    public void destroySceneGraph() {
        this.mSelectBehavior.detach();
        this.root.detach();
        this.universe.getLocale().removeBranchGraph(this.root);
        this.canvas.stopRenderer();
    }

    public void createSceneGraph() {
        this.dirty = false;
        if (this.universe == null) {
            this.canvas = new CapturingCanvas3D(SimpleUniverse.getPreferredConfiguration());
            this.add((Component)((Object)this.canvas), "Center");
            this.universe = new SimpleUniverse((Canvas3D)this.canvas);
            this.universe.getViewingPlatform().setNominalViewingTransform();
            this.lightSwitch = new Switch(-3);
            this.lightSwitch.setCapability(18);
            this.lightSwitch.setCapability(12);
            this.lightSwitch.setCapability(14);
            this.lightSwitchMask.set(0);
            this.lightSwitchMask.clear(1);
            this.lightSwitch.setChildMask(this.lightSwitchMask);
            PointLight pl = new PointLight(new Color3f(1.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
            pl.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
            this.lightSwitch.addChild((Node)pl);
            AmbientLight al = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
            al.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
            this.lightSwitch.addChild((Node)al);
            this.viewRoot = new BranchGroup();
            this.viewRoot.addChild((Node)this.lightSwitch);
            this.universe.getViewingPlatform().getViewPlatformTransform().addChild((Node)this.viewRoot);
        } else {
            this.destroySceneGraph();
        }
        BranchGroup oldRoot = this.root;
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.root.setCapability(3);
        this.root.setCapability(17);
        this.autoSpinTransformGroup = new TransformGroup();
        this.autoSpinTransformGroup.setCapability(18);
        this.portrayalSwitch = new Switch(-3);
        this.portrayalSwitch.setCapability(18);
        this.portrayalSwitch.setCapability(12);
        this.portrayalSwitch.setCapability(14);
        this.autoSpinBackgroundTransformGroup = new TransformGroup();
        this.autoSpinBackgroundTransformGroup.setCapability(18);
        this.portrayalSwitchMask = new BitSet(this.subgraphCount);
        int count = 0;
        for (Portrayal3DHolder p3h : this.portrayals) {
            Portrayal3D p = p3h.portrayal;
            Object obj = p instanceof FieldPortrayal3D ? ((FieldPortrayal3D)p).getField() : null;
            p.setCurrentDisplay(this);
            this.portrayalSwitch.addChild((Node)p.getModel(obj, null));
            if (p3h.visible) {
                this.portrayalSwitchMask.set(count);
            } else {
                this.portrayalSwitchMask.clear(count);
            }
            ++count;
        }
        this.portrayalSwitch.setChildMask(this.portrayalSwitchMask);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY);
        this.mSelectBehavior = new SelectionBehavior(this.canvas, this.root, (Bounds)bounds, this.simulation);
        this.mSelectBehavior.setSelectsAll(this.selectionAll, this.inspectionAll);
        this.mSelectBehavior.setEnable(this.selectBehCheckBox.isSelected());
        this.toolTipBehavior = new ToolTipBehavior(this.canvas, this.root, (Bounds)bounds, this.simulation);
        this.toolTipBehavior.setEnable(true);
        this.toolTipBehavior.setCanShowToolTips(this.usingToolTips);
        if (this.autoSpin == null) {
            this.autoSpin = new RotationInterpolator(new Alpha(), this.autoSpinTransformGroup);
            this.autoSpin.getAlpha().setLoopCount(0);
            this.autoSpin.setSchedulingBounds((Bounds)bounds);
            this.autoSpinBackground = new RotationInterpolator(new Alpha(), this.autoSpinBackgroundTransformGroup);
            this.autoSpinBackground.getAlpha().setLoopCount(0);
            this.autoSpinBackground.setSchedulingBounds((Bounds)bounds);
            this.setSpinningEnabled(false);
        } else {
            oldRoot.removeChild((Node)this.autoSpin);
            oldRoot.removeChild((Node)this.autoSpinBackground);
        }
        this.rebuildGlobalModelTransformGroup();
        this.rebuildAuxillarySwitch();
        this.mOrbitBehavior = new OrbitBehavior((Canvas3D)this.canvas, 112);
        this.mOrbitBehavior.setRotateEnable(true);
        this.mOrbitBehavior.setRotXFactor(this.orbitRotateXCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setRotYFactor(this.orbitRotateYCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setTranslateEnable(true);
        this.mOrbitBehavior.setTransXFactor(this.orbitTranslateXCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setTransYFactor(this.orbitTranslateYCheckBox.isSelected() ? 1.0 : 0.0);
        this.mOrbitBehavior.setZoomEnable(this.orbitZoomCheckBox.isSelected());
        this.mOrbitBehavior.setSchedulingBounds((Bounds)bounds);
        this.universe.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this.mOrbitBehavior);
        this.globalModelTransformGroup.addChild((Node)this.portrayalSwitch);
        this.autoSpinTransformGroup.addChild((Node)this.globalModelTransformGroup);
        this.autoSpinTransformGroup.addChild((Node)this.auxillarySwitch);
        this.root.addChild((Node)this.autoSpin);
        this.root.addChild((Node)this.autoSpinBackground);
        this.autoSpin.setTarget(this.autoSpinTransformGroup);
        this.autoSpinBackground.setTarget(this.autoSpinBackgroundTransformGroup);
        this.root.addChild((Node)this.autoSpinTransformGroup);
        this.setCullingMode(this.cullingMode);
        this.setRasterizationMode(this.rasterizationMode);
        this.sceneGraphCreated();
        this.universe.addBranchGraph(this.root);
        this.canvas.startRenderer();
    }

    protected void sceneGraphCreated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double val) {
        Object object = this.scaleLock;
        synchronized (object) {
            this.scale = val < 1.0 ? 0.7853981633974483 + 2.356194490192345 * (1.0 - val) * (1.0 - val) : 0.7853981633974483 / val;
            this.canvas.getView().setFieldOfView(this.scale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        Object object = this.scaleLock;
        synchronized (object) {
            return this.scale;
        }
    }

    public SelectionBehavior getSelectionBehavior() {
        return this.mSelectBehavior;
    }

    public ToolTipBehavior getToolTipBehavior() {
        return this.toolTipBehavior;
    }

    public void setSelectsAll(boolean selection, boolean inspection) {
        this.selectionAll = selection;
        this.inspectionAll = inspection;
        this.mSelectBehavior.setSelectsAll(this.selectionAll, this.inspectionAll);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display3D.this.updateSceneGraph(false);
            }
        });
    }

    public boolean shouldUpdate() {
        boolean val = false;
        if (this.updateRule == 3) {
            val = true;
        } else if (this.updateRule == 0) {
            long step = this.simulation.state.schedule.getSteps();
            boolean bl = val = this.lastStep < 0L || this.stepInterval == 0L || step - this.lastStep >= this.stepInterval || this.lastStep % this.stepInterval >= step % this.stepInterval;
            if (val) {
                this.lastStep = step;
            }
        } else if (this.updateRule == 2) {
            long wall = System.currentTimeMillis();
            boolean bl = val = this.lastWall == 0L || this.wallInterval == 0L || wall - this.lastWall >= this.wallInterval || this.lastWall % this.wallInterval >= wall % this.wallInterval;
            if (val) {
                this.lastWall = wall;
            }
        } else if (this.updateRule == 1) {
            double time = this.simulation.state.schedule.getTime();
            boolean bl = val = this.lastTime == 0.0 || this.timeInterval == 0.0 || time - this.lastTime >= this.timeInterval || this.lastTime % this.timeInterval >= time % this.timeInterval;
            if (val) {
                this.lastTime = time;
            }
        }
        return val;
    }

    @Override
    public void step(SimState state) {
        if (this.shouldUpdate() && (this.canvas.isShowing() || this.movieMaker != null)) {
            this.updateSceneGraph(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSceneGraph(boolean waitForRenderer) {
        if (this.canvas == null) {
            return;
        }
        if (this.dirty && waitForRenderer) {
            this.createSceneGraph();
            return;
        }
        boolean changes = false;
        Iterator iter = this.portrayals.iterator();
        this.moveBogusMover();
        while (iter.hasNext()) {
            Portrayal3DHolder ph = (Portrayal3DHolder)iter.next();
            if (!this.portrayalSwitchMask.get(ph.subgraphIndex)) continue;
            ph.portrayal.setCurrentDisplay(this);
            ph.portrayal.getModel(ph.portrayal instanceof FieldPortrayal3D ? ((FieldPortrayal3D)ph.portrayal).getField() : null, (TransformGroup)this.portrayalSwitch.getChild(ph.subgraphIndex));
            changes = true;
        }
        if (!(waitForRenderer &= changes)) {
            return;
        }
        Object object = this.canvas;
        synchronized (object) {
            try {
                if (!Thread.currentThread().isInterrupted()) {
                    ((Object)((Object)this.canvas)).wait(0L);
                }
            }
            catch (InterruptedException ex) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException ex2) {
                    // empty catch block
                }
            }
        }
        object = this.simulation.state.schedule;
        synchronized (object) {
            if (this.movieMaker != null) {
                this.movieMaker.add(this.canvas.getLastImage());
            }
        }
    }

    public void takeSnapshot(File file) throws IOException {
        this.canvas.beginCapturing(false);
        BufferedImage image = this.canvas.getLastImage();
        PNGEncoder tmpEncoder = new PNGEncoder(image, false, 0, 9);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)stream).write(tmpEncoder.pngEncode());
        ((OutputStream)stream).close();
        image.flush();
    }

    public void takeSnapshot() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot save snapshots from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        this.canvas.beginCapturing(false);
        FileDialog fd = new FileDialog(this.getFrame(), "Save Snapshot as 24-bit PNG...", 1);
        fd.setFile("Untitled.png");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            try {
                File snapShotFile = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".png"));
                BufferedImage image = this.canvas.getLastImage();
                PNGEncoder tmpEncoder = new PNGEncoder(image, false, 0, 9);
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(snapShotFile));
                ((OutputStream)stream).write(tmpEncoder.pngEncode());
                ((OutputStream)stream).close();
                image.flush();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMovie() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        if (this.movieMaker != null) {
            return;
        }
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            this.movieMaker = new MovieMaker(this.getFrame());
            this.canvas.beginCapturing(false);
            BufferedImage typicalImage = this.canvas.getLastImage();
            if (!this.movieMaker.start(typicalImage)) {
                this.movieMaker = null;
            } else {
                this.canvas.beginCapturing(true);
                this.movieButton.setIcon(Display2D.MOVIE_ON_ICON);
                this.movieButton.setPressedIcon(Display2D.MOVIE_ON_ICON_P);
                this.simulation.scheduleAtEnd(new Steppable(){

                    @Override
                    public void step(SimState state) {
                        Display3D.this.stopMovie();
                    }
                });
            }
            typicalImage.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMovie() {
        Schedule schedule = this.simulation.state.schedule;
        synchronized (schedule) {
            if (this.movieMaker == null) {
                return;
            }
            this.canvas.stopCapturing();
            if (!this.movieMaker.stop()) {
                Object[] options = new Object[]{"Drat"};
                JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
            }
            this.movieMaker = null;
            if (this.movieButton != null) {
                this.movieButton.setIcon(Display2D.MOVIE_OFF_ICON);
                this.movieButton.setPressedIcon(Display2D.MOVIE_OFF_ICON_P);
            }
        }
    }

    public void quit() {
        this.stopMovie();
        this.universe.cleanup();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.quit();
    }

    void setSpinningEnabled(boolean value) {
        if (this.autoSpin != null) {
            if (value) {
                this.autoSpin.setEnable(true);
                this.autoSpin.getAlpha().setLoopCount(-1);
                this.autoSpinBackground.setEnable(true);
                this.autoSpinBackground.getAlpha().setLoopCount(-1);
            } else {
                this.autoSpin.setEnable(false);
                this.autoSpin.getAlpha().setLoopCount(0);
                this.autoSpinBackground.setEnable(false);
                this.autoSpinBackground.getAlpha().setLoopCount(0);
            }
        }
    }

    Transform3D getTransformForAxis(double dx, double dy, double dz) {
        Transform3D t = new Transform3D();
        Transform3D t1 = new Transform3D();
        t.rotX(Math.atan2(dz, dy));
        t1.rotZ(-Math.atan2(dx, Math.sqrt(dy * dy + dx * dz)));
        t.mul(t1);
        return t;
    }

    public void setRasterizationMode(int mode) {
        this.rasterizationMode = mode;
        this.polyFill.setSelected(mode == 2);
        this.polyLine.setSelected(mode == 1);
        this.polyPoint.setSelected(mode == 0);
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            PolygonAttributes pa = ((Portrayal3DHolder)iter.next()).portrayal.polygonAttributes();
            try {
                if (pa == null) continue;
                pa.setPolygonMode(mode);
            }
            catch (CapabilityNotSetException e) {}
        }
    }

    public void setCullingMode(int mode) {
        this.cullingMode = mode;
        this.polyCullNone.setSelected(mode == 0);
        this.polyCullBack.setSelected(mode == 1);
        this.polyCullFront.setSelected(mode == 2);
        Iterator iter = this.portrayals.iterator();
        while (iter.hasNext()) {
            PolygonAttributes pa = ((Portrayal3DHolder)iter.next()).portrayal.polygonAttributes();
            try {
                if (pa == null) continue;
                pa.setCullFace(mode);
            }
            catch (CapabilityNotSetException e) {}
        }
    }

    public LocationWrapper[] getSelectedWrappers() {
        return this.selectedWrappers.toArray(new LocationWrapper[this.selectedWrappers.size()]);
    }

    public void performSelection(LocationWrapper wrapper) {
        Bag b = new Bag();
        b.add(wrapper);
        this.performSelection(b);
    }

    public void clearSelections() {
        for (int x = 0; x < this.selectedWrappers.size(); ++x) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
        }
        this.selectedWrappers.clear();
    }

    public void performSelection(Bag locationWrappers) {
        this.clearSelections();
        if (locationWrappers == null) {
            return;
        }
        for (int x = 0; x < locationWrappers.size(); ++x) {
            LocationWrapper wrapper = (LocationWrapper)locationWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, true);
            this.selectedWrappers.add(wrapper);
        }
        this.updateSceneGraph(false);
    }

    protected void rebuildSkipFrame() {
        this.skipFrame.getContentPane().removeAll();
        this.skipFrame.getContentPane().invalidate();
        this.skipFrame.getContentPane().repaint();
        this.skipFrame.getContentPane().setLayout(new BorderLayout());
        JPanel skipHeader = new JPanel();
        skipHeader.setLayout(new BorderLayout());
        this.skipFrame.add((Component)skipHeader, "Center");
        this.skipBox = new JComboBox<Object>(Display2D.REDRAW_OPTIONS);
        this.skipBox.setSelectedIndex(this.updateRule);
        ActionListener skipListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = Display3D.this.skipBox.getSelectedIndex();
                if (Display3D.this.updateRule == 3 || Display3D.this.updateRule == 4) {
                    Display3D.this.skipField.getField().setText("");
                    Display3D.this.skipField.setEnabled(false);
                } else if (Display3D.this.updateRule == 0) {
                    Display3D.this.skipField.setValue(Display3D.this.stepInterval);
                    Display3D.this.skipField.setEnabled(true);
                } else if (Display3D.this.updateRule == 1) {
                    Display3D.this.skipField.setValue(Display3D.this.timeInterval);
                    Display3D.this.skipField.setEnabled(true);
                } else {
                    Display3D.this.skipField.setValue(Display3D.this.wallInterval / 1000L);
                    Display3D.this.skipField.setEnabled(true);
                }
            }
        };
        this.skipBox.addActionListener(skipListener);
        this.skipBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setHorizontalAlignment(4);
                return label;
            }
        });
        skipHeader.add((Component)this.skipBox, "West");
        this.skipField = new NumberTextField(null, 1.0, false){

            @Override
            public double newValue(double newValue) {
                double val;
                if (Display3D.this.updateRule == 3 || Display3D.this.updateRule == 4) {
                    val = 0.0;
                } else if (Display3D.this.updateRule == 0) {
                    val = (long)newValue;
                    if (val < 1.0) {
                        val = Display3D.this.stepInterval;
                    }
                    Display3D.this.stepInterval = (long)val;
                } else if (Display3D.this.updateRule == 2) {
                    val = newValue;
                    if (val < 0.0) {
                        val = Display3D.this.wallInterval / 1000L;
                    }
                    Display3D.this.wallInterval = (long)(newValue * 1000.0);
                } else {
                    val = newValue;
                    if (newValue < 0.0) {
                        newValue = Display3D.this.timeInterval;
                    }
                    Display3D.this.timeInterval = val;
                }
                Display3D.this.reset();
                return val;
            }
        };
        this.skipField.setToolTipText("Specify the interval between screen updates");
        this.skipField.getField().setColumns(10);
        skipHeader.add((Component)this.skipField, "Center");
        skipHeader.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        skipListener.actionPerformed(null);
    }

    protected void rebuildRefreshPopup() {
        this.refreshPopup.removeAll();
        String s = "";
        switch (this.updateRule) {
            case 0: {
                s = this.stepInterval == 1L ? "Currently redrawing each model iteration" : "Currently redrawing each " + this.stepInterval + " model iterations";
                break;
            }
            case 1: {
                s = this.timeInterval == 1.0 ? "Currently redrawing each unit of model time" : "Currently redrawing every " + this.timeInterval + " units of model time";
                break;
            }
            case 2: {
                s = this.wallInterval == 1000L ? "Currently redrawing each second of real time" : "Currently redrawing every " + (double)this.wallInterval / 1000.0 + " seconds of real time";
                break;
            }
            case 3: {
                s = "Currently redrawing every model iteration";
                break;
            }
            case 4: {
                s = "Currently never redrawing except when the window is redrawn";
            }
        }
        JMenuItem m = new JMenuItem(s);
        m.setEnabled(false);
        this.refreshPopup.add(m);
        this.refreshPopup.addSeparator();
        m = new JMenuItem("Always Redraw");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 3;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Never Redraw");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 4;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 2 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 0;
                Display3D.this.stepInterval = 2L;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 4 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 0;
                Display3D.this.stepInterval = 4L;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 8 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 0;
                Display3D.this.stepInterval = 8L;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 16 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 0;
                Display3D.this.stepInterval = 16L;
                Display3D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 32 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.updateRule = 0;
                Display3D.this.stepInterval = 16L;
                Display3D.this.rebuildSkipFrame();
            }
        });
        this.refreshPopup.addSeparator();
        m = new JMenuItem("More Options...");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3D.this.skipFrame.setTitle(Display3D.this.getFrame().getTitle() + " Options");
                Display3D.this.skipFrame.setVisible(true);
            }
        });
        this.refreshPopup.revalidate();
    }

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, (Object[])null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bogusPosition = new float[]{0.0f, 0.0f, 0.0f};
    }

    public class OptionPane3D
    extends JFrame {
        static final String ROTATE_LEFT_RIGHT_KEY = "Rotate Left Right";
        static final String TRANSLATE_LEFT_RIGHT_KEY = "Translate Left Right";
        static final String MOVE_TOWARDS_AWAY_KEY = "Move Towards Away";
        static final String ROTATE_UP_DOWN_KEY = "Rotate Up Down";
        static final String TRANSLATE_UP_DOWN_KEY = "Translate Up Down";
        static final String SELECT_KEY = "Select";
        static final String AUTO_ROTATE_X_KEY = "Auto Rotate X";
        static final String AUTO_ROTATE_Y_KEY = "Auto Rotate Y";
        static final String AUTO_ROTATE_Z_KEY = "Auto Rotate Z";
        static final String AUTO_ROTATE_RATE_KEY = "Auto Rotate Rate";
        static final String AXES_KEY = "Axes";
        static final String TOOLTIPS_KEY = "Tooltips";
        static final String SPOTLIGHT_KEY = "Spotlight";
        static final String AMBIENT_LIGHT_KEY = "Ambient Light";
        static final String BACKDROP_KEY = "Backdrop";
        static final String DRAW_POLYGONS_KEY = "Draw Polygons";
        static final String DRAW_FACES_KEY = "Draw Faces";

        OptionPane3D(String label) {
            super(label);
            Display3D.this.orbitRotateXCheckBox.setToolTipText("Rotates the scene left or right. Drag the left mouse button.");
            Display3D.this.orbitRotateYCheckBox.setToolTipText("Rotates the scene up or down. Drag the left mouse button.");
            Display3D.this.orbitTranslateXCheckBox.setToolTipText("Move the scene left or right.  Drag the middle mouse button.");
            Display3D.this.orbitTranslateYCheckBox.setToolTipText("Move the scene up or down.  Drag the middle mouse button.");
            Display3D.this.orbitZoomCheckBox.setToolTipText("Moves the eye towards/away from scene.  Not the same as scaling.  Drag the right mouse button.");
            Display3D.this.selectBehCheckBox.setToolTipText("Selects objects.  Double-click the left mouse button.");
            Box outerBehaviorsPanel = new Box(0);
            outerBehaviorsPanel.setBorder(new TitledBorder("Mouse Actions"));
            Box leftBehaviors = new Box(1);
            leftBehaviors.add(Display3D.this.orbitRotateXCheckBox);
            Display3D.this.orbitRotateXCheckBox.setSelected(true);
            leftBehaviors.add(Display3D.this.orbitTranslateXCheckBox);
            Display3D.this.orbitTranslateXCheckBox.setSelected(true);
            leftBehaviors.add(Display3D.this.orbitZoomCheckBox);
            Display3D.this.orbitZoomCheckBox.setSelected(true);
            leftBehaviors.add(Box.createGlue());
            Box rightBehaviors = new Box(1);
            rightBehaviors.add(Display3D.this.orbitRotateYCheckBox);
            Display3D.this.orbitRotateYCheckBox.setSelected(true);
            rightBehaviors.add(Display3D.this.orbitTranslateYCheckBox);
            Display3D.this.orbitTranslateYCheckBox.setSelected(true);
            rightBehaviors.add(Display3D.this.selectBehCheckBox);
            Display3D.this.selectBehCheckBox.setSelected(true);
            rightBehaviors.add(Box.createGlue());
            outerBehaviorsPanel.add(leftBehaviors);
            outerBehaviorsPanel.add(rightBehaviors);
            outerBehaviorsPanel.add(Box.createGlue());
            Box resetBox = new Box(0);
            resetBox.setBorder(new TitledBorder("Viewpoint"));
            JButton resetButton = new JButton("Reset Viewpoint");
            resetButton.setToolTipText("Resets display to original rotation, translation, and zoom.");
            resetBox.add(resetButton);
            resetBox.add(Box.createGlue());
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.canvas.stopRenderer();
                    Display3D.this.scaleField.setValue(1.0);
                    Display3D.this.setScale(1.0);
                    Display3D.this.universe.getViewingPlatform().setNominalViewingTransform();
                    Display3D.this.autoSpinTransformGroup.setTransform(new Transform3D());
                    Display3D.this.autoSpinBackgroundTransformGroup.setTransform(new Transform3D());
                    Display3D.this.canvas.startRenderer();
                }
            });
            Display3D.this.orbitRotateXCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mOrbitBehavior != null) {
                        Display3D.this.mOrbitBehavior.setRotXFactor(Display3D.this.orbitRotateXCheckBox.isSelected() ? 1.0 : 0.0);
                    }
                }
            });
            Display3D.this.orbitRotateYCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mOrbitBehavior != null) {
                        Display3D.this.mOrbitBehavior.setRotYFactor(Display3D.this.orbitRotateYCheckBox.isSelected() ? 1.0 : 0.0);
                    }
                }
            });
            Display3D.this.orbitTranslateXCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mOrbitBehavior != null) {
                        Display3D.this.mOrbitBehavior.setTransXFactor(Display3D.this.orbitTranslateXCheckBox.isSelected() ? 1.0 : 0.0);
                    }
                }
            });
            Display3D.this.orbitTranslateYCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mOrbitBehavior != null) {
                        Display3D.this.mOrbitBehavior.setTransYFactor(Display3D.this.orbitTranslateYCheckBox.isSelected() ? 1.0 : 0.0);
                    }
                }
            });
            Display3D.this.orbitZoomCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mOrbitBehavior != null) {
                        Display3D.this.mOrbitBehavior.setZoomEnable(Display3D.this.orbitZoomCheckBox.isSelected());
                    }
                }
            });
            Display3D.this.selectBehCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Display3D.this.mSelectBehavior != null) {
                        Display3D.this.mSelectBehavior.setEnable(Display3D.this.selectBehCheckBox.isSelected());
                    }
                }
            });
            LabelledList rotatePanel = new LabelledList("Auto-Rotate About <X,Y,Z> Axis");
            rotatePanel.addLabelled("X", Display3D.this.rotAxis_X);
            rotatePanel.addLabelled("Y", Display3D.this.rotAxis_Y);
            rotatePanel.addLabelled("Z", Display3D.this.rotAxis_Z);
            rotatePanel.addLabelled("Rotations/Sec", Display3D.this.spinDuration);
            Box polyPanel = new Box(0);
            polyPanel.setBorder(new TitledBorder("Polygon Attributes"));
            ButtonGroup polyLineGroup = new ButtonGroup();
            polyLineGroup.add(Display3D.this.polyPoint);
            polyLineGroup.add(Display3D.this.polyLine);
            polyLineGroup.add(Display3D.this.polyFill);
            ButtonGroup polyCullingGroup = new ButtonGroup();
            polyCullingGroup.add(Display3D.this.polyCullNone);
            polyCullingGroup.add(Display3D.this.polyCullFront);
            polyCullingGroup.add(Display3D.this.polyCullBack);
            Box polyLinebox = Box.createVerticalBox();
            polyLinebox.add(Box.createGlue());
            polyLinebox.add(new JLabel("Draw Polygons As..."));
            polyLinebox.add(Display3D.this.polyPoint);
            Display3D.this.polyPoint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setRasterizationMode(0);
                }
            });
            polyLinebox.add(Display3D.this.polyLine);
            Display3D.this.polyLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setRasterizationMode(1);
                }
            });
            polyLinebox.add(Display3D.this.polyFill);
            Display3D.this.polyFill.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setRasterizationMode(2);
                }
            });
            polyLinebox.add(Box.createGlue());
            polyLinebox.setBorder(new EmptyBorder(0, 0, 0, 20));
            polyPanel.add(polyLinebox);
            Box polyCullbox = Box.createVerticalBox();
            polyCullbox.add(Box.createGlue());
            polyCullbox.add(new JLabel("Draw Faces As..."));
            polyCullbox.add(Display3D.this.polyCullNone);
            Display3D.this.polyCullNone.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setCullingMode(0);
                }
            });
            polyCullbox.add(Display3D.this.polyCullBack);
            Display3D.this.polyCullBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setCullingMode(1);
                }
            });
            polyCullbox.add(Display3D.this.polyCullFront);
            Display3D.this.polyCullFront.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Display3D.this.setCullingMode(2);
                }
            });
            polyCullbox.add(Box.createGlue());
            polyCullbox.setBorder(new EmptyBorder(0, 0, 0, 20));
            polyPanel.add(polyCullbox);
            polyPanel.add(Box.createGlue());
            Box auxillaryPanel = new Box(1);
            Box box = new Box(0);
            auxillaryPanel.setBorder(new TitledBorder("Auxillary Elements"));
            box.add(Display3D.this.showAxesCheckBox);
            Display3D.this.showAxesCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Display3D.this.toggleAxes();
                }
            });
            box.add(Display3D.this.showBackgroundCheckBox);
            Display3D.this.showBackgroundCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Display3D.this.toggleBackdrop();
                }
            });
            box.add(Display3D.this.tooltips);
            Display3D.this.tooltips.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Display3D.this.usingToolTips = Display3D.this.tooltips.isSelected();
                    if (Display3D.this.toolTipBehavior != null) {
                        Display3D.this.toolTipBehavior.setCanShowToolTips(Display3D.this.usingToolTips);
                    }
                }
            });
            box.add(Box.createGlue());
            auxillaryPanel.add(box);
            box = new Box(0);
            box.add(Display3D.this.showSpotlightCheckBox);
            Display3D.this.showSpotlightCheckBox.setSelected(true);
            Display3D.this.showSpotlightCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Display3D.this.toggleSpotlight();
                }
            });
            box.add(Display3D.this.showAmbientLightCheckBox);
            Display3D.this.showAmbientLightCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Display3D.this.toggleAmbientLight();
                }
            });
            box.add(Box.createGlue());
            auxillaryPanel.add(box);
            Box optionsPanel = new Box(1);
            optionsPanel.add(outerBehaviorsPanel);
            optionsPanel.add(rotatePanel);
            optionsPanel.add(auxillaryPanel);
            optionsPanel.add(polyPanel);
            optionsPanel.add(resetBox);
            this.getContentPane().add(optionsPanel);
            this.setDefaultCloseOperation(1);
            Box b = new Box(0);
            b.add(new JLabel(" Save as Defaults for "));
            b.add(Display3D.this.appPreferences);
            b.add(Display3D.this.systemPreferences);
            this.getContentPane().add((Component)b, "South");
            Display3D.this.systemPreferences.putClientProperty("JComponent.sizeVariant", "mini");
            Display3D.this.systemPreferences.putClientProperty("JButton.buttonType", "bevel");
            Display3D.this.systemPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = Display3D.this.getPreferencesKey();
                    OptionPane3D.this.savePreferences(Prefs.getGlobalPreferences(key));
                    Prefs.removeAppPreferences(Display3D.this.simulation, key);
                }
            });
            Display3D.this.appPreferences.putClientProperty("JComponent.sizeVariant", "mini");
            Display3D.this.appPreferences.putClientProperty("JButton.buttonType", "bevel");
            Display3D.this.appPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = Display3D.this.getPreferencesKey();
                    OptionPane3D.this.savePreferences(Prefs.getAppPreferences(Display3D.this.simulation, key));
                }
            });
            this.pack();
            this.setResizable(false);
        }

        public void savePreferences(Preferences prefs) {
            try {
                prefs.putBoolean(ROTATE_LEFT_RIGHT_KEY, Display3D.this.orbitRotateXCheckBox.isSelected());
                prefs.putBoolean(ROTATE_UP_DOWN_KEY, Display3D.this.orbitRotateYCheckBox.isSelected());
                prefs.putBoolean(TRANSLATE_LEFT_RIGHT_KEY, Display3D.this.orbitTranslateXCheckBox.isSelected());
                prefs.putBoolean(TRANSLATE_UP_DOWN_KEY, Display3D.this.orbitTranslateYCheckBox.isSelected());
                prefs.putBoolean(MOVE_TOWARDS_AWAY_KEY, Display3D.this.orbitZoomCheckBox.isSelected());
                prefs.putBoolean(SELECT_KEY, Display3D.this.selectBehCheckBox.isSelected());
                prefs.putDouble(AUTO_ROTATE_X_KEY, Display3D.this.rotAxis_X.getValue());
                prefs.putDouble(AUTO_ROTATE_Y_KEY, Display3D.this.rotAxis_Y.getValue());
                prefs.putDouble(AUTO_ROTATE_Z_KEY, Display3D.this.rotAxis_Z.getValue());
                prefs.putDouble(AUTO_ROTATE_RATE_KEY, Display3D.this.spinDuration.getValue());
                prefs.putBoolean(AXES_KEY, Display3D.this.showAxesCheckBox.isSelected());
                prefs.putBoolean(TOOLTIPS_KEY, Display3D.this.tooltips.isSelected());
                prefs.putBoolean(SPOTLIGHT_KEY, Display3D.this.showSpotlightCheckBox.isSelected());
                prefs.putBoolean(AMBIENT_LIGHT_KEY, Display3D.this.showAmbientLightCheckBox.isSelected());
                prefs.putBoolean(BACKDROP_KEY, Display3D.this.showBackgroundCheckBox.isSelected());
                prefs.putInt(DRAW_POLYGONS_KEY, Display3D.this.polyPoint.isSelected() ? 0 : (Display3D.this.polyLine.isSelected() ? 1 : 2));
                prefs.putInt(DRAW_FACES_KEY, Display3D.this.polyCullNone.isSelected() ? 0 : (Display3D.this.polyCullBack.isSelected() ? 1 : 2));
                if (!Prefs.save(prefs)) {
                    Utilities.inform("Preferences Cannot be Saved", "Your Java system can't save preferences.  Perhaps this is an applet?", this);
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }

        void resetToPreferences() {
            try {
                Preferences systemPrefs = Prefs.getGlobalPreferences(Display3D.this.getPreferencesKey());
                Preferences appPrefs = Prefs.getAppPreferences(Display3D.this.simulation, Display3D.this.getPreferencesKey());
                Display3D.this.orbitRotateXCheckBox.setSelected(appPrefs.getBoolean(ROTATE_LEFT_RIGHT_KEY, systemPrefs.getBoolean(ROTATE_LEFT_RIGHT_KEY, true)));
                Display3D.this.orbitRotateYCheckBox.setSelected(appPrefs.getBoolean(ROTATE_UP_DOWN_KEY, systemPrefs.getBoolean(ROTATE_UP_DOWN_KEY, true)));
                Display3D.this.orbitTranslateXCheckBox.setSelected(appPrefs.getBoolean(TRANSLATE_LEFT_RIGHT_KEY, systemPrefs.getBoolean(TRANSLATE_LEFT_RIGHT_KEY, true)));
                Display3D.this.orbitTranslateYCheckBox.setSelected(appPrefs.getBoolean(TRANSLATE_UP_DOWN_KEY, systemPrefs.getBoolean(TRANSLATE_UP_DOWN_KEY, true)));
                Display3D.this.selectBehCheckBox.setSelected(appPrefs.getBoolean(SELECT_KEY, systemPrefs.getBoolean(SELECT_KEY, true)));
                Display3D.this.rotAxis_X.setValue(Display3D.this.rotAxis_X.newValue(appPrefs.getDouble(AUTO_ROTATE_X_KEY, systemPrefs.getDouble(AUTO_ROTATE_X_KEY, 0.0))));
                Display3D.this.rotAxis_Y.setValue(Display3D.this.rotAxis_Y.newValue(appPrefs.getDouble(AUTO_ROTATE_Y_KEY, systemPrefs.getDouble(AUTO_ROTATE_Y_KEY, 0.0))));
                Display3D.this.rotAxis_Z.setValue(Display3D.this.rotAxis_Z.newValue(appPrefs.getDouble(AUTO_ROTATE_Z_KEY, systemPrefs.getDouble(AUTO_ROTATE_Z_KEY, 0.0))));
                Display3D.this.spinDuration.setValue(Display3D.this.spinDuration.newValue(appPrefs.getDouble(AUTO_ROTATE_RATE_KEY, systemPrefs.getDouble(AUTO_ROTATE_RATE_KEY, 0.0))));
                Display3D.this.showAxesCheckBox.setSelected(appPrefs.getBoolean(AXES_KEY, systemPrefs.getBoolean(AXES_KEY, false)));
                Display3D.this.tooltips.setSelected(appPrefs.getBoolean(TOOLTIPS_KEY, systemPrefs.getBoolean(TOOLTIPS_KEY, false)));
                Display3D.this.showSpotlightCheckBox.setSelected(appPrefs.getBoolean(SPOTLIGHT_KEY, systemPrefs.getBoolean(SPOTLIGHT_KEY, true)));
                Display3D.this.showAmbientLightCheckBox.setSelected(appPrefs.getBoolean(AMBIENT_LIGHT_KEY, systemPrefs.getBoolean(AMBIENT_LIGHT_KEY, false)));
                Display3D.this.showBackgroundCheckBox.setSelected(appPrefs.getBoolean(BACKDROP_KEY, systemPrefs.getBoolean(BACKDROP_KEY, true)));
                int val = appPrefs.getInt(DRAW_POLYGONS_KEY, systemPrefs.getInt(DRAW_POLYGONS_KEY, Display3D.this.polyPoint.isSelected() ? 0 : (Display3D.this.polyLine.isSelected() ? 1 : 2)));
                if (val == 0) {
                    Display3D.this.polyPoint.setSelected(true);
                } else if (val == 1) {
                    Display3D.this.polyLine.setSelected(true);
                } else {
                    Display3D.this.polyFill.setSelected(true);
                }
                val = appPrefs.getInt(DRAW_FACES_KEY, systemPrefs.getInt(DRAW_FACES_KEY, Display3D.this.polyCullNone.isSelected() ? 0 : (Display3D.this.polyCullBack.isSelected() ? 1 : 2)));
                if (val == 0) {
                    Display3D.this.polyCullNone.setSelected(true);
                } else if (val == 1) {
                    Display3D.this.polyCullBack.setSelected(true);
                } else {
                    Display3D.this.polyCullFront.setSelected(true);
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    class Portrayal3DHolder {
        Portrayal3D portrayal;
        String name;
        JCheckBoxMenuItem menuItem;
        int subgraphIndex;
        boolean visible = true;

        public String toString() {
            return this.name;
        }

        Portrayal3DHolder(Portrayal3D p, String n, boolean visible) {
            this.portrayal = p;
            this.name = n;
            this.visible = visible;
            this.menuItem = new JCheckBoxMenuItem(this.name, visible);
            this.subgraphIndex = Display3D.this.subgraphCount++;
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Portrayal3DHolder.this.menuItem.isSelected()) {
                        Portrayal3DHolder.this.visible = true;
                        Display3D.this.portrayalSwitchMask.set(Portrayal3DHolder.this.subgraphIndex);
                    } else {
                        Portrayal3DHolder.this.visible = false;
                        Display3D.this.portrayalSwitchMask.clear(Portrayal3DHolder.this.subgraphIndex);
                    }
                    Display3D.this.portrayalSwitch.setChildMask(Display3D.this.portrayalSwitchMask);
                }
            });
        }
    }

    class LocalWindowListener
    extends WindowAdapter {
        LocalWindowListener() {
        }
    }
}

