/*
 * Decompiled with CFR 0.152.
 */
package sim.display3d;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.vecmath.Point3d;
import sim.display.GUIState;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.util.gui.WordWrap;

public class ToolTipBehavior
extends PickMouseBehavior {
    GUIState guiState = null;
    Canvas3D canvas;
    ActionListener timeUpNoMovement = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent value0) {
            ToolTipBehavior.this.showing = true;
            ToolTipBehavior.this.updateScene(ToolTipBehavior.this.lastPoint.x, ToolTipBehavior.this.lastPoint.y);
        }
    };
    WakeupCondition myWakeupCondition;
    Timer timer;
    Point lastPoint = null;
    boolean showing = false;
    boolean canShow = false;
    static final int CURSOR_SKIP = 20;

    public ToolTipBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds, GUIState guiState) {
        super(canvas, root, bounds);
        this.canvas = canvas;
        this.setSchedulingBounds(bounds);
        root.addChild((Node)this);
        this.pickCanvas.setMode(1024);
        this.guiState = guiState;
        this.timer = new Timer(ToolTipManager.sharedInstance().getInitialDelay(), this.timeUpNoMovement);
        this.timer.setRepeats(false);
    }

    public void initialize() {
        this.myWakeupCondition = new WakeupOr(new WakeupCriterion[]{new WakeupOnAWTEvent(503), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(504), new WakeupOnAWTEvent(505)});
        this.wakeupOn(this.myWakeupCondition);
    }

    public void setCanShowToolTips(boolean val) {
        this.canShow = val;
        if (!this.canShow) {
            DialogToolTip.hideToolTip();
            this.timer.stop();
            this.showing = false;
        }
    }

    public boolean getCanShowToolTips() {
        return this.canShow;
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        while (criteria.hasMoreElements()) {
            AWTEvent levt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            }
            if (!((levt = evt[evt.length - 1]) instanceof MouseEvent)) continue;
            MouseEvent mlevt = (MouseEvent)levt;
            int mlevtId = mlevt.getID();
            if (mlevtId == 505) {
                DialogToolTip.hideToolTip();
                this.timer.stop();
                this.showing = false;
                continue;
            }
            if (!this.canShow) continue;
            this.lastPoint = mlevt.getPoint();
            if (this.showing) {
                this.updateScene(this.lastPoint.x, this.lastPoint.y);
                continue;
            }
            this.timer.restart();
        }
        this.wakeupOn(this.myWakeupCondition);
    }

    public void updateScene(int xpos, int ypos) {
        PickResult pickResult = null;
        PickResult[] pickResults = null;
        Shape3D shape = null;
        this.pickCanvas.setShapeLocation(xpos, ypos);
        Point3d eyePos = this.pickCanvas.getStartPosition();
        if (!this.pickCanvas.getBranchGroup().isLive()) {
            return;
        }
        pickResults = this.pickCanvas.pickAllSorted();
        if (pickResults == null) {
            return;
        }
        LocationWrapper[] picks = new LocationWrapper[pickResults.length];
        int distinctObjectCount = 0;
        String htmlText = null;
        for (int i = 0; i < pickResults.length; ++i) {
            FieldPortrayal3D fPortrayal;
            PickIntersection pi;
            pickResult = pickResults[i];
            shape = (Shape3D)pickResult.getNode(1);
            LocationWrapper w = (LocationWrapper)shape.getUserData();
            if (w == null) continue;
            boolean duplicate = false;
            for (int j = 0; j < distinctObjectCount; ++j) {
                if (w != picks[j]) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            picks[distinctObjectCount++] = w;
            if (pickResult.numGeometryArrays() <= 0 || (pi = pickResult.getClosestIntersection(eyePos)) == null || (fPortrayal = (FieldPortrayal3D)w.getFieldPortrayal()) == null) continue;
            LocationWrapper filledLW = fPortrayal.completedWrapper(w, pi, pickResult);
            htmlText = htmlText == null ? fPortrayal.getName(filledLW) : htmlText + "<br>" + fPortrayal.getName(filledLW);
        }
        Point s = this.canvas.getLocationOnScreen();
        s.x += this.lastPoint.x;
        s.y += this.lastPoint.y + 20;
        if (htmlText != null) {
            htmlText = "<html><font size=\"-1\" face=\"" + WordWrap.toHTML(this.canvas.getFont().getFamily()) + "\">" + htmlText + "</font></html>";
        }
        DialogToolTip.showToolTip(s, htmlText);
    }

    static class DialogToolTip
    extends JDialog {
        static DialogToolTip tip = new DialogToolTip();
        static JLabel label = new JLabel("", 0);

        DialogToolTip() {
        }

        static void showToolTip(Point locationOnScreen, String htmlText) {
            if (htmlText == null) {
                tip.setVisible(false);
            } else {
                label.setText(htmlText);
                tip.pack();
                tip.pack();
                tip.setLocation(locationOnScreen);
                tip.setVisible(true);
            }
        }

        static void hideToolTip() {
            tip.setVisible(false);
        }

        static {
            tip.setUndecorated(true);
            tip.getContentPane().setBackground(Color.yellow);
            tip.getContentPane().setLayout(new BorderLayout());
            tip.getContentPane().add(label);
            tip.setModal(false);
            label.setBorder(new EmptyBorder(2, 2, 2, 2));
            label.setBackground(Color.yellow);
        }
    }
}

