/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.ThreadPool;
import sim.util.LocationLog;

public class ParallelSequence
extends Sequence {
    ThreadPool threads;
    boolean pleaseDie = false;
    Object operatingLock = new Object();
    boolean operating = false;
    boolean destroysThreads = false;
    int numThreads = 0;
    public static final int CPUS = -1;
    public static final int STEPPABLES = -2;
    static int availableProcessors = Runtime.getRuntime().availableProcessors();
    private static final long serialVersionUID = 1L;

    public boolean getDestroysThreads() {
        return this.destroysThreads;
    }

    public void setDestroysThreads(boolean val) {
        this.destroysThreads = val;
    }

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeBoolean(this.pleaseDie);
        p.writeBoolean(this.destroysThreads);
        p.writeInt(this.numThreads);
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.pleaseDie = p.readBoolean();
        this.destroysThreads = p.readBoolean();
        this.numThreads = p.readInt();
        this.operatingLock = new Object();
    }

    public Steppable getCleaner() {
        return new Steppable(){

            @Override
            public void step(SimState state) {
                ParallelSequence.this.cleanup();
            }
        };
    }

    public void cleanup() {
        this.pleaseDie = true;
        if (this.threads != null) {
            this.threads.killThreads();
        }
        this.pleaseDie = false;
        this.threads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public ParallelSequence(Steppable[] steps, int threads) {
        super(steps);
        this.numThreads = threads;
    }

    public ParallelSequence(Steppable[] steps) {
        this(steps, -2);
    }

    public ParallelSequence(Collection steps, int threads) {
        super(steps);
        this.numThreads = threads;
    }

    public ParallelSequence(Collection steps) {
        this(steps, -2);
    }

    @Override
    protected boolean canEnsureOrder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step(SimState state) {
        Object object = this.operatingLock;
        synchronized (object) {
            if (this.operating) {
                throw new RuntimeException("ParallelSequence stepped, but it's already in progress.\nProbably you have the same ParallelSequence nested, or the same ParallelSequence being stepped in parallel.\nEither way, it's a bug.");
            }
            this.operating = true;
        }
        this.loadSteps();
        if (this.threads == null) {
            this.threads = new ThreadPool();
        }
        int size = this.size;
        int n = this.numThreads;
        if (n == -1) {
            n = availableProcessors;
        } else if (n == -2) {
            n = size;
        }
        if (n > size) {
            n = size;
        }
        int jump = size / n;
        for (int i = 0; i < n; ++i) {
            this.threads.startThread(new Worker(state, i * jump, Math.min((i + 1) * jump, size), 1), "ParallelSequence");
        }
        if (this.destroysThreads) {
            this.cleanup();
        } else {
            this.threads.joinThreads();
        }
        this.operating = false;
    }

    class Worker
    implements Runnable {
        SimState state;
        int start;
        int end;
        int modulo;
        private static final long serialVersionUID = 1L;

        public Worker(SimState state, int start, int end, int modulo) {
            this.state = state;
            this.start = start;
            this.end = end;
            this.modulo = modulo;
        }

        @Override
        public void run() {
            Steppable[] steps = ParallelSequence.this.steps;
            int modulo = this.modulo;
            for (int s = this.start; s < this.end && !ParallelSequence.this.pleaseDie; s += modulo) {
                Steppable step = steps[s];
                assert (LocationLog.set(step));
                steps[s].step(this.state);
                assert (LocationLog.clear());
            }
        }
    }
}

