/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import ec.util.MersenneTwisterFast;
import java.util.Collection;
import sim.engine.Sequence;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.util.LocationLog;

public class RandomSequence
extends Sequence {
    private static final long serialVersionUID = 1L;
    final boolean shouldSynchronize;

    public RandomSequence(Steppable[] steps) {
        this(steps, false);
    }

    public RandomSequence(Steppable[] steps, boolean shouldSynchronize) {
        super(steps);
        this.shouldSynchronize = shouldSynchronize;
    }

    public RandomSequence(Collection steps) {
        this(steps, false);
    }

    public RandomSequence(Collection steps, boolean shouldSynchronize) {
        super(steps);
        this.shouldSynchronize = shouldSynchronize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextInt(SimState state, int n) {
        MersenneTwisterFast mersenneTwisterFast = state.random;
        synchronized (mersenneTwisterFast) {
            return state.random.nextInt(n);
        }
    }

    @Override
    protected boolean canEnsureOrder() {
        return false;
    }

    @Override
    public void step(SimState state) {
        int x;
        this.loadSteps();
        boolean shouldSynchronize = this.shouldSynchronize;
        int size = this.size;
        Steppable[] steps = this.steps;
        for (x = size - 1; x >= 1; --x) {
            int i = shouldSynchronize ? this.nextInt(state, x + 1) : state.random.nextInt(x + 1);
            Steppable temp = steps[i];
            steps[i] = steps[x];
            steps[x] = temp;
        }
        for (x = 0; x < size; ++x) {
            if (steps[x] == null) continue;
            assert (LocationLog.set(steps[x]));
            steps[x].step(state);
            assert (LocationLog.clear());
        }
    }
}

