/*
 * Decompiled with CFR 0.152.
 */
package sim.engine;

import sim.util.Bag;

class ThreadPool {
    Bag threads = new Bag();
    int totalThreads = 0;
    private static final long serialVersionUID = 1L;

    ThreadPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killThreads() {
        Bag bag = this.threads;
        synchronized (bag) {
            this.joinThreads();
            while (!this.threads.isEmpty()) {
                Node node;
                Node node2 = node = (Node)this.threads.pop();
                synchronized (node2) {
                    node.die = true;
                    node.notify();
                }
                try {
                    node.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.totalThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void joinThreads() {
        Bag bag = this.threads;
        synchronized (bag) {
            if (this.totalThreads > this.threads.size()) {
                try {
                    this.threads.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void startThread(Runnable run) {
        this.startThread(run, "ThreadPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startThread(Runnable run, String name) {
        Node node;
        Object object = this.threads;
        synchronized (object) {
            if (this.threads.isEmpty()) {
                node = new Node(name + " Thread " + this.totalThreads);
                node.thread.start();
                ++this.totalThreads;
            } else {
                node = (Node)this.threads.pop();
            }
        }
        object = node;
        synchronized (object) {
            node.toRun = run;
            node.go = true;
            node.notify();
        }
    }

    class Node
    implements Runnable {
        boolean die = false;
        boolean go = false;
        public Thread thread = new Thread(this);
        public Runnable toRun;

        public Node(String name) {
            this.thread.setDaemon(true);
            this.thread.setName(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (!this.go && !this.die) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.go = false;
                    if (this.die) {
                        this.die = false;
                        return;
                    }
                }
                this.toRun.run();
                this.toRun = null;
                object = ThreadPool.this.threads;
                synchronized (object) {
                    ThreadPool.this.threads.push(this);
                    if (ThreadPool.this.totalThreads == ThreadPool.this.threads.size()) {
                        ThreadPool.this.threads.notify();
                    }
                }
            }
        }
    }
}

