/*
 * Decompiled with CFR 0.152.
 */
package sim.field.continuous;

import java.util.Map;
import sim.field.SparseField;
import sim.field.SparseField2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.MutableInt2D;

public class Continuous2D
extends SparseField
implements SparseField2D {
    private static final long serialVersionUID = 1L;
    public Map doubleLocationHash = this.buildMap(0);
    public double width;
    public double height;
    public final double discretization;
    static final double SQRT_2_MINUS_1_DIV_2 = (Math.sqrt(2.0) - 1.0) * 0.5;
    static final int NEAREST_NEIGHBOR_GAIN = 10;
    MutableInt2D speedyMutableInt2D = new MutableInt2D();

    public Continuous2D(double discretization, double width, double height) {
        this.discretization = discretization;
        this.width = width;
        this.height = height;
    }

    public Continuous2D(Continuous2D other) {
        super(other);
        this.discretization = other.discretization;
        this.width = other.width;
        this.height = other.height;
    }

    public final Double2D getObjectLocation(Object obj) {
        return (Double2D)this.doubleLocationHash.get(obj);
    }

    @Override
    public final Double2D getObjectLocationAsDouble2D(Object obj) {
        return (Double2D)this.doubleLocationHash.get(obj);
    }

    @Override
    public final Double2D getDimensions() {
        return new Double2D(this.width, this.height);
    }

    public final Int2D discretize(Double2D location) {
        return new Int2D((int)(location.x / this.discretization), (int)(location.y / this.discretization));
    }

    public final Int2D discretize(Double2D location, int discretization) {
        return new Int2D((int)(location.x / (double)discretization), (int)(location.y / (double)discretization));
    }

    public final boolean setObjectLocation(Object obj, Double2D location) {
        boolean result = super.setObjectLocation(obj, this.discretize(location));
        if (result) {
            this.doubleLocationHash.put(obj, location);
        }
        return result;
    }

    @Override
    public final Bag clear() {
        this.doubleLocationHash = this.buildMap(0);
        return super.clear();
    }

    @Override
    public final Object remove(Object obj) {
        Object result = super.remove(obj);
        this.doubleLocationHash.remove(obj);
        return result;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public final double tx(double x) {
        double width = this.width;
        if (x >= 0.0 && x < width) {
            return x;
        }
        if ((x %= width) < 0.0) {
            x += width;
        }
        return x;
    }

    public final double ty(double y) {
        double height = this.height;
        if (y >= 0.0 && y < height) {
            return y;
        }
        if ((y %= height) < 0.0) {
            y += height;
        }
        return y;
    }

    public double stx(double x) {
        if (x >= 0.0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    public double sty(double y) {
        if (y >= 0.0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    double _stx(double x, double width) {
        if (x >= 0.0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    public double tdx(double x1, double x2) {
        double width = this.width;
        if (Math.abs(x1 - x2) <= width / 2.0) {
            return x1 - x2;
        }
        double dx = this._stx(x1, width) - this._stx(x2, width);
        if (dx * 2.0 > width) {
            return dx - width;
        }
        if (dx * 2.0 < -width) {
            return dx + width;
        }
        return dx;
    }

    double _sty(double y, double height) {
        if (y >= 0.0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public double tdy(double y1, double y2) {
        double height = this.height;
        if (Math.abs(y1 - y2) <= height / 2.0) {
            return y1 - y2;
        }
        double dy = this._sty(y1, height) - this._sty(y2, height);
        if (dy * 2.0 > height) {
            return dy - height;
        }
        if (dy * 2.0 < -height) {
            return dy + height;
        }
        return dy;
    }

    public double tds(Double2D d1, Double2D d2) {
        double dx = this.tdx(d1.x, d2.x);
        double dy = this.tdy(d1.y, d2.y);
        return dx * dx + dy * dy;
    }

    public Double2D tv(Double2D d1, Double2D d2) {
        return new Double2D(this.tdx(d1.x, d2.x), this.tdy(d1.y, d2.y));
    }

    public Bag getNearestNeighbors(Double2D position, int atLeastThisMany, boolean toroidal, boolean nonPointObjects, boolean radial, Bag result) {
        if (toroidal) {
            throw new InternalError("Toroidal not presently supported in getNearestNeighbors");
        }
        if (result == null) {
            result = new Bag(atLeastThisMany);
        } else {
            result.clear();
        }
        int maxSearches = this.allObjects.numObjs / 10;
        if (atLeastThisMany >= this.allObjects.numObjs) {
            result.clear();
            result.addAll(this.allObjects);
            return result;
        }
        Int2D d = this.discretize(position);
        int x1 = d.x;
        int x2 = d.x;
        int y1 = d.y;
        int y2 = d.y;
        int searches = 0;
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        if (searches >= maxSearches) {
            result.clear();
            result.addAll(this.allObjects);
            return result;
        }
        ++searches;
        speedyMutableInt2D.x = x1;
        speedyMutableInt2D.y = y1;
        Bag temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
        if (temp != null) {
            result.addAll(temp);
        }
        boolean nonPointOneMoreTime = false;
        block0: while (true) {
            int y;
            int x;
            if (result.numObjs >= atLeastThisMany) {
                if (!nonPointObjects || nonPointOneMoreTime) break;
                nonPointOneMoreTime = true;
            }
            ++x2;
            ++y2;
            speedyMutableInt2D.y = --y1;
            for (x = --x1; x <= x2; ++x) {
                if (searches >= maxSearches) {
                    result.clear();
                    result.addAll(this.allObjects);
                    return result;
                }
                ++searches;
                speedyMutableInt2D.x = x;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp == null) continue;
                result.addAll(temp);
            }
            speedyMutableInt2D.y = y2;
            for (x = x1; x <= x2; ++x) {
                if (searches >= maxSearches) {
                    result.clear();
                    result.addAll(this.allObjects);
                    return result;
                }
                ++searches;
                speedyMutableInt2D.x = x;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp == null) continue;
                result.addAll(temp);
            }
            speedyMutableInt2D.x = x1;
            for (y = y1 + 1; y <= y2 - 1; ++y) {
                if (searches >= maxSearches) {
                    result.clear();
                    result.addAll(this.allObjects);
                    return result;
                }
                ++searches;
                speedyMutableInt2D.y = y;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp == null) continue;
                result.addAll(temp);
            }
            speedyMutableInt2D.x = x2;
            y = y1 + 1;
            while (true) {
                if (y > y2 - 1) continue block0;
                if (searches >= maxSearches) {
                    result.clear();
                    result.addAll(this.allObjects);
                    return result;
                }
                ++searches;
                speedyMutableInt2D.y = y;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp != null) {
                    result.addAll(temp);
                }
                ++y;
            }
            break;
        }
        if (!radial) {
            return result;
        }
        int n = x2 - x1 + 1;
        int e = (int)Math.floor((double)n * SQRT_2_MINUS_1_DIV_2) + 1;
        int numAdditionalSearches = (x2 - x1 + 1) * e * 4;
        if (searches + numAdditionalSearches >= maxSearches) {
            result.clear();
            result.addAll(this.allObjects);
            return result;
        }
        for (int x = 0; x < x2 - x1 + 1; ++x) {
            for (int y = 0; y < e; ++y) {
                speedyMutableInt2D.x = x1 + x;
                speedyMutableInt2D.y = y1 - e - 1;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp != null) {
                    result.addAll(temp);
                }
                speedyMutableInt2D.x = x1 + x;
                speedyMutableInt2D.y = y2 + e + 1;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp != null) {
                    result.addAll(temp);
                }
                speedyMutableInt2D.x = x1 - e - 1;
                speedyMutableInt2D.y = y1 + x;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp != null) {
                    result.addAll(temp);
                }
                speedyMutableInt2D.x = x2 + e + 1;
                speedyMutableInt2D.y = y1 + x;
                temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                if (temp == null) continue;
                result.addAll(temp);
            }
        }
        return result;
    }

    public Bag getObjectsExactlyWithinDistance(Double2D position, double distance) {
        return this.getObjectsExactlyWithinDistance(position, distance, false, true, true, null);
    }

    public Bag getObjectsExactlyWithinDistance(Double2D position, double distance, boolean toroidal) {
        return this.getObjectsExactlyWithinDistance(position, distance, toroidal, true, true, null);
    }

    public Bag getObjectsExactlyWithinDistance(Double2D position, double distance, boolean toroidal, boolean radial, boolean inclusive, Bag result) {
        return this.getNeighborsExactlyWithinDistance(position, distance, toroidal, radial, inclusive, result);
    }

    public Bag getNeighborsExactlyWithinDistance(Double2D position, double distance) {
        return this.getNeighborsExactlyWithinDistance(position, distance, false, true, true, null);
    }

    public Bag getNeighborsExactlyWithinDistance(Double2D position, double distance, boolean toroidal) {
        return this.getNeighborsExactlyWithinDistance(position, distance, toroidal, true, true, null);
    }

    public Bag getNeighborsExactlyWithinDistance(Double2D position, double distance, boolean toroidal, boolean radial, boolean inclusive, Bag result) {
        result = this.getNeighborsWithinDistance(position, distance, toroidal, false, result);
        int numObjs = result.numObjs;
        Object[] objs = result.objs;
        double distsq = distance * distance;
        if (radial) {
            for (int i = 0; i < numObjs; ++i) {
                double d = 0.0;
                Double2D loc = this.getObjectLocation(objs[i]);
                d = toroidal ? this.tds(position, loc) : position.distanceSq(loc);
                if (!(d > distsq) && (inclusive || !(d >= distsq))) continue;
                result.remove(i);
                --i;
                --numObjs;
            }
        } else {
            for (int i = 0; i < numObjs; ++i) {
                Double2D loc = this.getObjectLocation(objs[i]);
                double minx = 0.0;
                double miny = 0.0;
                if (toroidal) {
                    minx = this.tdx(loc.x, position.x);
                    miny = this.tdy(loc.y, position.y);
                } else {
                    minx = loc.x - position.x;
                    miny = loc.y - position.y;
                }
                if (minx < 0.0) {
                    minx = -minx;
                }
                if (miny < 0.0) {
                    miny = -miny;
                }
                if (!(minx > distance) && !(miny > distance) && (inclusive || !(minx >= distance) && !(miny >= distance))) continue;
                result.remove(i);
                --i;
                --numObjs;
            }
        }
        return result;
    }

    public Bag getObjectsWithinDistance(Double2D position, double distance) {
        return this.getObjectsWithinDistance(position, distance, false, false, null);
    }

    public Bag getObjectsWithinDistance(Double2D position, double distance, boolean toroidal) {
        return this.getObjectsWithinDistance(position, distance, toroidal, false, null);
    }

    public Bag getObjectsWithinDistance(Double2D position, double distance, boolean toroidal, boolean nonPointObjects) {
        return this.getObjectsWithinDistance(position, distance, toroidal, nonPointObjects, null);
    }

    public Bag getObjectsWithinDistance(Double2D position, double distance, boolean toroidal, boolean nonPointObjects, Bag result) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, nonPointObjects, result);
    }

    public Bag getNeighborsWithinDistance(Double2D position, double distance) {
        return this.getNeighborsWithinDistance(position, distance, false, false, null);
    }

    public Bag getNeighborsWithinDistance(Double2D position, double distance, boolean toroidal) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, false, null);
    }

    public Bag getNeighborsWithinDistance(Double2D position, double distance, boolean toroidal, boolean nonPointObjects) {
        return this.getNeighborsWithinDistance(position, distance, toroidal, nonPointObjects, null);
    }

    public Bag getNeighborsWithinDistance(Double2D position, double distance, boolean toroidal, boolean nonPointObjects, Bag result) {
        if (toroidal && (position.x >= this.width || position.y >= this.height || position.x < 0.0 || position.y < 0.0)) {
            position = new Double2D(this.tx(position.x), this.ty(position.y));
        }
        double discDistance = distance / this.discretization;
        double discX = position.x / this.discretization;
        double discY = position.y / this.discretization;
        if (nonPointObjects) {
            discDistance += 1.0;
        }
        boolean expectedBagSize = true;
        if (result != null) {
            result.clear();
        } else {
            result = new Bag(1);
        }
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        if (toroidal) {
            int iWidth = (int)StrictMath.ceil(this.width / this.discretization);
            int iHeight = (int)StrictMath.ceil(this.height / this.discretization);
            int minX = (int)StrictMath.floor(discX - discDistance);
            int maxX = (int)StrictMath.floor(discX + discDistance);
            int minY = (int)StrictMath.floor(discY - discDistance);
            int maxY = (int)StrictMath.floor(discY + discDistance);
            if (position.x + distance >= this.width && maxX == iWidth - 1) {
                maxX = 0;
            }
            if (position.y + distance >= this.height && maxY == iHeight - 1) {
                maxY = 0;
            }
            if ((long)maxX - (long)minX >= (long)iWidth) {
                minX = 0;
                maxX = iWidth - 1;
            }
            if ((long)maxY - (long)minY >= (long)iHeight) {
                minY = 0;
                maxY = iHeight - 1;
            }
            int tmaxX = this.toroidal(maxX, iWidth);
            int tmaxY = this.toroidal(maxY, iHeight);
            int tminX = this.toroidal(minX, iWidth);
            int tminY = this.toroidal(minY, iHeight);
            int x = tminX;
            while (true) {
                int y = tminY;
                while (true) {
                    speedyMutableInt2D.x = ++x;
                    speedyMutableInt2D.y = ++y;
                    Bag temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                    if (temp != null && !temp.isEmpty()) {
                        int n = temp.numObjs;
                        if (n == 1) {
                            result.add(temp.objs[0]);
                        } else {
                            result.addAll(temp);
                        }
                    }
                    if (y == tmaxY) break;
                    if (y != iHeight - 1) continue;
                    y = 0;
                }
                if (x != tmaxX) {
                    if (x != iWidth - 1) continue;
                    x = 0;
                    continue;
                }
                break;
            }
        } else {
            int minX = (int)StrictMath.floor(discX - discDistance);
            int maxX = (int)StrictMath.floor(discX + discDistance);
            int minY = (int)StrictMath.floor(discY - discDistance);
            int maxY = (int)StrictMath.floor(discY + discDistance);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    speedyMutableInt2D.x = x;
                    speedyMutableInt2D.y = y;
                    Bag temp = this.getRawObjectsAtLocation(speedyMutableInt2D);
                    if (temp == null || temp.isEmpty()) continue;
                    int n = temp.numObjs;
                    if (n == 1) {
                        result.add(temp.objs[0]);
                        continue;
                    }
                    result.addAll(temp);
                }
            }
        }
        return result;
    }

    final int toroidal(int x, int width) {
        if (x >= 0) {
            return x % width;
        }
        int width2 = x % width + width;
        if (width2 < width) {
            return width2;
        }
        return 0;
    }

    public Bag getObjectsAtDiscretizedLocation(Int2D location) {
        return this.getRawObjectsAtLocation(location);
    }

    public Bag getObjectsAtLocation(Double2D location) {
        if (location == null) {
            return null;
        }
        Bag cell = this.getRawObjectsAtLocation(this.discretize(location));
        if (cell == null) {
            return null;
        }
        Bag result = new Bag();
        Object[] objs = cell.objs;
        int numObjs = cell.numObjs;
        for (int i = 0; i < numObjs; ++i) {
            Double2D loc = this.getObjectLocation(objs[i]);
            if (!((Object)loc).equals(location)) continue;
            result.add(objs[i]);
        }
        return result;
    }

    public int numObjectsAtLocation(Double2D location) {
        if (location == null) {
            return 0;
        }
        Bag cell = this.getRawObjectsAtLocation(this.discretize(location));
        if (cell == null) {
            return 0;
        }
        int count = 0;
        Object[] objs = cell.objs;
        int numObjs = cell.numObjs;
        for (int i = 0; i < numObjs; ++i) {
            Double2D loc = this.getObjectLocation(objs[i]);
            if (!((Object)loc).equals(location)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Bag getObjectsAtLocationOfObject(Object obj) {
        Double2D location = this.getObjectLocation(obj);
        if (location == null) {
            return null;
        }
        return this.getObjectsAtLocation((Object)location);
    }

    @Override
    public int numObjectsAtLocationOfObject(Object obj) {
        Double2D location = this.getObjectLocation(obj);
        if (location == null) {
            return 0;
        }
        return this.numObjectsAtLocation((Object)location);
    }

    public Bag removeObjectsAtLocation(Double2D location) {
        Bag bag = this.getObjectsAtLocation(location);
        if (bag != null) {
            Object[] objs = bag.objs;
            int numObjs = bag.numObjs;
            for (int i = 0; i < bag.numObjs; ++i) {
                this.remove(objs[i]);
            }
        }
        return bag;
    }
}

