/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import java.util.Collection;
import sim.field.grid.AbstractGrid2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.IntBag;

public class DenseGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public boolean removeEmptyBags = true;
    public boolean replaceLargeBags = true;
    public static final int INITIAL_BAG_SIZE = 16;
    public static final int MIN_BAG_SIZE = 32;
    public static final int LARGE_BAG_RATIO = 4;
    public static final int REPLACEMENT_BAG_RATIO = 2;
    public Bag[][] field;

    public DenseGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new Bag[width][height];
    }

    public Bag getObjectsAtLocation(int x, int y) {
        return this.field[x][y];
    }

    public Bag getObjectsAtLocation(Int2D location) {
        return this.getObjectsAtLocation(location.x, location.y);
    }

    public Bag removeObjectsAtLocation(int x, int y) {
        Bag b = this.field[x][y];
        this.field[x][y] = null;
        return b;
    }

    public Bag removeObjectsAtLocation(Int2D location) {
        return this.removeObjectsAtLocation(location.x, location.y);
    }

    public boolean removeObjectAtLocation(Object obj, int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return false;
        }
        boolean result = b.remove(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectAtLocation(Object obj, Int2D location) {
        return this.removeObjectAtLocation(obj, location.x, location.y);
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return false;
        }
        boolean result = b.removeMultiply(obj);
        int objsNumObjs = b.numObjs;
        if (this.removeEmptyBags && objsNumObjs == 0) {
            b = null;
        } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= b.objs.length) {
            b.shrink(objsNumObjs * 2);
        }
        return result;
    }

    public boolean removeObjectMultiplyAtLocation(Object obj, Int2D location) {
        return this.removeObjectMultiplyAtLocation(obj, location.x, location.y);
    }

    public boolean moveObject(Object obj, int fromX, int fromY, int toX, int toY) {
        boolean result = this.removeObjectAtLocation(obj, fromX, fromY);
        this.addObjectToLocation(obj, toX, toY);
        return result;
    }

    public boolean moveObject(Object obj, Int2D from, Int2D to) {
        return this.moveObject(obj, from.x, from.y, to.x, to.y);
    }

    public void moveObjects(int fromX, int fromY, int toX, int toY) {
        this.addObjectsToLocation(this.removeObjectsAtLocation(fromX, fromY), toX, toY);
    }

    public void moveObjects(Int2D from, Int2D to) {
        this.moveObjects(from.x, from.y, to.x, to.y);
    }

    public int numObjectsAtLocation(int x, int y) {
        Bag b = this.field[x][y];
        if (b == null) {
            return 0;
        }
        return b.numObjs;
    }

    public int numObjectsAtLocation(Int2D location) {
        return this.numObjectsAtLocation(location.x, location.y);
    }

    void buildBag(Bag[] fieldx, int y) {
        fieldx[y] = new Bag(16);
    }

    public void addObjectToLocation(Object obj, int x, int y) {
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].add(obj);
    }

    public void addObjectToLocation(Object obj, Int2D location) {
        this.addObjectToLocation(obj, location.x, location.y);
    }

    public void addObjectsToLocation(Bag objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(objs);
    }

    public void addObjectsToLocation(Bag objs, Int2D location) {
        this.addObjectsToLocation(objs, location.x, location.y);
    }

    public void addObjectsToLocation(Object[] objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(0, objs);
    }

    public void addObjectsToLocation(Object[] objs, Int2D location) {
        this.addObjectsToLocation(objs, location.x, location.y);
    }

    public void addObjectsToLocation(Collection objs, int x, int y) {
        if (objs == null) {
            return;
        }
        Bag[] fieldx = this.field[x];
        if (fieldx[y] == null) {
            this.buildBag(fieldx, y);
        }
        fieldx[y].addAll(objs);
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Bag[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] != null) {
                    bag.addAll(fieldx[y]);
                }
                fieldx[y] = null;
            }
        }
        return bag;
    }

    public Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getHexagonalNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighborsAndLocations(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        IntBag newXPos = new IntBag();
        IntBag newYPos = new IntBag();
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        for (int i = 0; i < len; ++i) {
            Bag temp = this.field[xPos.objs[i]][yPos.objs[i]];
            int size = temp.numObjs;
            Object[] os = temp.objs;
            for (int j = 0; j < size; ++j) {
                result.add(os[j]);
                newXPos.add(xs[i]);
                newYPos.add(ys[i]);
            }
        }
        xPos.clear();
        xPos.addAll(newXPos);
        yPos.clear();
        yPos.addAll(newYPos);
    }

    Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        for (int i = 0; i < len; ++i) {
            Bag temp = this.field[xPos.objs[i]][yPos.objs[i]];
            if (temp == null) continue;
            int n = temp.numObjs;
            if (n == 1) {
                result.add(temp.objs[0]);
                continue;
            }
            if (n <= 1) continue;
            result.addAll(temp);
        }
        return result;
    }
}

