/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.field.grid.IntGrid2D;
import sim.util.DoubleBag;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class DoubleGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public double[][] field;

    public double[][] getField() {
        return this.field;
    }

    public DoubleGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new double[width][height];
    }

    public DoubleGrid2D(int width, int height, double initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public DoubleGrid2D(DoubleGrid2D values) {
        this.setTo(values);
    }

    public DoubleGrid2D(double[][] values) {
        this.setTo(values);
    }

    public final void set(int x, int y, double val) {
        this.field[x][y] = val;
    }

    public final double get(int x, int y) {
        return this.field[x][y];
    }

    public final DoubleGrid2D setTo(double thisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = thisMuch;
            }
        }
        return this;
    }

    public DoubleGrid2D setTo(double[][] field) {
        int i;
        if (field == null) {
            throw new RuntimeException("DoubleGrid2D set to null field.");
        }
        int w = field.length;
        int h = 0;
        if (w != 0) {
            h = field[0].length;
        }
        for (i = 0; i < w; ++i) {
            if (field[i].length == h) continue;
            throw new RuntimeException("DoubleGrid2D initialized with a non-rectangular field.");
        }
        this.field = new double[w][h];
        for (i = 0; i < this.width; ++i) {
            this.field[i] = (double[])field[i].clone();
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public final DoubleGrid2D setTo(DoubleGrid2D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            this.field = new double[width][];
            for (int x = 0; x < width; ++x) {
                this.field[x] = (double[])values.field[x].clone();
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
            }
        }
        return this;
    }

    public final double[] toArray() {
        double[][] field = this.field;
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        double[] vals = new double[width * height];
        int i = 0;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                vals[i++] = fieldx[y];
            }
        }
        return vals;
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(max < fieldx[y])) continue;
                max = fieldx[y];
            }
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(min > fieldx[y])) continue;
                min = fieldx[y];
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                mean += fieldx[y];
                ++count;
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid2D upperBound(double toNoMoreThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(fieldx[y] > toNoMoreThanThisMuch)) continue;
                fieldx[y] = toNoMoreThanThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D lowerBound(double toNoLowerThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (!(fieldx[y] < toNoLowerThanThisMuch)) continue;
                fieldx[y] = toNoLowerThanThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D add(double withThisMuch) {
        int width = this.width;
        int height = this.height;
        if (withThisMuch == 0.0) {
            return this;
        }
        double[] fieldx = null;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D add(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] + (double)ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D add(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] * (double)ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D multiply(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
            }
        }
        return this;
    }

    public final DoubleGrid2D floor() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.floor(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D ceiling() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.ceil(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D truncate() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                if (fieldx[y] > 0.0) {
                    Math.floor(fieldx[y]);
                    continue;
                }
                Math.ceil(fieldx[y]);
            }
        }
        return this;
    }

    public final DoubleGrid2D rint() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldx[y] = Math.rint(fieldx[y]);
            }
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, result, xPos, yPos);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
        }
    }

    DoubleBag getObjectsAtLocations(IntBag xPos, IntBag yPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
        }
        return result;
    }
}

