/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid3D;
import sim.field.grid.IntGrid3D;
import sim.util.DoubleBag;
import sim.util.Int3D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class DoubleGrid3D
extends AbstractGrid3D {
    private static final long serialVersionUID = 1L;
    public double[][][] field;

    public DoubleGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new double[width][height][length];
    }

    public DoubleGrid3D(int width, int height, int length, double initialValue) {
        this(width, height, length);
        this.setTo(initialValue);
    }

    public DoubleGrid3D(DoubleGrid3D values) {
        this.setTo(values);
    }

    public final double set(int x, int y, int z, double val) {
        double returnval = this.field[x][y][z];
        this.field[x][y][z] = val;
        return returnval;
    }

    public final double get(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public final double[] toArray() {
        double[][][] field = this.field;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        double[] vals = new double[width * height * length];
        int i = 0;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    vals[i++] = fieldxy[z];
                }
            }
        }
        return vals;
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(max < fieldxy[z])) continue;
                    max = fieldxy[z];
                }
            }
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(min > fieldxy[z])) continue;
                    min = fieldxy[z];
                }
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    mean += fieldxy[z];
                    ++count;
                }
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid3D setTo(double thisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = thisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D setTo(DoubleGrid3D values) {
        if (this.width != values.width || this.height != values.height || this.length != values.length) {
            int width = this.width = values.width;
            int height = this.height = values.height;
            this.length = values.length;
            this.field = new double[width][height][];
            double[][] fieldx = null;
            for (int x = 0; x < width; ++x) {
                fieldx = this.field[x];
                for (int y = 0; y < height; ++y) {
                    fieldx[y] = (double[])values.field[x][y].clone();
                }
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    System.arraycopy(values.field[x][y], 0, this.field[x][y], 0, this.length);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D upperBound(double toNoMoreThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(fieldxy[z] > toNoMoreThanThisMuch)) continue;
                    fieldxy[z] = toNoMoreThanThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D lowerBound(double toNoLowerThanThisMuch) {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (!(fieldxy[z] < toNoLowerThanThisMuch)) continue;
                    fieldxy[z] = toNoLowerThanThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(double withThisMuch) {
        if (withThisMuch == 0.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] + withThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + (double)ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D add(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] + ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                int z = 0;
                while (z < length) {
                    int n = z++;
                    fieldxy[n] = fieldxy[n] * byThisMuch;
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(IntGrid3D withThis) {
        int[][][] otherField = withThis.field;
        int[][] ofieldx = null;
        int[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                ofieldxy = ofieldx[y];
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * (double)ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D multiply(DoubleGrid3D withThis) {
        double[][][] otherField = withThis.field;
        double[][] ofieldx = null;
        double[] ofieldxy = null;
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                ofieldxy = ofieldx[y];
                for (int z = 0; z < length; ++z) {
                    int n = z;
                    fieldxy[n] = fieldxy[n] * ofieldxy[z];
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D floor() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.floor(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D ceiling() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.ceil(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D truncate() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] > 0.0) {
                        Math.floor(fieldxy[z]);
                        continue;
                    }
                    Math.ceil(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public final DoubleGrid3D rint() {
        double[][] fieldx = null;
        double[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = Math.rint(fieldxy[z]);
                }
            }
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getMooreNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public DoubleBag getMooreNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getVonNeumannNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public DoubleBag getVonNeumannNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighbors(x, y, z, dist, mode, includeOrigin, result, xPos, yPos, zPos);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, DoubleBag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            result.add(val);
        }
    }

    DoubleBag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            result.add(val);
        }
        return result;
    }
}

