/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class IntGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public int[][] field;

    public IntGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new int[width][height];
    }

    public IntGrid2D(int width, int height, int initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public IntGrid2D(IntGrid2D values) {
        this.setTo(values);
    }

    public IntGrid2D(int[][] values) {
        this.setTo(values);
    }

    public final void set(int x, int y, int val) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        this.field[x][y] = val;
    }

    public final int get(int x, int y) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        return this.field[x][y];
    }

    public final IntGrid2D setTo(int thisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                fieldx[y] = thisMuch;
            }
        }
        return this;
    }

    public IntGrid2D setTo(int[][] field) {
        int i;
        if (field == null) {
            throw new RuntimeException("IntGrid2D set to null field.");
        }
        int w = field.length;
        int h = 0;
        if (w != 0) {
            h = field[0].length;
        }
        for (i = 0; i < w; ++i) {
            if (field[i].length == h) continue;
            throw new RuntimeException("IntGrid2D initialized with a non-rectangular field.");
        }
        this.field = new int[w][h];
        for (i = 0; i < w; ++i) {
            this.field[i] = (int[])field[i].clone();
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public final IntGrid2D setTo(IntGrid2D values) {
        int x;
        if (LocationLog.assertsEnabled) {
            for (x = 0; x < values.width; ++x) {
                for (int y = 0; y < values.height; ++y) {
                    assert (LocationLog.it(this, new Int2D(x, y)));
                }
            }
        }
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            int[][] nArrayArray = new int[width][];
            this.field = nArrayArray;
            int[][] field = nArrayArray;
            for (int x2 = 0; x2 < width; ++x2) {
                field[x2] = (int[])values.field[x2].clone();
            }
        } else {
            for (x = 0; x < this.width; ++x) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
            }
        }
        return this;
    }

    public final int[] toArray() {
        int[][] field = this.field;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int[] vals = new int[width * height];
        int i = 0;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                vals[i++] = fieldx[y];
            }
        }
        return vals;
    }

    public final int max() {
        int max = Integer.MIN_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (max >= fieldx[y]) continue;
                max = fieldx[y];
            }
        }
        return max;
    }

    public final int min() {
        int min = Integer.MAX_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (min <= fieldx[y]) continue;
                min = fieldx[y];
            }
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                mean += (double)fieldx[y];
                ++count;
            }
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final IntGrid2D upperBound(int toNoMoreThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (fieldx[y] <= toNoMoreThanThisMuch) continue;
                fieldx[y] = toNoMoreThanThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D lowerBound(int toNoLowerThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (fieldx[y] >= toNoLowerThanThisMuch) continue;
                fieldx[y] = toNoLowerThanThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D add(int withThisMuch) {
        if ((double)withThisMuch == 0.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D add(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
            }
        }
        return this;
    }

    public final IntGrid2D multiply(int byThisMuch) {
        if ((double)byThisMuch == 1.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
        }
        return this;
    }

    public final IntGrid2D multiply(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        for (int x = 0; x < width; ++x) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            for (int y = 0; y < height; ++y) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
            }
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public IntBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, result, xPos, yPos);
    }

    public IntBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag result) {
        if (result == null) {
            result = new IntBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            int val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
        }
    }

    IntBag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag result) {
        if (result == null) {
            result = new IntBag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            int val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
        }
        return result;
    }
}

