/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid3D;
import sim.util.Bag;
import sim.util.Int3D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class ObjectGrid3D
extends AbstractGrid3D {
    private static final long serialVersionUID = 1L;
    public Object[][][] field;

    public ObjectGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.field = new Object[width][height][length];
    }

    public ObjectGrid3D(int width, int height, int length, Object initialValue) {
        this(width, height, length);
        this.setTo(initialValue);
    }

    public ObjectGrid3D(ObjectGrid3D values) {
        this.setTo(values);
    }

    public final void set(int x, int y, int z, Object val) {
        this.field[x][y][z] = val;
    }

    public final Object get(int x, int y, int z) {
        return this.field[x][y][z];
    }

    public final ObjectGrid3D setTo(Object thisObj) {
        Object[][][] field = this.field;
        Object[][] fieldx = null;
        Object[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    fieldxy[z] = thisObj;
                }
            }
        }
        return this;
    }

    public final Object[] toArray() {
        Object[][][] field = this.field;
        Object[][] fieldx = null;
        Object[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        Object[] vals = new Object[width * height * length];
        int i = 0;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    vals[i++] = fieldxy[z];
                }
            }
        }
        return vals;
    }

    public final Bag elements() {
        Bag bag = new Bag();
        Object[][][] field = this.field;
        Object[][] fieldx = null;
        Object[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] == null) continue;
                    bag.add(fieldxy[z]);
                }
            }
        }
        return bag;
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Object[][][] field = this.field;
        Object[][] fieldx = null;
        Object[] fieldxy = null;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            fieldx = field[x];
            for (int y = 0; y < height; ++y) {
                fieldxy = fieldx[y];
                for (int z = 0; z < length; ++z) {
                    if (fieldxy[z] != null) {
                        bag.add(fieldxy[z]);
                    }
                    fieldxy[z] = null;
                }
            }
        }
        return bag;
    }

    public final ObjectGrid3D setTo(ObjectGrid3D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            int height = this.height = values.height;
            this.length = values.length;
            this.field = new Object[width][height][];
            Object[][][] field = this.field;
            Object[][][] ofield = values.field;
            Object[][] fieldx = null;
            Object[][] ofieldx = null;
            for (int x = 0; x < width; ++x) {
                fieldx = field[x];
                ofieldx = ofield[x];
                for (int y = 0; y < height; ++y) {
                    fieldx[y] = (Object[])ofieldx[y].clone();
                }
            }
        } else {
            Object[][][] field = this.field;
            Object[][][] ofield = values.field;
            Object[][] fieldx = null;
            Object[][] ofieldx = null;
            for (int x = 0; x < this.width; ++x) {
                fieldx = field[x];
                ofieldx = ofield[x];
                for (int y = 0; y < this.height; ++y) {
                    System.arraycopy(ofieldx[y], 0, fieldx[y], 0, this.length);
                }
            }
        }
        return this;
    }

    public Bag getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getMooreNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getMooreNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getVonNeumannNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighbors(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighborsAndLocations(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            Object val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            if (val != null) {
                result.add(val);
                continue;
            }
            xPos.remove(i);
            yPos.remove(i);
            --i;
        }
    }

    Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        for (int i = 0; i < xPos.numObjs; ++i) {
            assert (LocationLog.it(this, new Int3D(xPos.objs[i], yPos.objs[i], zPos.objs[i])));
            Object val = this.field[xPos.objs[i]][yPos.objs[i]][zPos.objs[i]];
            if (val == null) continue;
            result.add(val);
        }
        return result;
    }
}

