/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import java.util.Map;
import sim.field.SparseField;
import sim.field.SparseField3D;
import sim.field.grid.Grid3D;
import sim.util.Bag;
import sim.util.Double3D;
import sim.util.Int3D;
import sim.util.IntBag;
import sim.util.MutableInt3D;

public class SparseGrid3D
extends SparseField
implements Grid3D,
SparseField3D {
    private static final long serialVersionUID = 1L;
    protected int width;
    protected int height;
    protected int length;
    MutableInt3D speedyMutableInt3D = new MutableInt3D();

    public SparseGrid3D(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public SparseGrid3D(SparseGrid3D values) {
        super(values);
        this.width = values.width;
        this.height = values.height;
        this.length = values.length;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public final int tx(int x) {
        int width = this.width;
        if (x >= 0 && x < width) {
            return x;
        }
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    @Override
    public final int ty(int y) {
        int height = this.height;
        if (y >= 0 && y < height) {
            return y;
        }
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    @Override
    public final int tz(int z) {
        int length = this.length;
        if (z >= 0 && z < length) {
            return z;
        }
        if ((z %= length) < 0) {
            z += this.height;
        }
        return z;
    }

    @Override
    public int stx(int x) {
        if (x >= 0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    @Override
    public int sty(int y) {
        if (y >= 0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    @Override
    public int stz(int z) {
        if (z >= 0) {
            if (z < this.length) {
                return z;
            }
            return z - this.length;
        }
        return z + this.length;
    }

    final int stx(int x, int width) {
        if (x >= 0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    final int sty(int y, int height) {
        if (y >= 0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    public final int stz(int z, int length) {
        if (z >= 0) {
            if (z < length) {
                return z;
            }
            return z - length;
        }
        return z + length;
    }

    public int numObjectsAtLocation(int x, int y, int z) {
        MutableInt3D speedyMutableInt3D = this.speedyMutableInt3D;
        speedyMutableInt3D.x = x;
        speedyMutableInt3D.y = y;
        speedyMutableInt3D.z = z;
        return this.numObjectsAtLocation(speedyMutableInt3D);
    }

    public Bag getObjectsAtLocation(int x, int y, int z) {
        MutableInt3D speedyMutableInt3D = this.speedyMutableInt3D;
        speedyMutableInt3D.x = x;
        speedyMutableInt3D.y = y;
        speedyMutableInt3D.z = z;
        return this.getObjectsAtLocation(speedyMutableInt3D);
    }

    @Override
    public Double3D getObjectLocationAsDouble3D(Object obj) {
        Int3D loc = (Int3D)super.getRawObjectLocation(obj);
        if (loc == null) {
            return null;
        }
        return new Double3D(loc);
    }

    public Int3D getObjectLocation(Object obj) {
        return (Int3D)super.getRawObjectLocation(obj);
    }

    public Bag removeObjectsAtLocation(int x, int y, int z) {
        MutableInt3D speedyMutableInt3D = this.speedyMutableInt3D;
        speedyMutableInt3D.x = x;
        speedyMutableInt3D.y = y;
        speedyMutableInt3D.z = z;
        return this.removeObjectsAtLocation(speedyMutableInt3D);
    }

    public boolean setObjectLocation(Object obj, int x, int y, int z) {
        return super.setObjectLocation(obj, new Int3D(x, y, z));
    }

    public boolean setObjectLocation(Object obj, Int3D location) {
        return super.setObjectLocation(obj, location);
    }

    int tx(int x, int width, int widthtimestwo, int xpluswidth, int xminuswidth) {
        if (x >= -width && x < widthtimestwo) {
            if (x < 0) {
                return xpluswidth;
            }
            if (x < width) {
                return x;
            }
            return xminuswidth;
        }
        return this.tx2(x, width);
    }

    int tx2(int x, int width) {
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    int ty(int y, int height, int heighttimestwo, int yplusheight, int yminusheight) {
        if (y >= -height && y < heighttimestwo) {
            if (y < 0) {
                return yplusheight;
            }
            if (y < height) {
                return y;
            }
            return yminusheight;
        }
        return this.ty2(y, height);
    }

    int ty2(int y, int height) {
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    int tz(int z, int length, int lengthtimestwo, int zpluslength, int zminuslength) {
        if (z >= -length && z < lengthtimestwo) {
            if (z < 0) {
                return zpluslength;
            }
            if (z < length) {
                return z;
            }
            return zminuslength;
        }
        return this.tz2(z, length);
    }

    int tz2(int z, int length) {
        if ((z %= length) < 0) {
            z += length;
        }
        return z;
    }

    protected void removeOrigin(int x, int y, int z, IntBag xPos, IntBag yPos, IntBag zPos) {
        int size = xPos.size();
        for (int i = 0; i < size; ++i) {
            if (xPos.get(i) != x || yPos.get(i) != y || zPos.get(i) != z) continue;
            xPos.remove(i);
            yPos.remove(i);
            zPos.remove(i);
            return;
        }
    }

    protected void removeOriginToroidal(int x, int y, int z, IntBag xPos, IntBag yPos, IntBag zPos) {
        int size = xPos.size();
        x = this.tx(x, this.width, this.width * 2, x + this.width, x - this.width);
        y = this.ty(y, this.height, this.height * 2, y + this.height, y - this.height);
        z = this.tz(z, this.length, this.length * 2, z + this.length, z - this.length);
        for (int i = 0; i < size; ++i) {
            if (this.tx(xPos.get(i), this.width, this.width * 2, x + this.width, x - this.width) != x || this.ty(yPos.get(i), this.height, this.height * 2, y + this.height, y - this.height) != y || this.tz(zPos.get(i), this.length, this.length * 2, z + this.length, z - this.length) != z) continue;
            xPos.remove(i);
            yPos.remove(i);
            zPos.remove(i);
            return;
        }
    }

    @Override
    public void getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getMooreLocations(x, y, z, dist, toroidal ? 2 : 0, true, xPos, yPos, zPos);
    }

    @Override
    public void getMooreLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos, IntBag zPos) {
        boolean bounded;
        boolean toroidal = mode == 2;
        boolean bl = bounded = mode == 0;
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new RuntimeException("Mode must be either Grid3D.BOUNDED, Grid3D.UNBOUNDED, or Grid3D.TOROIDAL");
        }
        if (dist < 0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (xPos == null || yPos == null || zPos == null) {
            throw new RuntimeException("xPos and yPos and zPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        zPos.clear();
        int height = this.height;
        int width = this.width;
        int length = this.length;
        if (toroidal) {
            int zmin;
            int zmax;
            int ymin;
            int ymax;
            int xmax = x + dist;
            int xmin = x - dist;
            if (xmax - xmin >= width) {
                xmax = xmin + width - 1;
            }
            if ((ymax = y + dist) - (ymin = y - dist) >= height) {
                ymax = ymin + height - 1;
            }
            if ((zmax = z + dist) - (zmin = z - dist) >= length) {
                zmax = zmin + length - 1;
            }
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                int x_0 = this.tx(x0, width, width * 2, x0 + width, x0 - width);
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    int y_0 = this.ty(y0, height, height * 2, y0 + height, y0 - height);
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        int z_0 = this.tz(z0, length, length * 2, z0 + length, z0 - length);
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
            if (!includeOrigin) {
                this.removeOriginToroidal(x, y, z, xPos, yPos, zPos);
            }
        } else {
            int xmin = x - dist >= 0 || !bounded ? x - dist : 0;
            int xmax = x + dist <= width - 1 || !bounded ? x + dist : width - 1;
            int ymin = y - dist >= 0 || !bounded ? y - dist : 0;
            int ymax = y + dist <= height - 1 || !bounded ? y + dist : height - 1;
            int zmin = z - dist >= 0 || !bounded ? z - dist : 0;
            int zmax = z + dist <= length - 1 || !bounded ? z + dist : length - 1;
            for (int x0 = xmin; x0 <= xmax; ++x0) {
                for (int y0 = ymin; y0 <= ymax; ++y0) {
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        if (x0 == x && y0 == y && z0 == z) continue;
                        xPos.add(x0);
                        yPos.add(y0);
                        zPos.add(z0);
                    }
                }
            }
            if (!includeOrigin) {
                this.removeOrigin(x, y, z, xPos, yPos, zPos);
            }
        }
    }

    @Override
    public void getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getVonNeumannLocations(x, y, z, dist, toroidal ? 2 : 0, true, xPos, yPos, zPos);
    }

    @Override
    public void getVonNeumannLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos, IntBag zPos) {
        boolean bounded;
        boolean toroidal = mode == 2;
        boolean bl = bounded = mode == 0;
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new RuntimeException("Mode must be either Grid3D.BOUNDED, Grid3D.UNBOUNDED, or Grid3D.TOROIDAL");
        }
        if (dist < 0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (xPos == null || yPos == null || zPos == null) {
            throw new RuntimeException("xPos and yPos and zPos should not be null");
        }
        xPos.clear();
        yPos.clear();
        zPos.clear();
        int height = this.height;
        int width = this.width;
        int length = this.length;
        if (toroidal) {
            int xmin;
            int xmax = x + dist;
            for (int x0 = xmin = x - dist; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = this.tx(x0, width, width * 2, x0 + width, x0 - width);
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)); y0 <= ymax; ++y0) {
                    int zmin;
                    int y_0 = this.ty(y0, height, height * 2, y0 + height, y0 - height);
                    int zmax = z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0));
                    for (int z0 = zmin = z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)); z0 <= zmax; ++z0) {
                        int z_0 = this.tz(z0, length, length * 2, z0 + length, z0 - length);
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
            if (dist * 2 >= width || dist * 2 >= height || dist * 2 >= length) {
                int sz = xPos.size();
                Map map = this.buildMap(sz);
                for (int i = 0; i < sz; ++i) {
                    Double3D elem = new Double3D(xPos.get(i), yPos.get(i), zPos.get(i));
                    if (map.containsKey(elem)) {
                        xPos.remove(i);
                        yPos.remove(i);
                        zPos.remove(i);
                        --i;
                        --sz;
                        continue;
                    }
                    map.put(elem, elem);
                }
            }
            if (!includeOrigin) {
                this.removeOriginToroidal(x, y, z, xPos, yPos, zPos);
            }
        } else {
            int xmin;
            int xmax = x + dist <= width - 1 || !bounded ? x + dist : width - 1;
            for (int x0 = xmin = x - dist >= 0 || !bounded ? x - dist : 0; x0 <= xmax; ++x0) {
                int ymin;
                int x_0 = x0;
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) <= height - 1 || !bounded ? y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : height - 1;
                for (int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) >= 0 || !bounded ? y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : 0; y0 <= ymax; ++y0) {
                    int y_0 = y0;
                    int zmin = z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) >= 0 || !bounded ? z - (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) : 0;
                    int zmax = z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) <= length - 1 || !bounded ? z + (dist - (x0 - x >= 0 ? x0 - x : x - x0) - (y0 - y >= 0 ? y0 - y : y - y0)) : length - 1;
                    for (int z0 = zmin; z0 <= zmax; ++z0) {
                        int z_0 = z0;
                        if (x_0 == x && y_0 == y && z_0 == z) continue;
                        xPos.add(x_0);
                        yPos.add(y_0);
                        zPos.add(z_0);
                    }
                }
            }
            if (!includeOrigin) {
                this.removeOrigin(x, y, z, xPos, yPos, zPos);
            }
        }
    }

    public Bag getNeighborsMaxDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getMooreNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getMooreNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getMooreLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int z, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getVonNeumannNeighbors(x, y, z, dist, toroidal ? 2 : 0, true, result, xPos, yPos, zPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, z, dist, mode, includeOrigin, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        return this.getObjectsAtLocations(xPos, yPos, zPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        if (zPos == null) {
            zPos = new IntBag();
        }
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos, zPos);
        this.reduceObjectsAtLocations(xPos, yPos, zPos, result);
        return result;
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        IntBag newXPos = new IntBag();
        IntBag newYPos = new IntBag();
        IntBag newZPos = new IntBag();
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int[] zs = zPos.objs;
        for (int i = 0; i < len; ++i) {
            Bag temp = this.getObjectsAtLocation(xs[i], ys[i], zs[i]);
            if (temp == null) continue;
            int size = temp.numObjs;
            Object[] os = temp.objs;
            for (int j = 0; j < size; ++j) {
                result.add(os[j]);
                newXPos.add(xs[i]);
                newYPos.add(ys[i]);
                newZPos.add(zs[i]);
            }
        }
        xPos.clear();
        xPos.addAll(newXPos);
        yPos.clear();
        yPos.addAll(newYPos);
        zPos.clear();
        zPos.addAll(newZPos);
    }

    public Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag zPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int[] zs = zPos.objs;
        for (int i = 0; i < len; ++i) {
            Bag temp = this.getObjectsAtLocation(xs[i], ys[i], zs[i]);
            if (temp == null) continue;
            int n = temp.numObjs;
            if (n == 1) {
                result.add(temp.objs[0]);
                continue;
            }
            if (n <= 1) continue;
            result.addAll(temp);
        }
        return result;
    }

    double ds(double d1x, double d1y, double d1z, double d2x, double d2y, double d2z) {
        return (d1x - d2x) * (d1x - d2x) + (d1y - d2y) * (d1y - d2y) + (d1z - d2z) * (d1z - d2z);
    }

    boolean within(double d1x, double d1y, double d1z, double d2x, double d2y, double d2z, double distanceSquared, boolean closed) {
        double d = this.ds(d1x, d1y, d1z, d2x, d2y, d2z);
        return d < distanceSquared || d == distanceSquared && closed;
    }

    @Override
    public void getRadialLocations(int x, int y, int z, double dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos, IntBag zPos) {
        this.getRadialLocations(x, y, z, dist, mode, includeOrigin, 1026, true, xPos, yPos, zPos);
    }

    @Override
    public void getRadialLocations(int x, int y, int z, double dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, IntBag xPos, IntBag yPos, IntBag zPos) {
        boolean toroidal;
        boolean bl = toroidal = mode == 2;
        if (dist < 0.0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (measurementRule != 1026 && measurementRule != 1025 && measurementRule != 1024) {
            throw new RuntimeException(" Measurement rule must be one of ANY, ALL, or CENTER");
        }
        this.getMooreLocations(x, y, z, (int)Math.ceil(dist + 0.5), mode, includeOrigin, xPos, yPos, zPos);
        int len = xPos.size();
        double distsq = dist * dist;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        int widthtimestwo = width * 2;
        int heighttimestwo = height * 2;
        int lengthtimestwo = length * 2;
        for (int i = 0; i < len; ++i) {
            int xp = xPos.get(i);
            int yp = yPos.get(i);
            int zp = zPos.get(i);
            boolean remove = false;
            if (measurementRule == 1026) {
                if (z == zp) {
                    if (x == xp) {
                        double d;
                        remove = y < yp ? !((d = (double)yp - 0.5 - (double)y) < dist || d == dist && closed) : !((d = -((double)yp - 0.5 - (double)y)) < dist || d == dist && closed);
                    } else if (y == yp) {
                        double d;
                        remove = x < xp ? !((d = (double)xp - 0.5 - (double)x) < dist || d == dist && closed) : !((d = -((double)xp - 0.5 - (double)x)) < dist || d == dist && closed);
                    }
                } else if (x == xp) {
                    if (y == yp) {
                        double d;
                        remove = z < zp ? !((d = (double)zp - 0.5 - (double)z) < dist || d == dist && closed) : !((d = -((double)zp - 0.5 - (double)z)) < dist || d == dist && closed);
                    }
                } else {
                    remove = z < zp ? (x < xp ? (y < yp ? !this.within(x, y, z, (double)xp - 0.5, (double)yp - 0.5, (double)zp - 0.5, distsq, closed) : !this.within(x, y, z, (double)xp - 0.5, (double)yp + 0.5, (double)zp - 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, z, (double)xp + 0.5, (double)yp - 0.5, (double)zp - 0.5, distsq, closed) : !this.within(x, y, z, (double)xp + 0.5, (double)yp + 0.5, (double)zp - 0.5, distsq, closed))) : (x < xp ? (y < yp ? !this.within(x, y, z, (double)xp - 0.5, (double)yp - 0.5, (double)zp + 0.5, distsq, closed) : !this.within(x, y, z, (double)xp - 0.5, (double)yp + 0.5, (double)zp + 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, z, (double)xp + 0.5, (double)yp - 0.5, (double)zp + 0.5, distsq, closed) : !this.within(x, y, z, (double)xp + 0.5, (double)yp + 0.5, (double)zp + 0.5, distsq, closed)));
                }
            } else if (measurementRule == 1025) {
                remove = z < zp ? (x < xp ? (y < yp ? !this.within(x, y, z, (double)xp + 0.5, (double)yp + 0.5, (double)zp + 0.5, distsq, closed) : !this.within(x, y, z, (double)xp + 0.5, (double)yp - 0.5, (double)zp + 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, z, (double)xp - 0.5, (double)yp + 0.5, (double)zp + 0.5, distsq, closed) : !this.within(x, y, z, (double)xp - 0.5, (double)yp - 0.5, (double)zp + 0.5, distsq, closed))) : (x < xp ? (y < yp ? !this.within(x, y, z, (double)xp + 0.5, (double)yp + 0.5, (double)zp - 0.5, distsq, closed) : !this.within(x, y, z, (double)xp + 0.5, (double)yp - 0.5, (double)zp - 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, z, (double)xp - 0.5, (double)yp + 0.5, (double)zp - 0.5, distsq, closed) : !this.within(x, y, z, (double)xp - 0.5, (double)yp - 0.5, (double)zp - 0.5, distsq, closed)));
            } else {
                boolean bl2 = remove = !this.within(x, y, z, xp, yp, zp, distsq, closed);
            }
            if (remove) {
                xPos.remove(i);
                yPos.remove(i);
                zPos.remove(i);
                --i;
                --len;
                continue;
            }
            if (!toroidal) continue;
            int _x = xPos.get(i);
            int _y = yPos.get(i);
            int _z = zPos.get(i);
            xPos.set(i, this.tx(_x, width, widthtimestwo, _x + width, _x - width));
            yPos.set(i, this.ty(_y, height, heighttimestwo, _y + width, _y - width));
            zPos.set(i, this.tz(_z, length, lengthtimestwo, _z + length, _z - length));
        }
    }

    public Bag getRadialNeighbors(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighbors(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int z, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos, IntBag zPos) {
        return this.getRadialNeighborsAndLocations(x, y, z, dist, mode, includeOrigin, 1026, true, result, xPos, yPos, zPos);
    }

    @Override
    public final Double3D getDimensions() {
        return new Double3D(this.width, this.height, this.length);
    }
}

