/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal;
import sim.portrayal.Portrayal;
import sim.portrayal.Portrayal2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;

public abstract class FieldPortrayal2D
extends FieldPortrayal
implements Portrayal2D {
    SimplePortrayal2D simple = new SimplePortrayal2D();
    public static final int DEFAULT = 0;
    public static final int USE_BUFFER = 1;
    public static final int DONT_USE_BUFFER = 2;
    int buffering = 0;
    Object bufferingLock = new Object();

    public Point2D.Double getRelativeObjectPosition(Object location, Object otherObjectLocation, DrawInfo2D otherObjectInfo) {
        Serializable loc;
        double dx = 0.0;
        double dy = 0.0;
        if (location instanceof Int2D) {
            loc = (Int2D)location;
            Int2D oloc = (Int2D)otherObjectLocation;
            dx = loc.x - oloc.x;
            dy = loc.y - oloc.y;
        } else {
            loc = (Double2D)location;
            Double2D oloc = (Double2D)otherObjectLocation;
            dx = ((Double2D)loc).x - oloc.x;
            dy = ((Double2D)loc).y - oloc.y;
        }
        double xScale = otherObjectInfo.draw.width;
        double yScale = otherObjectInfo.draw.height;
        return new Point2D.Double(dx * xScale + otherObjectInfo.draw.x, dy * yScale + otherObjectInfo.draw.y);
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        this.hitOrDraw(graphics, info, null);
    }

    public void hitObjects(DrawInfo2D range, Bag putInHere) {
        this.hitOrDraw(null, range, putInHere);
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.simple;
    }

    public void setObjectPosition(Object object, Point2D.Double position, DrawInfo2D fieldPortrayalInfo) {
    }

    public Double2D getScale(DrawInfo2D fieldPortrayalInfo) {
        throw new RuntimeException("getScale not implemented in " + this.getClass());
    }

    public Object getPositionLocation(Point2D.Double position, DrawInfo2D fieldPortrayalInfo) {
        return null;
    }

    private final Object getObjectLocation(Object object) {
        return "";
    }

    public Object getObjectLocation(Object object, GUIState gui) {
        return null;
    }

    public Point2D.Double getLocationPosition(Object location, DrawInfo2D fieldPortrayalInfo) {
        return null;
    }

    public Object getClipLocation(DrawInfo2D info) {
        return this.getPositionLocation(new Point2D.Double(info.clip.x, info.clip.y), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D.Double getObjectPosition(Object object, DrawInfo2D fieldPortrayalInfo) {
        Schedule schedule = fieldPortrayalInfo.gui.state.schedule;
        synchronized (schedule) {
            Object location = this.getObjectLocation(object, fieldPortrayalInfo.gui);
            if (location == null) {
                return null;
            }
            return this.getLocationPosition(location, fieldPortrayalInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuffering() {
        Object object = this.bufferingLock;
        synchronized (object) {
            return this.buffering;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffering(int val) {
        Object object = this.bufferingLock;
        synchronized (object) {
            this.buffering = val;
        }
    }
}

