/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.portrayal.inspector.PropertyInspector;
import sim.util.Interval;
import sim.util.Properties;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.gui.PropertyField;

public class SimpleInspector
extends Inspector {
    public static final int DEFAULT_MAX_PROPERTIES = 25;
    int maxProperties = 25;
    GUIState state;
    LabelledList propertyList;
    Properties properties;
    PropertyField[] members = new PropertyField[0];
    int start = 0;
    int count = 0;
    JPanel header = new JPanel(){

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }
    };
    String listName;
    JLabel numElements = new JLabel();
    Box startField = null;
    JButton updateButton = null;

    public GUIState getGUIState() {
        return this.state;
    }

    public int getMaxProperties() {
        return this.maxProperties;
    }

    public SimpleInspector(Properties properties, GUIState state, String name, int maxProperties) {
        this.maxProperties = maxProperties;
        this.setLayout(new BorderLayout());
        this.state = state;
        this.listName = name;
        this.header.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.properties = properties;
        this.generateProperties(0);
        this.setTitle("" + properties.getObject());
    }

    public SimpleInspector(Properties properties, GUIState state, String name) {
        this(properties, state, name, 25);
    }

    public SimpleInspector(Object object, GUIState state) {
        this(object, state, null);
    }

    public SimpleInspector(Object object, GUIState state, String name) {
        this(object, state, name, 25);
    }

    public SimpleInspector(Object object, GUIState state, String name, int maxProperties) {
        this(Properties.getProperties(object), state, name, maxProperties);
    }

    JPopupMenu makePreliminaryPopup(final int index) {
        Class type = this.properties.getType(index);
        if (this.properties.isComposite(index)) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menu = new JMenuItem("View");
            menu.setEnabled(true);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties props = SimpleInspector.this.properties;
                    SimpleInspector simpleInspector = new SimpleInspector(props.getValue(index), SimpleInspector.this.state, null, SimpleInspector.this.maxProperties);
                    Stoppable stopper = simpleInspector.reviseStopper(SimpleInspector.this.state.scheduleRepeatingImmediatelyAfter(simpleInspector.getUpdateSteppable()));
                    SimpleInspector.this.state.controller.registerInspector(simpleInspector, stopper);
                    JFrame frame = simpleInspector.createFrame(stopper);
                    frame.setVisible(true);
                }
            });
            popup.add(menu);
            return popup;
        }
        return null;
    }

    PropertyField makePropertyField(final int index) {
        Class type = this.properties.getType(index);
        final Properties props = this.properties;
        return new PropertyField(null, this.properties.betterToString(this.properties.getValue(index)), this.properties.isReadWrite(index), this.properties.getDomain(index), this.properties.isComposite(index) ? 1 : (type == Boolean.TYPE || type == Boolean.class ? 0 : (this.properties.getDomain(index) == null ? 1 : (this.properties.getDomain(index) instanceof Interval ? 3 : 4)))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String newValue(String newValue) {
                Schedule schedule = SimpleInspector.this.state.state.schedule;
                synchronized (schedule) {
                    if (props.setValue(index, newValue) == null) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (SimpleInspector.this.state.controller != null) {
                        SimpleInspector.this.state.controller.refresh();
                    }
                    return props.betterToString(props.getValue(index));
                }
            }
        };
    }

    void doEnsuredRepaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (component != null) {
                    component.repaint();
                }
            }
        });
    }

    void generateProperties(int start) {
        final int len = this.properties.numProperties();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            return;
        }
        if (this.propertyList != null) {
            this.remove(this.propertyList);
        }
        this.propertyList = new LabelledList(this.listName);
        if (len > this.maxProperties) {
            String s = "Page forward/back through properties.  " + this.maxProperties + " properties shown at a time.";
            if (this.startField == null) {
                NumberTextField f = new NumberTextField(" Go to ", start, 1.0, this.maxProperties){

                    @Override
                    public double newValue(double newValue) {
                        int newIndex = (int)newValue;
                        if (newIndex < 0) {
                            newIndex = 0;
                        }
                        if (newIndex >= len) {
                            return (int)this.getValue();
                        }
                        SimpleInspector.this.generateProperties(newIndex);
                        return newIndex;
                    }
                };
                f.setToolTipText(s);
                this.numElements.setText(" of " + len + " ");
                this.numElements.setToolTipText(s);
                f.getField().setColumns(4);
                this.startField = new Box(0);
                this.startField.add(f);
                this.startField.add(this.numElements);
                this.startField.add(Box.createGlue());
                this.header.add((Component)this.startField, "Center");
            }
        } else {
            start = 0;
            if (this.startField != null) {
                this.header.remove(this.startField);
            }
        }
        this.members = new PropertyField[len];
        int end = start + this.maxProperties;
        if (end > len) {
            end = len;
        }
        this.count = end - start;
        for (int i = start; i < end; ++i) {
            if (!this.properties.isHidden(i)) {
                JLabel label = new JLabel(this.properties.getName(i) + " ");
                JToggleButton toggle = PropertyInspector.getPopupMenu(this.properties, i, this.state, this.makePreliminaryPopup(i));
                this.members[i] = this.makePropertyField(i);
                this.propertyList.add(null, label, toggle, this.members[i], null);
                String description = this.properties.getDescription(i);
                if (description == null) continue;
                if (label != null) {
                    label.setToolTipText(description);
                }
                if (toggle != null) {
                    toggle.setToolTipText(description);
                }
                if (this.members[i] == null) continue;
                this.members[i].setToolTipText(description);
                continue;
            }
            this.members[i] = null;
        }
        this.add((Component)this.propertyList, "Center");
        this.start = start;
        this.revalidate();
    }

    @Override
    public void setVolatile(boolean val) {
        super.setVolatile(val);
        if (this.isVolatile()) {
            if (this.updateButton != null) {
                this.header.remove(this.updateButton);
                this.revalidate();
            }
        } else if (this.updateButton == null) {
            this.updateButton = (JButton)this.makeUpdateButton();
            NumberTextField sacrificial = new NumberTextField(1.0, true);
            Dimension d = sacrificial.getPreferredSize();
            d.width = this.updateButton.getPreferredSize().width;
            this.updateButton.setPreferredSize(d);
            d = sacrificial.getMinimumSize();
            d.width = this.updateButton.getMinimumSize().width;
            this.updateButton.setMinimumSize(d);
            this.header.add((Component)this.updateButton, "West");
            this.revalidate();
        }
    }

    @Override
    public void updateInspector() {
        if (this.properties.isVolatile()) {
            this.remove(this.propertyList);
            this.generateProperties(this.start);
            this.doEnsuredRepaint(this);
        } else {
            for (int i = this.start; i < this.start + this.count; ++i) {
                if (this.members[i] == null) continue;
                this.members[i].setValue(this.properties.betterToString(this.properties.getValue(i)));
            }
        }
    }
}

