/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.FastHexaValueGridPortrayal2D;
import sim.portrayal.grid.HexaObjectGridPortrayal2D;
import sim.util.Valuable;
import sim.util.gui.ColorMap;

public class FastHexaObjectGridPortrayal2D
extends HexaObjectGridPortrayal2D {
    FastHexaValueGridPortrayal2D valueGridPortrayal;
    DoubleGrid2D grid;

    public FastHexaObjectGridPortrayal2D(boolean immutableField) {
        this.valueGridPortrayal = new FastHexaValueGridPortrayal2D("", this.immutableField);
        this.setImmutableField(immutableField);
    }

    public FastHexaObjectGridPortrayal2D() {
        this.valueGridPortrayal = new FastHexaValueGridPortrayal2D("", this.immutableField);
    }

    @Override
    public void setImmutableField(boolean immutableField) {
        super.setImmutableField(immutableField);
        this.valueGridPortrayal.setImmutableField(immutableField);
    }

    @Override
    public void setField(Object field) {
        super.setField(field);
        ObjectGrid2D og = (ObjectGrid2D)field;
        this.grid = new DoubleGrid2D(og.getWidth(), og.getHeight());
        this.valueGridPortrayal.setField(this.grid);
    }

    public double doubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Valuable) {
            return ((Valuable)obj).doubleValue();
        }
        return 1.0;
    }

    @Override
    public void reset() {
        this.valueGridPortrayal.reset();
    }

    @Override
    public void setDirtyField(boolean val) {
        this.valueGridPortrayal.setDirtyField(val);
    }

    @Override
    public boolean isDirtyField() {
        return this.valueGridPortrayal.isDirtyField();
    }

    public ColorMap getMap() {
        return this.valueGridPortrayal.getMap();
    }

    public void setMap(ColorMap m) {
        this.valueGridPortrayal.setMap(m);
    }

    @Override
    public int getBuffering() {
        return this.valueGridPortrayal.getBuffering();
    }

    @Override
    public void setBuffering(int val) {
        this.valueGridPortrayal.setBuffering(val);
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.field == null) {
            return;
        }
        ObjectGrid2D ogrid = (ObjectGrid2D)this.field;
        int maxX = ogrid.getWidth();
        int maxY = ogrid.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double divideByY = 1.0 + 2.0 * (double)maxY;
        double xScale = info.draw.width / divideByX;
        double yScale = info.draw.height / divideByY;
        int startx = (int)(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
        int starty = (int)((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
        int endx = (int)(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        for (int x = startx; x < endx; ++x) {
            double[] gridx = this.grid.field[x];
            Object[] ogridx = ogrid.field[x];
            for (int y = starty; y < endy; ++y) {
                gridx[y] = this.doubleValue(ogridx[y]);
            }
        }
        this.valueGridPortrayal.draw(object, graphics, info);
    }
}

