/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sim.engine.Schedule;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.simple.ValuePortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.MutableDouble;
import sim.util.MutableInt2D;
import sim.util.gui.ColorMap;
import sim.util.gui.SimpleColorMap;

public class ValueGridPortrayal2D
extends FieldPortrayal2D {
    ColorMap map = new SimpleColorMap();
    SimplePortrayal2D defaultPortrayal = new ValuePortrayal2D();
    String valueName;
    protected final MutableDouble valueToPass = new MutableDouble(0.0);
    protected final MutableInt2D locationToPass = new MutableInt2D(0, 0);

    public ColorMap getMap() {
        return this.map;
    }

    public void setMap(ColorMap m) {
        this.map = m;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof DoubleGrid2D) && !(field instanceof IntGrid2D)) {
            throw new RuntimeException("Invalid field for ValueGridPortrayal2D: " + field);
        }
        super.setField(field);
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String name) {
        this.valueName = name;
    }

    public ValueGridPortrayal2D() {
        this("Value");
    }

    public ValueGridPortrayal2D(String valueName) {
        this.valueName = valueName;
    }

    public double newValue(int x, int y, double value) {
        Grid2D field = (Grid2D)this.field;
        if (field instanceof IntGrid2D) {
            value = (int)value;
        }
        if (this.map.validLevel(value)) {
            return value;
        }
        if (field != null) {
            if (field instanceof DoubleGrid2D) {
                return ((DoubleGrid2D)field).field[x][y];
            }
            return ((IntGrid2D)field).field[x][y];
        }
        return this.map.defaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Grid2D field = (Grid2D)this.field;
            if (field == null) {
                return null;
            }
            int maxX = field.getWidth();
            int maxY = field.getHeight();
            double xScale = info.draw.width / (double)maxX;
            double yScale = info.draw.height / (double)maxY;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D info) {
        Double2D scale = this.getScale(info);
        double xScale = scale.x;
        double yScale = scale.y;
        int startx = (int)((position.getX() - info.draw.x) / xScale);
        int starty = (int)((position.getY() - info.draw.y) / yScale);
        return new Int2D(startx, starty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Grid2D field = (Grid2D)this.field;
            if (field == null) {
                return null;
            }
            int maxX = field.getWidth();
            int maxY = field.getHeight();
            if (maxX == 0 || maxY == 0) {
                return null;
            }
            double xScale = info.draw.width / (double)maxX;
            double yScale = info.draw.height / (double)maxY;
            DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
            newinfo.precise = info.precise;
            Int2D loc = (Int2D)location;
            if (location == null) {
                return null;
            }
            int x = loc.x;
            int y = loc.y;
            newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
            newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
            newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
            newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
            newinfo.draw.x += newinfo.draw.width / 2.0;
            newinfo.draw.y += newinfo.draw.height / 2.0;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : (double[][])null;
        int[][] intField = isDoubleGrid2D ? (int[][])null : ((IntGrid2D)field).field;
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        newinfo.precise = info.precise;
        newinfo.location = this.locationToPass;
        newinfo.fieldPortrayal = this;
        Portrayal p = this.getPortrayalForObject(this.valueToPass);
        if (!(p instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + this.valueToPass + " -- expected a SimplePortrayal2D");
        }
        SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        for (int x = startx; x < endx; ++x) {
            for (int y = starty; y < endy; ++y) {
                this.valueToPass.val = isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y];
                newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
                newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
                newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
                newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
                newinfo.draw.x += newinfo.draw.width / 2.0;
                newinfo.draw.y += newinfo.draw.height / 2.0;
                this.locationToPass.x = x;
                this.locationToPass.y = y;
                if (graphics == null) {
                    if (!portrayal.hitObject(this.valueToPass, newinfo)) continue;
                    putInHere.add(this.getWrapper(this.valueToPass.val, new Int2D(x, y)));
                    continue;
                }
                portrayal.draw(this.valueToPass, graphics, newinfo);
            }
        }
    }

    public LocationWrapper getWrapper(double val, Int2D loc) {
        final Grid2D field = (Grid2D)this.field;
        return new LocationWrapper(new MutableDouble(val), loc, this){

            @Override
            public Object getObject() {
                Int2D loc = (Int2D)this.location;
                MutableDouble val = (MutableDouble)this.object;
                val.val = field instanceof DoubleGrid2D ? ((DoubleGrid2D)field).field[loc.x][loc.y] : (double)((IntGrid2D)field).field[loc.x][loc.y];
                return val;
            }

            @Override
            public String getLocationName() {
                return ((Int2D)this.location).toCoordinates();
            }
        };
    }
}

